/*
 * Decompiled with CFR 0.152.
 */
package vazkii.zetaimplforge.registry;

import java.util.Collection;
import java.util.function.Supplier;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.IForgeRegistry;
import vazkii.zeta.registry.ZetaRegistry;
import vazkii.zetaimplforge.ForgeZeta;

public class ForgeZetaRegistry
extends ZetaRegistry {
    public ForgeZetaRegistry(ForgeZeta z) {
        super(z);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(e -> this.register(e.getRegistryKey(), e.getForgeRegistry()));
    }

    private <T> void register(ResourceKey<? extends Registry<?>> key, IForgeRegistry<T> registry) {
        ResourceLocation registryRes = key.m_135782_();
        Collection<Supplier<Object>> ourEntries = this.getDefers(registryRes);
        if (ourEntries != null && !ourEntries.isEmpty()) {
            if (registry == null) {
                this.z.log.error(registryRes + " does not have a forge registry");
                return;
            }
            for (Supplier<Object> supplier : ourEntries) {
                Object entry = supplier.get();
                ResourceLocation name = this.getInternalName(entry);
                this.z.log.debug("Registering to " + registryRes + " - " + name);
                registry.register(name, entry);
            }
            this.clearDeferCache(registryRes);
        }
    }
}

