/*
 * Decompiled with CFR 0.152.
 */
package vazkii.zetaimplforge.registry;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionBrewing;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraftforge.registries.ForgeRegistries;
import vazkii.quark.mixin.accessor.AccessorPotionBrewing;
import vazkii.zeta.event.ZCommonSetup;
import vazkii.zeta.event.bus.LoadEvent;
import vazkii.zeta.registry.BrewingRegistry;
import vazkii.zetaimplforge.ForgeZeta;

public class ForgeBrewingRegistry
extends BrewingRegistry {
    private List<DelayedPotion> delayedPotions = new ArrayList<DelayedPotion>();
    private boolean okToRegisterImmediately = false;

    public ForgeBrewingRegistry(ForgeZeta zeta) {
        super(zeta);
        zeta.loadBus.subscribe(this);
    }

    @Override
    public void addBrewingRecipe(Potion input, Supplier<Ingredient> reagentSupplier, Potion output) {
        DelayedPotion d = new DelayedPotion(input, reagentSupplier, output);
        if (this.okToRegisterImmediately) {
            d.register();
        } else {
            this.delayedPotions.add(d);
        }
    }

    @LoadEvent
    public void commonSetup(ZCommonSetup event) {
        event.enqueueWork(() -> {
            this.okToRegisterImmediately = true;
            this.delayedPotions.forEach(DelayedPotion::register);
            this.delayedPotions = null;
        });
    }

    private record DelayedPotion(Potion input, Supplier<Ingredient> reagentSupplier, Potion output) {
        void register() {
            AccessorPotionBrewing.quark$getPotionMixes().add((PotionBrewing.Mix<Potion>)new PotionBrewing.Mix(ForgeRegistries.POTIONS, (Object)this.input, this.reagentSupplier.get(), (Object)this.output));
        }
    }
}

