/*
 * Decompiled with CFR 0.152.
 */
package vazkii.zetaimplforge.network;

import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.NetworkRegistry;
import net.minecraftforge.network.simple.SimpleChannel;
import org.jetbrains.annotations.VisibleForTesting;
import vazkii.zeta.network.IZetaMessage;
import vazkii.zeta.network.ZetaNetworkDirection;
import vazkii.zeta.network.ZetaNetworkHandler;
import vazkii.zetaimplforge.network.ForgeNetworkEventContextImpl;

public class ForgeZetaNetworkHandler
extends ZetaNetworkHandler {
    @VisibleForTesting
    public final SimpleChannel channel;
    private int i = 0;

    public ForgeZetaNetworkHandler(String modid, int protocolVersion) {
        super(modid, protocolVersion);
        String protocolStr = Integer.toString(protocolVersion);
        this.channel = NetworkRegistry.ChannelBuilder.named((ResourceLocation)new ResourceLocation(modid, "main")).networkProtocolVersion(() -> protocolStr).clientAcceptedVersions(protocolStr::equals).serverAcceptedVersions(protocolStr::equals).simpleChannel();
    }

    @Override
    public <T extends IZetaMessage> void register(Class<T> clazz, ZetaNetworkDirection dir) {
        BiConsumer<IZetaMessage, FriendlyByteBuf> encoder = this.serializer::writeObject;
        NetworkDirection forgeDir = ForgeZetaNetworkHandler.toForge(dir);
        Function<FriendlyByteBuf, IZetaMessage> decoder = buf -> {
            try {
                IZetaMessage msg = (IZetaMessage)clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                this.serializer.readObject(msg, (FriendlyByteBuf)buf);
                return msg;
            }
            catch (ReflectiveOperationException e) {
                throw new RuntimeException(e);
            }
        };
        BiConsumer<IZetaMessage, Supplier> consumer = (msg, supp) -> {
            NetworkEvent.Context context = (NetworkEvent.Context)supp.get();
            if (context.getDirection() != forgeDir) {
                return;
            }
            context.setPacketHandled(msg.receive(new ForgeNetworkEventContextImpl(context)));
        };
        this.channel.registerMessage(this.i, clazz, encoder, decoder, consumer);
        ++this.i;
    }

    @Override
    public void sendToPlayer(IZetaMessage msg, ServerPlayer player) {
        this.channel.sendTo((Object)msg, player.f_8906_.f_9742_, NetworkDirection.PLAY_TO_CLIENT);
    }

    @Override
    public void sendToServer(IZetaMessage msg) {
        this.channel.sendToServer((Object)msg);
    }

    public static ZetaNetworkDirection fromForge(NetworkDirection dir) {
        return switch (dir) {
            case NetworkDirection.PLAY_TO_SERVER -> ZetaNetworkDirection.PLAY_TO_SERVER;
            case NetworkDirection.PLAY_TO_CLIENT -> ZetaNetworkDirection.PLAY_TO_CLIENT;
            default -> throw new UnsupportedOperationException("unknown net direction " + dir);
        };
    }

    public static NetworkDirection toForge(ZetaNetworkDirection dir) {
        return switch (dir) {
            default -> throw new IncompatibleClassChangeError();
            case ZetaNetworkDirection.PLAY_TO_SERVER -> NetworkDirection.PLAY_TO_SERVER;
            case ZetaNetworkDirection.PLAY_TO_CLIENT -> NetworkDirection.PLAY_TO_CLIENT;
        };
    }
}

