/*
 * Decompiled with CFR 0.152.
 */
package vazkii.zeta.util;

import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.ItemStack;

public final class ItemNBTHelper {
    public static boolean detectNBT(ItemStack stack) {
        return stack.m_41782_();
    }

    public static void initNBT(ItemStack stack) {
        if (!ItemNBTHelper.detectNBT(stack)) {
            ItemNBTHelper.injectNBT(stack, new CompoundTag());
        }
    }

    public static void injectNBT(ItemStack stack, CompoundTag nbt) {
        stack.m_41751_(nbt);
    }

    public static CompoundTag getNBT(ItemStack stack) {
        ItemNBTHelper.initNBT(stack);
        return stack.m_41783_();
    }

    public static void setBoolean(ItemStack stack, String tag, boolean b) {
        ItemNBTHelper.getNBT(stack).m_128379_(tag, b);
    }

    public static void setByte(ItemStack stack, String tag, byte b) {
        ItemNBTHelper.getNBT(stack).m_128344_(tag, b);
    }

    public static void setShort(ItemStack stack, String tag, short s) {
        ItemNBTHelper.getNBT(stack).m_128376_(tag, s);
    }

    public static void setInt(ItemStack stack, String tag, int i) {
        ItemNBTHelper.getNBT(stack).m_128405_(tag, i);
    }

    public static void setLong(ItemStack stack, String tag, long l) {
        ItemNBTHelper.getNBT(stack).m_128356_(tag, l);
    }

    public static void setFloat(ItemStack stack, String tag, float f) {
        ItemNBTHelper.getNBT(stack).m_128350_(tag, f);
    }

    public static void setDouble(ItemStack stack, String tag, double d) {
        ItemNBTHelper.getNBT(stack).m_128347_(tag, d);
    }

    public static void setCompound(ItemStack stack, String tag, CompoundTag cmp) {
        if (!tag.equalsIgnoreCase("ench")) {
            ItemNBTHelper.getNBT(stack).m_128365_(tag, (Tag)cmp);
        }
    }

    public static void setString(ItemStack stack, String tag, String s) {
        ItemNBTHelper.getNBT(stack).m_128359_(tag, s);
    }

    public static void setList(ItemStack stack, String tag, ListTag list) {
        ItemNBTHelper.getNBT(stack).m_128365_(tag, (Tag)list);
    }

    public static boolean verifyExistence(ItemStack stack, String tag) {
        return !stack.m_41619_() && ItemNBTHelper.detectNBT(stack) && ItemNBTHelper.getNBT(stack).m_128441_(tag);
    }

    @Deprecated
    public static boolean verifyExistance(ItemStack stack, String tag) {
        return ItemNBTHelper.verifyExistence(stack, tag);
    }

    public static boolean getBoolean(ItemStack stack, String tag, boolean defaultExpected) {
        return ItemNBTHelper.verifyExistence(stack, tag) ? ItemNBTHelper.getNBT(stack).m_128471_(tag) : defaultExpected;
    }

    public static byte getByte(ItemStack stack, String tag, byte defaultExpected) {
        return ItemNBTHelper.verifyExistence(stack, tag) ? ItemNBTHelper.getNBT(stack).m_128445_(tag) : defaultExpected;
    }

    public static short getShort(ItemStack stack, String tag, short defaultExpected) {
        return ItemNBTHelper.verifyExistence(stack, tag) ? ItemNBTHelper.getNBT(stack).m_128448_(tag) : defaultExpected;
    }

    public static int getInt(ItemStack stack, String tag, int defaultExpected) {
        return ItemNBTHelper.verifyExistence(stack, tag) ? ItemNBTHelper.getNBT(stack).m_128451_(tag) : defaultExpected;
    }

    public static long getLong(ItemStack stack, String tag, long defaultExpected) {
        return ItemNBTHelper.verifyExistence(stack, tag) ? ItemNBTHelper.getNBT(stack).m_128454_(tag) : defaultExpected;
    }

    public static float getFloat(ItemStack stack, String tag, float defaultExpected) {
        return ItemNBTHelper.verifyExistence(stack, tag) ? ItemNBTHelper.getNBT(stack).m_128457_(tag) : defaultExpected;
    }

    public static double getDouble(ItemStack stack, String tag, double defaultExpected) {
        return ItemNBTHelper.verifyExistence(stack, tag) ? ItemNBTHelper.getNBT(stack).m_128459_(tag) : defaultExpected;
    }

    public static CompoundTag getCompound(ItemStack stack, String tag, boolean nullifyOnFail) {
        return ItemNBTHelper.verifyExistence(stack, tag) ? ItemNBTHelper.getNBT(stack).m_128469_(tag) : (nullifyOnFail ? null : new CompoundTag());
    }

    public static String getString(ItemStack stack, String tag, String defaultExpected) {
        return ItemNBTHelper.verifyExistence(stack, tag) ? ItemNBTHelper.getNBT(stack).m_128461_(tag) : defaultExpected;
    }

    public static ListTag getList(ItemStack stack, String tag, int objtype, boolean nullifyOnFail) {
        return ItemNBTHelper.verifyExistence(stack, tag) ? ItemNBTHelper.getNBT(stack).m_128437_(tag, objtype) : (nullifyOnFail ? null : new ListTag());
    }
}

