/*
 * Decompiled with CFR 0.152.
 */
package vazkii.zeta.registry;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import java.util.Collection;
import java.util.IdentityHashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import net.minecraft.client.color.block.BlockColor;
import net.minecraft.client.color.item.ItemColor;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import vazkii.zeta.Zeta;
import vazkii.zeta.registry.IZetaBlockColorProvider;
import vazkii.zeta.registry.IZetaBlockItemProvider;
import vazkii.zeta.registry.IZetaItemColorProvider;
import vazkii.zeta.registry.IZetaItemPropertiesFiller;

public abstract class ZetaRegistry {
    protected final Zeta z;
    private final Multimap<ResourceLocation, Supplier<Object>> defers = ArrayListMultimap.create();
    private final Map<Object, ResourceLocation> internalNames = new IdentityHashMap<Object, ResourceLocation>();
    private final Map<Item, IZetaItemColorProvider> itemColors = new IdentityHashMap<Item, IZetaItemColorProvider>();
    private final Map<Block, IZetaBlockColorProvider> blockColors = new IdentityHashMap<Block, IZetaBlockColorProvider>();
    private final Map<ResourceLocation, CreativeModeTab> groups = new LinkedHashMap<ResourceLocation, CreativeModeTab>();

    public ZetaRegistry(Zeta z) {
        this.z = z;
    }

    public <T> ResourceLocation getRegistryName(T obj, Registry<T> registry) {
        if (this.internalNames.containsKey(obj)) {
            return this.getInternalName(obj);
        }
        return registry.m_7981_(obj);
    }

    public void setInternalName(Object obj, ResourceLocation name) {
        this.internalNames.put(obj, name);
    }

    public ResourceLocation getInternalName(Object obj) {
        return this.internalNames.get(obj);
    }

    public <T> void register(T obj, String resloc, ResourceKey<Registry<T>> registry) {
        this.register(obj, this.newResourceLocation(resloc), registry);
    }

    public <T> void register(T obj, ResourceLocation id, ResourceKey<Registry<T>> registry) {
        if (obj == null) {
            throw new IllegalArgumentException("Can't register null object.");
        }
        this.setInternalName(obj, id);
        this.defers.put((Object)registry.m_135782_(), () -> obj);
    }

    public ResourceLocation newResourceLocation(String in) {
        if (in.indexOf(58) == -1) {
            return new ResourceLocation(this.z.modid, in);
        }
        return new ResourceLocation(in);
    }

    public <T> void register(T obj, ResourceKey<Registry<T>> registry) {
        if (obj == null) {
            throw new IllegalArgumentException("Can't register null object.");
        }
        if (this.getInternalName(obj) == null) {
            throw new IllegalArgumentException("Can't register object without registry name.");
        }
        this.defers.put((Object)registry.m_135782_(), () -> obj);
    }

    public void registerItem(Item item, String resloc) {
        this.register(item, resloc, Registry.f_122904_);
        if (item instanceof IZetaItemColorProvider) {
            this.itemColors.put(item, (IZetaItemColorProvider)item);
        }
    }

    public void registerBlock(Block block, String resloc) {
        this.registerBlock(block, resloc, true);
    }

    public void registerBlock(Block block, String resloc, boolean hasBlockItem) {
        this.register(block, resloc, Registry.f_122901_);
        if (hasBlockItem) {
            this.defers.put((Object)Registry.f_122904_.m_135782_(), () -> this.createItemBlock(block));
        }
        if (block instanceof IZetaBlockColorProvider) {
            this.blockColors.put(block, (IZetaBlockColorProvider)block);
        }
    }

    public void setCreativeTab(Block block, CreativeModeTab group) {
        ResourceLocation res = this.getInternalName(block);
        if (res == null) {
            throw new IllegalArgumentException("Can't set the creative tab for a block without a registry name yet");
        }
        this.groups.put(res, group);
    }

    private Item createItemBlock(Block block) {
        Item.Properties props = new Item.Properties();
        ResourceLocation registryName = this.getInternalName(block);
        CreativeModeTab group = this.groups.get(registryName);
        if (group != null) {
            props = props.m_41491_(group);
        }
        if (block instanceof IZetaItemPropertiesFiller) {
            ((IZetaItemPropertiesFiller)block).fillItemProperties(props);
        }
        BlockItem blockitem = block instanceof IZetaBlockItemProvider ? ((IZetaBlockItemProvider)block).provideItemBlock(block, props) : new BlockItem(block, props);
        if (block instanceof IZetaItemColorProvider) {
            this.itemColors.put((Item)blockitem, (IZetaItemColorProvider)block);
        }
        this.setInternalName(blockitem, registryName);
        return blockitem;
    }

    public Collection<Supplier<Object>> getDefers(ResourceLocation registryId) {
        return this.defers.get((Object)registryId);
    }

    public void clearDeferCache(ResourceLocation resourceLocation) {
        this.defers.removeAll((Object)resourceLocation);
    }

    public void submitBlockColors(BiConsumer<BlockColor, Block> consumer) {
        this.blockColors.forEach((k, v) -> consumer.accept(v.getBlockColor(), (Block)k));
        this.blockColors.clear();
    }

    public void submitItemColors(BiConsumer<ItemColor, Item> consumer) {
        this.itemColors.forEach((k, v) -> consumer.accept(v.getItemColor(), (Item)k));
        this.itemColors.clear();
    }
}

