/*
 * Decompiled with CFR 0.152.
 */
package vazkii.zeta.recipe;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import it.unimi.dsi.fastutil.ints.IntList;
import it.unimi.dsi.fastutil.ints.IntLists;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import vazkii.quark.base.module.config.ConfigFlagManager;
import vazkii.zeta.Zeta;
import vazkii.zeta.recipe.IZetaIngredient;
import vazkii.zeta.recipe.IZetaIngredientSerializer;

public class FlagIngredient
extends Ingredient
implements IZetaIngredient<FlagIngredient> {
    private final Ingredient parent;
    private final ConfigFlagManager cfm;
    private final String flag;
    private final IZetaIngredientSerializer<FlagIngredient> serializer;

    public FlagIngredient(Ingredient parent, String flag, ConfigFlagManager cfm, IZetaIngredientSerializer<FlagIngredient> serializer) {
        super(Stream.of(new Ingredient.Value[0]));
        this.parent = parent;
        this.cfm = cfm;
        this.flag = flag;
        this.serializer = serializer;
    }

    @Nonnull
    public ItemStack[] m_43908_() {
        if (!this.cfm.getFlag(this.flag)) {
            return new ItemStack[0];
        }
        return this.parent.m_43908_();
    }

    @Nonnull
    public IntList m_43931_() {
        if (!this.cfm.getFlag(this.flag)) {
            return IntLists.EMPTY_LIST;
        }
        return this.parent.m_43931_();
    }

    public boolean test(@Nullable ItemStack target) {
        if (target == null || !this.cfm.getFlag(this.flag)) {
            return false;
        }
        return this.parent.test(target);
    }

    protected void invalidate() {
    }

    public boolean isSimple() {
        return this.parent.isSimple();
    }

    @Override
    public IZetaIngredientSerializer<FlagIngredient> zetaGetSerializer() {
        return this.serializer;
    }

    public record Serializer(ConfigFlagManager cfm) implements IZetaIngredientSerializer<FlagIngredient>
    {
        @Deprecated(forRemoval=true)
        public static Serializer INSTANCE;

        @Override
        @Nonnull
        public FlagIngredient parse(@Nonnull FriendlyByteBuf buffer) {
            return new FlagIngredient(Ingredient.m_43940_((FriendlyByteBuf)buffer), buffer.m_130277_(), this.cfm, this);
        }

        @Override
        @Nonnull
        public FlagIngredient parse(@Nonnull JsonObject json) {
            Ingredient value = Ingredient.m_43917_((JsonElement)json.get("value"));
            String flag = json.getAsJsonPrimitive("flag").getAsString();
            return new FlagIngredient(value, flag, this.cfm, this);
        }

        @Override
        public void write(@Nonnull FriendlyByteBuf buffer, @Nonnull FlagIngredient ingredient) {
            ingredient.parent.m_43923_(buffer);
            buffer.m_130070_(ingredient.flag);
        }

        @Override
        public Zeta getZeta() {
            return this.cfm.zeta;
        }
    }
}

