/*
 * Decompiled with CFR 0.152.
 */
package vazkii.zeta.module;

import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;
import net.minecraftforge.fml.loading.FMLEnvironment;
import org.jetbrains.annotations.Nullable;
import vazkii.quark.base.module.LoadModule;
import vazkii.zeta.Zeta;
import vazkii.zeta.event.ZModulesReady;
import vazkii.zeta.module.ModuleFinder;
import vazkii.zeta.module.TentativeModule;
import vazkii.zeta.module.ZetaCategory;
import vazkii.zeta.module.ZetaModule;
import vazkii.zeta.util.ZetaSide;

public class ZetaModuleManager {
    private final Zeta z;
    private final Map<Class<? extends ZetaModule>, ZetaModule> modulesByKey = new LinkedHashMap<Class<? extends ZetaModule>, ZetaModule>();
    private final Map<String, ZetaCategory> categoriesById = new LinkedHashMap<String, ZetaCategory>();
    private final Map<ZetaCategory, List<ZetaModule>> modulesInCategory = new HashMap<ZetaCategory, List<ZetaModule>>();

    public ZetaModuleManager(Zeta z) {
        this.z = z;
    }

    public Collection<ZetaModule> getModules() {
        return this.modulesByKey.values();
    }

    public <M extends ZetaModule> M get(Class<M> keyClass) {
        return (M)this.modulesByKey.get(keyClass);
    }

    public <M extends ZetaModule> Optional<M> getOptional(Class<M> keyClass) {
        return Optional.ofNullable(this.get(keyClass));
    }

    public ZetaCategory getCategory(String id) {
        if (id == null || id.isEmpty()) {
            id = "Unknown";
        }
        return this.categoriesById.computeIfAbsent(id, ZetaCategory::unknownCategory);
    }

    public Collection<ZetaCategory> getCategories() {
        return this.categoriesById.values();
    }

    public List<ZetaCategory> getInhabitedCategories() {
        return this.categoriesById.values().stream().filter(c -> !this.modulesInCategory((ZetaCategory)c).isEmpty()).toList();
    }

    public List<ZetaModule> modulesInCategory(ZetaCategory cat) {
        return this.modulesInCategory.computeIfAbsent(cat, __ -> new ArrayList());
    }

    public void initCategories(Iterable<ZetaCategory> cats) {
        for (ZetaCategory cat : cats) {
            this.categoriesById.put(cat.name, cat);
        }
    }

    public void load(ModuleFinder finder) {
        Collection<TentativeModule> tentative = ((Stream)finder.get()).map(data -> TentativeModule.from(data, this::getCategory)).filter(tm -> tm.appliesTo(this.z.side)).sorted(Comparator.comparing(TentativeModule::displayName)).toList();
        if (this.z.side == ZetaSide.CLIENT) {
            LinkedHashMap<Class<? extends ZetaModule>, TentativeModule> byClazz = new LinkedHashMap<Class<? extends ZetaModule>, TentativeModule>();
            for (TentativeModule tm2 : tentative) {
                if (tm2.clientReplacement()) continue;
                byClazz.put(tm2.clazz(), tm2);
            }
            for (TentativeModule tm2 : tentative) {
                if (!tm2.clientReplacement()) continue;
                Class<? extends ZetaModule> superclass = tm2.clazz().getSuperclass();
                TentativeModule existing = (TentativeModule)byClazz.get(superclass);
                if (existing == null) {
                    throw new RuntimeException("Module " + tm2.clazz().getName() + " wants to replace " + superclass.getName() + ", but that module isn't registered");
                }
                byClazz.put(superclass, existing.replaceWith(tm2));
            }
            tentative = byClazz.values();
        }
        this.z.log.info("Discovered " + tentative.size() + " modules to load");
        for (TentativeModule t : tentative) {
            this.modulesByKey.put(t.keyClass(), this.constructAndSetup(t));
        }
        this.z.loadBus.fire(new ZModulesReady());
    }

    private ZetaModule constructAndSetup(TentativeModule t) {
        boolean LEGACY_actuallySubscribe;
        boolean isLegacy = t.clazz().isAnnotationPresent(LoadModule.class);
        if (isLegacy) {
            this.z.log.info("Constructing module {}... (LEGACY MODULE)", (Object)t.displayName());
        } else {
            this.z.log.info("Constructing module {}...", (Object)t.displayName());
        }
        ZetaModule module = this.construct(t.clazz());
        if (isLegacy) {
            module.LEGACY_hasSubscriptions = t.LEGACY_hasSubscriptions();
            module.LEGACY_subscriptionTarget = t.LEGACY_subscribeOn();
            LEGACY_actuallySubscribe = module.LEGACY_subscriptionTarget.contains(FMLEnvironment.dist);
        } else {
            module.LEGACY_hasSubscriptions = false;
            module.LEGACY_subscriptionTarget = null;
            LEGACY_actuallySubscribe = true;
        }
        module.zeta = this.z;
        module.category = t.category();
        module.displayName = t.displayName();
        module.lowercaseName = t.lowercaseName();
        module.description = t.description();
        module.antiOverlap = t.antiOverlap();
        module.enabledByDefault = t.enabledByDefault();
        module.missingDep = !t.category().modsLoaded(this.z);
        module.setEnabled(this.z, t.enabledByDefault());
        if (LEGACY_actuallySubscribe) {
            this.z.loadBus.subscribe(module.getClass()).subscribe(module);
        }
        this.modulesInCategory.computeIfAbsent(module.category, __ -> new ArrayList()).add(module);
        module.postConstruct();
        return module;
    }

    private <Z extends ZetaModule> Z construct(Class<Z> clazz) {
        Z zeroArg = this.constructWithZeroArguments(clazz);
        if (zeroArg != null) {
            return zeroArg;
        }
        Z oneArg = this.constructWithOneArgument(clazz);
        if (oneArg != null) {
            return oneArg;
        }
        throw new RuntimeException("ZetaModule " + clazz.getName() + " should have a public zero or one-argument constructor");
    }

    @Nullable
    private <Z extends ZetaModule> Z constructWithZeroArguments(Class<Z> clazz) {
        try {
            Constructor<Z> cons = clazz.getConstructor(new Class[0]);
            return (Z)((ZetaModule)cons.newInstance(new Object[0]));
        }
        catch (NoSuchMethodException e) {
            return null;
        }
        catch (Exception e) {
            throw new RuntimeException("Could not construct ZetaModule " + clazz.getName(), e);
        }
    }

    @Nullable
    private <Z extends ZetaModule> Z constructWithOneArgument(Class<Z> clazz) {
        try {
            Optional<Constructor> oneOpt = Arrays.stream(clazz.getConstructors()).filter(c -> c.getParameterCount() == 1).findFirst();
            if (oneOpt.isEmpty()) {
                return null;
            }
            Constructor one = oneOpt.get();
            Class<?> paramType = one.getParameters()[0].getType();
            if (!ZetaModule.class.isAssignableFrom(paramType)) {
                throw new RuntimeException("ZetaModule " + clazz.getName() + " should take a ZetaModule as contructor parameter");
            }
            Class<?> checkedParamType = paramType;
            Object parent = this.construct(checkedParamType);
            return (Z)((ZetaModule)one.newInstance(parent));
        }
        catch (Exception e) {
            throw new RuntimeException("Could not construct ZetaModule " + clazz.getName(), e);
        }
    }
}

