/*
 * Decompiled with CFR 0.152.
 */
package vazkii.zeta.module;

import java.util.List;
import java.util.Set;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.loading.FMLEnvironment;
import vazkii.quark.base.module.hint.HintManager;
import vazkii.quark.base.module.hint.HintObject;
import vazkii.zeta.Zeta;
import vazkii.zeta.event.ZGatherHints;
import vazkii.zeta.event.bus.PlayEvent;
import vazkii.zeta.module.ZetaCategory;

public class ZetaModule {
    public Zeta zeta;
    public ZetaCategory category = null;
    public String displayName = "";
    public String lowercaseName = "";
    public String description = "";
    public Set<String> antiOverlap = Set.of();
    public boolean enabledByDefault = true;
    public boolean missingDep = false;
    private boolean firstLoad = true;
    public boolean enabled = false;
    public boolean disabledByOverlap = false;
    public boolean configEnabled = false;
    public boolean ignoreAntiOverlap = false;
    private List<HintObject> annotationHints = null;
    @Deprecated
    public boolean LEGACY_hasSubscriptions = false;
    @Deprecated
    public List<Dist> LEGACY_subscriptionTarget = null;

    public void postConstruct() {
    }

    public final void setEnabled(Zeta z, boolean willEnable) {
        this.configEnabled = willEnable;
        if (z.configManager != null && !z.configManager.isCategoryEnabled(this.category)) {
            willEnable = false;
        }
        this.disabledByOverlap = false;
        if (this.missingDep) {
            willEnable = false;
        } else if (!this.ignoreAntiOverlap && this.antiOverlap != null) {
            if (this.antiOverlap.stream().anyMatch(z::isModLoaded)) {
                this.disabledByOverlap = true;
                willEnable = false;
            }
        }
        this.setEnabledAndManageSubscriptions(z, willEnable);
        this.firstLoad = false;
    }

    private void setEnabledAndManageSubscriptions(Zeta z, boolean nowEnabled) {
        boolean actuallySubscribe;
        if ((this.firstLoad || this.enabled != nowEnabled) && (actuallySubscribe = this.LEGACY_doForgeEventBusSubscription(nowEnabled))) {
            if (nowEnabled) {
                z.playBus.subscribe(this.getClass()).subscribe(this);
            } else {
                z.playBus.unsubscribe(this.getClass()).unsubscribe(this);
            }
        }
        this.enabled = nowEnabled;
    }

    @PlayEvent
    public final void addAnnotationHints(ZGatherHints event) {
        if (this.annotationHints == null) {
            this.annotationHints = HintManager.gatherHintAnnotations(this.zeta.configManager.getConfigFlagManager(), this);
        }
        for (HintObject hint : this.annotationHints) {
            hint.apply(event);
        }
    }

    private boolean LEGACY_doForgeEventBusSubscription(boolean nowEnabled) {
        if (this.LEGACY_subscriptionTarget == null) {
            return true;
        }
        if (this.LEGACY_hasSubscriptions && this.LEGACY_subscriptionTarget.contains(FMLEnvironment.dist)) {
            if (nowEnabled) {
                MinecraftForge.EVENT_BUS.register((Object)this);
            } else {
                MinecraftForge.EVENT_BUS.unregister((Object)this);
            }
        }
        return this.LEGACY_subscriptionTarget.contains(FMLEnvironment.dist);
    }
}

