/*
 * Decompiled with CFR 0.152.
 */
package vazkii.zeta.module;

import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.function.Function;
import net.minecraftforge.api.distmarker.Dist;
import org.apache.commons.lang3.text.WordUtils;
import vazkii.zeta.module.ZetaCategory;
import vazkii.zeta.module.ZetaLoadModuleAnnotationData;
import vazkii.zeta.module.ZetaModule;
import vazkii.zeta.util.ZetaSide;

public record TentativeModule(Class<? extends ZetaModule> clazz, Class<? extends ZetaModule> keyClass, ZetaCategory category, String displayName, String lowercaseName, String description, Set<String> antiOverlap, boolean enabledByDefault, boolean clientReplacement, @Deprecated boolean LEGACY_hasSubscriptions, @Deprecated List<Dist> LEGACY_subscribeOn) {
    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static TentativeModule from(ZetaLoadModuleAnnotationData data, Function<String, ZetaCategory> categoryResolver) {
        Class<?> clazzUnchecked = data.clazz();
        if (!ZetaModule.class.isAssignableFrom(clazzUnchecked)) {
            throw new RuntimeException("Class " + clazzUnchecked.getName() + " does not extend ZetaModule");
        }
        Class<?> clazz = clazzUnchecked;
        String displayName = data.name().isEmpty() ? WordUtils.capitalizeFully((String)clazz.getSimpleName().replaceAll("Module$", "").replaceAll("(?<=.)([A-Z])", " $1")) : data.name();
        String lowercaseName = displayName.toLowerCase(Locale.ROOT).replace(" ", "_");
        boolean clientReplacement = data.clientReplacement();
        if (clientReplacement) {
            Class<?> sup = clazz.getSuperclass();
            if (!ZetaModule.class.isAssignableFrom(sup) || ZetaModule.class == sup) throw new RuntimeException("Client extension module " + clazz.getName() + " should `extend` the module it's an extension of");
            keyClass = clazz.getSuperclass();
            return new TentativeModule(clazz, keyClass, categoryResolver.apply(data.category()), displayName, lowercaseName, data.description(), Set.of(data.antiOverlap()), data.enabledByDefault(), clientReplacement, data.LEGACY_hasSubscriptions(), data.LEGACY_subscribeOn());
        } else {
            keyClass = clazz;
            if (data.category() != null && !data.category().isEmpty()) return new TentativeModule(clazz, keyClass, categoryResolver.apply(data.category()), displayName, lowercaseName, data.description(), Set.of(data.antiOverlap()), data.enabledByDefault(), clientReplacement, data.LEGACY_hasSubscriptions(), data.LEGACY_subscribeOn());
            throw new RuntimeException("Module " + clazz.getName() + " should specify a category");
        }
    }

    public TentativeModule replaceWith(TentativeModule replacement) {
        return new TentativeModule(replacement.clazz, this.keyClass, this.category, this.displayName, this.lowercaseName, this.description, this.antiOverlap, this.enabledByDefault, false, this.LEGACY_hasSubscriptions, this.LEGACY_subscribeOn);
    }

    public boolean appliesTo(ZetaSide side) {
        return switch (side) {
            default -> throw new IncompatibleClassChangeError();
            case ZetaSide.CLIENT -> true;
            case ZetaSide.SERVER -> !this.clientReplacement;
        };
    }
}

