/*
 * Decompiled with CFR 0.152.
 */
package vazkii.zeta.module;

import java.util.Objects;
import java.util.ServiceLoader;
import java.util.stream.Stream;
import vazkii.zeta.Zeta;
import vazkii.zeta.module.ModuleFinder;
import vazkii.zeta.module.ZetaLoadModule;
import vazkii.zeta.module.ZetaLoadModuleAnnotationData;
import vazkii.zeta.module.ZetaModule;

public class ServiceLoaderModuleFinder
implements ModuleFinder {
    private final Zeta z;

    public ServiceLoaderModuleFinder(Zeta z) {
        this.z = z;
    }

    @Override
    public Stream<ZetaLoadModuleAnnotationData> get() {
        return ServiceLoader.load(ZetaModule.class).stream().map(provider -> {
            ZetaLoadModule annotation = provider.type().getAnnotation(ZetaLoadModule.class);
            if (annotation == null) {
                this.z.log.warn("Module class " + provider.type().getName() + " was found through ServiceLoader, but does not have a @ZetaLoadModule annotation. Skipping");
                return null;
            }
            return ZetaLoadModuleAnnotationData.fromAnnotation(provider.type(), annotation);
        }).filter(Objects::nonNull);
    }
}

