/*
 * Decompiled with CFR 0.152.
 */
package vazkii.zeta.event.bus;

import com.google.common.base.Preconditions;
import java.lang.annotation.Annotation;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Stream;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import vazkii.zeta.event.bus.Cancellable;

public class ZetaEventBus<E> {
    private final Class<? extends Annotation> subscriberAnnotation;
    private final Class<? extends E> eventRoot;
    @Nullable
    private final Logger logSpam;
    private final Map<Class<? extends E>, Listeners> listenerMap = new HashMap<Class<? extends E>, Listeners>();

    public ZetaEventBus(Class<? extends Annotation> subscriberAnnotation, Class<? extends E> eventRoot, @Nullable Logger logSpam) {
        Preconditions.checkArgument((boolean)eventRoot.isInterface(), (Object)"Event roots should be an interface");
        this.subscriberAnnotation = subscriberAnnotation;
        this.eventRoot = eventRoot;
        this.logSpam = logSpam;
    }

    public ZetaEventBus<E> subscribe(@NotNull Object target) {
        Class owningClazz;
        Object receiver;
        Preconditions.checkNotNull((Object)target, (Object)"null passed to subscribe");
        if (target instanceof Class) {
            Class clazz = (Class)target;
            receiver = null;
            owningClazz = clazz;
        } else {
            receiver = target;
            owningClazz = target.getClass();
        }
        this.streamAnnotatedMethods(owningClazz, receiver == null).forEach(m -> this.getListenersFor((Method)m).subscribe(receiver, owningClazz, (Method)m));
        return this;
    }

    public ZetaEventBus<E> unsubscribe(@NotNull Object target) {
        Class owningClazz;
        Object receiver;
        Preconditions.checkNotNull((Object)target, (Object)"null passed to unsubscribe");
        if (target instanceof Class) {
            Class clazz = (Class)target;
            receiver = null;
            owningClazz = clazz;
        } else {
            receiver = target;
            owningClazz = target.getClass();
        }
        this.streamAnnotatedMethods(owningClazz, receiver == null).forEach(m -> this.getListenersFor((Method)m).unsubscribe(receiver, owningClazz, (Method)m));
        return this;
    }

    public <T extends E> T fire(@NotNull T event) {
        Listeners subs = this.listenerMap.get(event.getClass());
        if (subs != null) {
            if (this.logSpam != null) {
                this.logSpam.info("Dispatching {} to {} listener{}", (Object)this.logspamSimpleName(event.getClass()), (Object)subs.size(), (Object)(subs.size() > 1 ? "s" : ""));
            }
            subs.doFire(event);
        }
        return event;
    }

    public <T extends E> T fire(@NotNull T event, Class<? super T> firedAs) {
        Listeners subs = this.listenerMap.get(firedAs);
        if (subs != null) {
            if (this.logSpam != null) {
                this.logSpam.info("Dispatching {} (as {}) to {} listeners", (Object)this.logspamSimpleName(event.getClass()), (Object)this.logspamSimpleName(firedAs), (Object)subs.size(), (Object)(subs.size() > 1 ? "s" : ""));
            }
            subs.doFire(event);
        }
        return event;
    }

    private String logspamSimpleName(Class<?> clazz) {
        String[] split = clazz.getName().split("\\.");
        return split[split.length - 1];
    }

    private Stream<Method> streamAnnotatedMethods(Class<?> owningClazz, boolean wantStatic) {
        return Arrays.stream(owningClazz.getMethods()).filter(m -> m.isAnnotationPresent(this.subscriberAnnotation) && (m.getModifiers() & 8) != 0 == wantStatic);
    }

    private Listeners getListenersFor(Method method) {
        if (method.getParameterCount() != 1) {
            throw this.arityERR(method);
        }
        Class<?> eventType = method.getParameterTypes()[0];
        if (!this.eventRoot.isAssignableFrom(eventType)) {
            throw this.typeERR(method);
        }
        return this.listenerMap.computeIfAbsent(eventType, __ -> new Listeners());
    }

    private RuntimeException arityERR(Method method) {
        return ZetaEventBus.methodProblem("Method annotated with @" + this.subscriberAnnotation.getSimpleName() + " should take 1 parameter.", method, null);
    }

    private RuntimeException typeERR(Method method) {
        return ZetaEventBus.methodProblem("Method annotated with @" + this.subscriberAnnotation.getSimpleName() + " should take an implementor of " + this.eventRoot.getSimpleName() + ".", method, null);
    }

    private RuntimeException unreflectERR(Method method, Throwable cause) {
        return ZetaEventBus.methodProblem("Exception unreflecting a @" + this.subscriberAnnotation.getSimpleName() + " method, is it public?", method, cause);
    }

    private static RuntimeException methodProblem(String problem, Method method, @Nullable Throwable cause) {
        return new RuntimeException("%s%nMethod class: %s%nMethod name: %s".formatted(problem, method.getDeclaringClass().getName(), method.getName()), cause);
    }

    private class Listeners {
        private final Map<Subscriber, MethodHandle> handles = new LinkedHashMap<Subscriber, MethodHandle>();

        private Listeners() {
        }

        void subscribe(@Nullable Object receiver, Class<?> owningClazz, Method method) {
            try {
                this.handles.computeIfAbsent(new Subscriber(receiver, owningClazz, method), Subscriber::unreflect);
            }
            catch (Exception e) {
                throw ZetaEventBus.this.unreflectERR(method, e);
            }
        }

        void unsubscribe(@Nullable Object receiver, Class<?> owningClazz, Method method) {
            this.handles.remove(new Subscriber(receiver, owningClazz, method));
        }

        int size() {
            return this.handles.size();
        }

        void doFire(E event) {
            try {
                if (event instanceof Cancellable) {
                    Cancellable cancellable = (Cancellable)event;
                    this.doFireCancellable(cancellable);
                } else {
                    this.doFireNonCancellable(event);
                }
            }
            catch (Throwable e) {
                throw new RuntimeException("Exception while firing event " + event + ": ", e);
            }
        }

        void doFireCancellable(Cancellable event) throws Throwable {
            for (MethodHandle handle : this.handles.values()) {
                handle.invoke(event);
                if (!event.isCanceled()) continue;
                break;
            }
        }

        void doFireNonCancellable(E event) throws Throwable {
            for (MethodHandle handle : this.handles.values()) {
                handle.invoke(event);
            }
        }

        private record Subscriber(@Nullable Object receiver, Class<?> owningClazz, Method method) {
            @Override
            public boolean equals(Object object) {
                if (this == object) {
                    return true;
                }
                if (object == null || this.getClass() != object.getClass()) {
                    return false;
                }
                Subscriber that = (Subscriber)object;
                return this.receiver == that.receiver && Objects.equals(this.owningClazz, that.owningClazz) && Objects.equals(this.method, that.method);
            }

            @Override
            public int hashCode() {
                return System.identityHashCode(this.receiver) + this.owningClazz.hashCode() + this.method.hashCode();
            }

            MethodHandle unreflect() {
                MethodHandle handle;
                try {
                    handle = MethodHandles.publicLookup().unreflect(this.method);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
                if (this.receiver != null) {
                    handle = handle.bindTo(this.receiver);
                }
                return handle;
            }
        }
    }
}

