/*
 * Decompiled with CFR 0.152.
 */
package vazkii.zeta.config;

import java.util.List;
import java.util.function.Predicate;
import org.jetbrains.annotations.Nullable;
import vazkii.zeta.config.Definition;
import vazkii.zeta.config.SectionDefinition;

public class ValueDefinition<T>
extends Definition {
    public final T defaultValue;
    @Nullable
    public final Predicate<Object> validator;

    public ValueDefinition(String name, List<String> comment, T defaultValue, @Nullable Predicate<Object> validator, @Nullable SectionDefinition parent) {
        super(name, comment, parent);
        this.defaultValue = defaultValue;
        this.validator = validator;
    }

    public ValueDefinition(String name, List<String> comment, T defaultValue, Predicate<Object> validator) {
        this(name, comment, defaultValue, validator, null);
    }

    public ValueDefinition(String name, List<String> comment, T defaultValue, SectionDefinition parent) {
        this(name, comment, defaultValue, null, parent);
    }

    public ValueDefinition(String name, List<String> comment, T defaultValue) {
        this(name, comment, defaultValue, null, null);
    }

    public boolean isOfType(Class<?> clazz) {
        return clazz.isAssignableFrom(this.defaultValue.getClass());
    }

    @Nullable
    public <X> ValueDefinition<X> downcast(Class<X> newType) {
        if (this.isOfType(newType)) {
            return this;
        }
        return null;
    }

    public boolean validate(Object underTest) {
        if (underTest == null) {
            return false;
        }
        boolean isList = List.class.isAssignableFrom(this.defaultValue.getClass());
        boolean isSubtype = this.defaultValue.getClass().isAssignableFrom(underTest.getClass());
        if (!isList && !isSubtype) {
            return false;
        }
        if (this.validator == null) {
            return true;
        }
        return this.validator.test(underTest);
    }

    public String toString() {
        return "ValueDefinition{" + this.name + "}";
    }
}

