/*
 * Decompiled with CFR 0.152.
 */
package vazkii.zeta.config;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import org.jetbrains.annotations.Nullable;
import vazkii.zeta.config.Definition;
import vazkii.zeta.config.ValueDefinition;

public class SectionDefinition
extends Definition {
    public final Map<String, SectionDefinition> subsections = new LinkedHashMap<String, SectionDefinition>();
    public final Map<String, ValueDefinition<?>> values = new LinkedHashMap();

    public SectionDefinition(String name, List<String> comment, @Nullable SectionDefinition parent) {
        super(name, comment, parent);
    }

    public SectionDefinition(String name, List<String> comment) {
        this(name, comment, null);
    }

    public SectionDefinition getOrCreateSubsection(String name, List<String> comment) {
        return this.subsections.computeIfAbsent(name, __ -> new SectionDefinition(name, comment, this));
    }

    public <T> ValueDefinition<T> addValue(String name, List<String> comment, T defaultValue) {
        ValueDefinition<T> val = new ValueDefinition<T>(name, comment, defaultValue, this);
        this.values.put(val.name, val);
        return val;
    }

    public <T> ValueDefinition<T> addValue(String name, List<String> comment, T defaultValue, Predicate<Object> validator) {
        ValueDefinition<T> val = new ValueDefinition<T>(name, comment, defaultValue, validator, this);
        this.values.put(val.name, val);
        return val;
    }

    @Nullable
    public ValueDefinition<?> getValue(String name) {
        return this.values.get(name);
    }

    @Nullable
    public <T> ValueDefinition<T> getValue(String name, Class<T> type) {
        ValueDefinition<?> value = this.getValue(name);
        return value == null ? null : value.downcast(type);
    }

    @Nullable
    public <T> ValueDefinition<T> getValueErased(String name, Class<?> type) {
        return this.getValue(name, type);
    }

    public Collection<SectionDefinition> getSubsections() {
        return this.subsections.values();
    }

    public Collection<ValueDefinition<?>> getValues() {
        return this.values.values();
    }

    public void trimEmptySubsections() {
        this.getSubsections().removeIf(sub -> sub.getSubsections().isEmpty() && sub.getValues().isEmpty());
        this.getSubsections().forEach(SectionDefinition::trimEmptySubsections);
    }

    public String toString() {
        return "SectionDefinition{" + this.name + " (" + this.subsections.size() + " subsections, " + this.values.size() + " values)}";
    }
}

