/*
 * Decompiled with CFR 0.152.
 */
package vazkii.zeta.config;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.jetbrains.annotations.Nullable;
import vazkii.zeta.config.SectionDefinition;

public abstract class Definition {
    public final String name;
    public final List<String> comment;
    @Nullable
    public final SectionDefinition parent;
    public final Collection<String> path;
    @Nullable
    public Object hint;

    public Definition(String name, List<String> comment, @Nullable SectionDefinition parent) {
        this.name = name;
        this.parent = parent;
        this.comment = comment.stream().flatMap(s -> Arrays.stream(s.split("\n"))).filter(line -> !line.trim().isEmpty()).collect(Collectors.toList());
        if (parent == null) {
            this.path = Collections.emptyList();
        } else {
            this.path = new ArrayList<String>(parent.path);
            this.path.add(name);
            ((ArrayList)this.path).trimToSize();
        }
    }

    public String[] commentToArray() {
        return this.comment == null ? new String[]{} : this.comment.toArray(new String[0]);
    }

    public String commentToString() {
        return this.comment == null ? "" : String.join((CharSequence)"\n", this.comment);
    }

    public final String getGuiDisplayName(Function<String, String> i18nDotGet) {
        String defName = this instanceof SectionDefinition ? this.name.replace("_", "") : this.name;
        String transKey = "quark.config." + String.join((CharSequence)".", this.path) + "." + this.name.toLowerCase().replaceAll(" ", "_").replaceAll("[^A-Za-z0-9_]", "") + ".name";
        String localized = i18nDotGet.apply(transKey);
        if (localized.isEmpty() || localized.equals(transKey)) {
            return defName;
        }
        return localized;
    }
}

