/*
 * Decompiled with CFR 0.152.
 */
package vazkii.zeta.config;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.function.Consumer;
import java.util.function.Predicate;
import org.apache.commons.lang3.text.WordUtils;
import org.jetbrains.annotations.Nullable;
import vazkii.quark.base.module.config.Config;
import vazkii.quark.base.module.config.ConfigFlagManager;
import vazkii.quark.base.module.config.type.IConfigType;
import vazkii.zeta.config.IZetaConfigInternals;
import vazkii.zeta.config.SectionDefinition;
import vazkii.zeta.config.ValueDefinition;
import vazkii.zeta.module.ZetaModule;

public class ConfigObjectMapper {
    public static List<Field> walkModuleFields(Class<?> clazz) {
        ArrayList<Field> list = new ArrayList<Field>();
        while (clazz != ZetaModule.class && clazz != Object.class) {
            Field[] fields = clazz.getDeclaredFields();
            list.addAll(Arrays.asList(fields));
            clazz = clazz.getSuperclass();
        }
        return list;
    }

    public static void readInto(SectionDefinition sect, Object obj, List<Consumer<IZetaConfigInternals>> databindings, ConfigFlagManager cfm) {
        if (obj instanceof ZetaModule) {
            ZetaModule zm = (ZetaModule)obj;
            ConfigObjectMapper.readInto(sect, obj, zm, databindings, cfm);
        } else {
            ConfigObjectMapper.readInto(sect, obj, null, databindings, cfm);
        }
    }

    public static void readInto(SectionDefinition sect, Object obj, @Nullable ZetaModule enclosingModule, List<Consumer<IZetaConfigInternals>> databindings, ConfigFlagManager cfm) {
        for (Field field : ConfigObjectMapper.walkModuleFields(obj.getClass())) {
            Config config = field.getAnnotation(Config.class);
            if (config == null) continue;
            field.setAccessible(true);
            String name = config.name();
            if (name.isEmpty()) {
                name = WordUtils.capitalizeFully((String)field.getName().replaceAll("(?<=.)([A-Z])", " $1"));
            }
            Config.Min min = field.getDeclaredAnnotation(Config.Min.class);
            Config.Max max = field.getDeclaredAnnotation(Config.Max.class);
            ArrayList<String> comment = new ArrayList<String>(4);
            if (!config.description().isEmpty()) {
                comment.addAll(List.of(config.description().split("\n")));
            }
            if (min != null || max != null) {
                String minPart;
                NumberFormat format = DecimalFormat.getNumberInstance(Locale.ROOT);
                String string = min == null ? "(" : (minPart = (min.exclusive() ? "(" : "[") + format.format(min.value()));
                String maxPart = max == null ? ")" : format.format(max.value()) + (max.exclusive() ? ")" : "]");
                comment.add("Allowed values: " + minPart + "," + maxPart);
            }
            Object defaultValue = ConfigObjectMapper.getField(obj, field);
            Config.Condition condition = field.getDeclaredAnnotation(Config.Condition.class);
            Predicate<Object> restriction = ConfigObjectMapper.restrict(min, max, condition);
            if (defaultValue instanceof IConfigType) {
                IConfigType configType = (IConfigType)defaultValue;
                String asSectionName = name.toLowerCase(Locale.ROOT).replace(" ", "_");
                SectionDefinition subsection = sect.getOrCreateSubsection(asSectionName, comment);
                subsection.hint = configType;
                ConfigObjectMapper.readInto(subsection, configType, enclosingModule, databindings, cfm);
                databindings.add(z -> configType.onReload(enclosingModule, cfm));
                continue;
            }
            ValueDefinition<Object> def = sect.addValue(name, comment, defaultValue, restriction);
            databindings.add(z -> ConfigObjectMapper.setField(obj, field, z.get(def)));
            String flag = config.flag();
            if (flag.isEmpty()) continue;
            if (enclosingModule == null) {
                throw new IllegalArgumentException("Only ZetaModules can have `@Config(flag = ...)` annotations.\nClass: " + obj.getClass() + "\nField: " + field);
            }
            ValueDefinition<Boolean> defBool = def.downcast(Boolean.class);
            if (defBool == null) {
                throw new IllegalArgumentException("Only boolean fields can be annotated with `@Config(flag = ...)`.\nClass: " + obj.getClass() + "\nField: " + field);
            }
            cfm.putFlag(enclosingModule, flag, true);
            databindings.add(z -> cfm.putFlag(enclosingModule, flag, (Boolean)z.get(defBool)));
        }
    }

    private static Object getField(Object owner, Field field) {
        Object receiver = Modifier.isStatic(field.getModifiers()) ? null : owner;
        try {
            return field.get(receiver);
        }
        catch (ReflectiveOperationException e) {
            throw new RuntimeException(e);
        }
    }

    private static void setField(Object owner, Field field, Object value) {
        Object receiver = Modifier.isStatic(field.getModifiers()) ? null : owner;
        try {
            field.set(receiver, value);
        }
        catch (ReflectiveOperationException e) {
            throw new RuntimeException(e);
        }
    }

    private static Predicate<Object> restrict(@Nullable Config.Min min, @Nullable Config.Max max, @Nullable Config.Condition condition) {
        double minVal = min == null ? -1.7976931348623157E308 : min.value();
        double maxVal = max == null ? Double.MAX_VALUE : max.value();
        boolean minExclusive = min != null && min.exclusive();
        boolean maxExclusive = max != null && max.exclusive();
        Predicate<Object> pred = o -> ConfigObjectMapper.restrict(o, minVal, minExclusive, maxVal, maxExclusive);
        if (condition != null) {
            try {
                Constructor<? extends Predicate<Object>> constr = condition.value().getDeclaredConstructor(new Class[0]);
                constr.setAccessible(true);
                Predicate<Object> additionalPredicate = constr.newInstance(new Object[0]);
                pred = pred.and(additionalPredicate);
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Failed to parse config Predicate annotation: ", e);
            }
        }
        return pred;
    }

    private static boolean restrict(Object o, double minVal, boolean minExclusive, double maxVal, boolean maxExclusive) {
        if (o == null) {
            return false;
        }
        if (o instanceof Number) {
            Number num = (Number)o;
            double val = num.doubleValue();
            if (minExclusive ? minVal >= val : minVal > val) {
                return false;
            }
            if (maxExclusive ? maxVal <= val : maxVal < val) {
                return false;
            }
        }
        return true;
    }
}

