/*
 * Decompiled with CFR 0.152.
 */
package vazkii.zeta.config;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import org.jetbrains.annotations.Nullable;
import vazkii.quark.base.handler.GeneralConfig;
import vazkii.quark.base.module.config.ConfigFlagManager;
import vazkii.zeta.Zeta;
import vazkii.zeta.config.ConfigObjectMapper;
import vazkii.zeta.config.IZetaConfigInternals;
import vazkii.zeta.config.SectionDefinition;
import vazkii.zeta.config.ValueDefinition;
import vazkii.zeta.event.ZGatherAdditionalFlags;
import vazkii.zeta.module.ZetaCategory;
import vazkii.zeta.module.ZetaModule;
import vazkii.zeta.module.ZetaModuleManager;

public class ConfigManager {
    private final Zeta z;
    private final ConfigFlagManager cfm;
    private final SectionDefinition rootConfig;
    private final List<Consumer<IZetaConfigInternals>> databindings = new ArrayList<Consumer<IZetaConfigInternals>>();
    private Consumer<IZetaConfigInternals> onConfigReloadJEI;
    @Nullable
    private final SectionDefinition generalSection;
    private final Map<ZetaCategory, SectionDefinition> categoriesToSections = new HashMap<ZetaCategory, SectionDefinition>();
    private final Map<ZetaCategory, ValueDefinition<Boolean>> categoryEnabledOptions = new HashMap<ZetaCategory, ValueDefinition<Boolean>>();
    private final Map<ZetaModule, ValueDefinition<Boolean>> ignoreAntiOverlapOptions = new HashMap<ZetaModule, ValueDefinition<Boolean>>();
    private final Map<ZetaModule, ValueDefinition<Boolean>> moduleEnabledOptions = new HashMap<ZetaModule, ValueDefinition<Boolean>>();
    private final Set<ZetaCategory> enabledCategories = new HashSet<ZetaCategory>();

    public ConfigManager(Zeta z, Object rootPojo) {
        this.z = z;
        this.cfm = new ConfigFlagManager(z);
        ZetaModuleManager modules = z.modules;
        this.enabledCategories.addAll(modules.getCategories());
        this.rootConfig = new SectionDefinition("root", List.of());
        if (rootPojo == null) {
            this.generalSection = null;
        } else {
            this.generalSection = this.rootConfig.getOrCreateSubsection("general", List.of());
            ConfigObjectMapper.readInto(this.generalSection, rootPojo, this.databindings, this.cfm);
        }
        for (ZetaCategory category : modules.getInhabitedCategories()) {
            this.categoryEnabledOptions.put(category, this.rootConfig.getOrCreateSubsection("categories", List.of()).addValue(category.name, List.of(), true));
            SectionDefinition categorySection = this.rootConfig.getOrCreateSubsection(category.name, List.of());
            this.categoriesToSections.put(category, categorySection);
            for (ZetaModule module : modules.modulesInCategory(category)) {
                this.cfm.putModuleFlag(module);
                this.moduleEnabledOptions.put(module, categorySection.addValue(module.displayName, List.of(module.description), module.enabledByDefault));
                SectionDefinition moduleSection = categorySection.getOrCreateSubsection(module.lowercaseName, List.of(module.description));
                ConfigObjectMapper.readInto(moduleSection, module, this.databindings, this.cfm);
                if (module.antiOverlap.isEmpty()) continue;
                ArrayList<String> antiOverlapComment = new ArrayList<String>(module.antiOverlap.size() + 3);
                antiOverlapComment.add("This feature disables itself if any of the following mods are loaded:");
                for (String s : module.antiOverlap) {
                    antiOverlapComment.add(" - " + s);
                }
                antiOverlapComment.add("This is done to prevent content overlap.");
                antiOverlapComment.add("You can turn this on to force the feature to be loaded even if the above mods are also loaded.");
                this.ignoreAntiOverlapOptions.put(module, moduleSection.addValue("Ignore Anti Overlap", antiOverlapComment, false));
            }
        }
        z.playBus.fire(new ZGatherAdditionalFlags(this.cfm));
        this.databindings.add(0, i -> {
            this.categoryEnabledOptions.forEach((category, option) -> this.setCategoryEnabled((ZetaCategory)category, (Boolean)i.get(option)));
            this.ignoreAntiOverlapOptions.forEach((module, option) -> {
                module.ignoreAntiOverlap = !GeneralConfig.useAntiOverlap || (Boolean)i.get(option) != false;
            });
            this.moduleEnabledOptions.forEach((module, option) -> {
                this.setModuleEnabled((ZetaModule)module, (Boolean)i.get(option));
                this.cfm.putModuleFlag((ZetaModule)module);
            });
            z.playBus.fire(new ZGatherAdditionalFlags(this.cfm));
        });
        this.rootConfig.trimEmptySubsections();
    }

    public SectionDefinition getRootConfig() {
        return this.rootConfig;
    }

    @Nullable
    public SectionDefinition getGeneralSection() {
        return this.generalSection;
    }

    public SectionDefinition getCategorySection(ZetaCategory cat) {
        return this.categoriesToSections.get(cat);
    }

    public ValueDefinition<Boolean> getCategoryEnabledOption(ZetaCategory cat) {
        return this.categoryEnabledOptions.get(cat);
    }

    public ValueDefinition<Boolean> getModuleEnabledOption(ZetaModule module) {
        return this.moduleEnabledOptions.get(module);
    }

    private void setCategoryEnabled(ZetaCategory cat, boolean enabled) {
        if (enabled) {
            this.enabledCategories.add(cat);
        } else {
            this.enabledCategories.remove(cat);
        }
        for (ZetaModule mod : this.z.modules.modulesInCategory(cat)) {
            mod.setEnabled(this.z, mod.enabled);
        }
    }

    private void setModuleEnabled(ZetaModule module, boolean enabled) {
        module.setEnabled(this.z, enabled);
    }

    public boolean isCategoryEnabled(ZetaCategory cat) {
        return this.enabledCategories.contains(cat);
    }

    public ConfigFlagManager getConfigFlagManager() {
        return this.cfm;
    }

    public void onReload() {
        IZetaConfigInternals internals = this.z.configInternals;
        this.databindings.forEach(c -> c.accept(internals));
        if (this.onConfigReloadJEI != null) {
            this.onConfigReloadJEI.accept(internals);
        }
    }

    public void setJeiReloadListener(Consumer<IZetaConfigInternals> consumer) {
        this.onConfigReloadJEI = consumer;
    }
}

