/*
 * Decompiled with CFR 0.152.
 */
package vazkii.zeta.client.config.screen;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import org.apache.commons.lang3.text.WordUtils;
import vazkii.zeta.client.ZetaClient;
import vazkii.zeta.client.config.screen.SectionScreen;
import vazkii.zeta.client.config.screen.ZetaScreen;
import vazkii.zeta.client.config.widget.CategoryButton;
import vazkii.zeta.client.config.widget.CheckboxButton;
import vazkii.zeta.config.ChangeSet;
import vazkii.zeta.config.SectionDefinition;
import vazkii.zeta.config.ValueDefinition;
import vazkii.zeta.module.ZetaCategory;

public class ZetaConfigHomeScreen
extends ZetaScreen {
    protected final ChangeSet changeSet;

    public ZetaConfigHomeScreen(ZetaClient zc, Screen parent) {
        super(zc, parent);
        this.changeSet = new ChangeSet(this.z.configInternals);
    }

    protected void m_7856_() {
        int i;
        super.m_7856_();
        List<ZetaCategory> categories = this.z.modules.getInhabitedCategories();
        SectionDefinition generalSection = this.z.configManager.getGeneralSection();
        int buttonCount = categories.size();
        if (generalSection != null) {
            ++buttonCount;
        }
        int perLine = 3;
        ArrayList<Integer> categoryButtonXPositions = new ArrayList<Integer>(buttonCount);
        for (i = 0; i < buttonCount; i += 3) {
            categoryButtonXPositions.addAll(this.centeredRow(this.f_96543_ / 2, 120, 10, Math.min(buttonCount - i, 3)));
        }
        for (i = 0; i < buttonCount; ++i) {
            int row = i / 3;
            int x = (Integer)categoryButtonXPositions.get(i);
            int y = 70 + row * 23;
            int bWidth = 120;
            if (i < categories.size()) {
                boolean active;
                ZetaCategory category = categories.get(i);
                ValueDefinition<Boolean> categoryEnabled = this.z.configManager.getCategoryEnabledOption(category);
                SectionDefinition categorySection = this.z.configManager.getCategorySection(category);
                Button mainButton = (Button)this.m_142416_((GuiEventListener)new CategoryButton(this.zc, x, y, bWidth -= 20, 20, this.componentFor(categorySection), category.icon.get(), b -> Minecraft.m_91087_().m_91152_((Screen)new SectionScreen(this.zc, this, this.changeSet, categorySection))));
                Button checkButton = (Button)this.m_142416_((GuiEventListener)new CheckboxButton(this.zc, x + bWidth, y, this.changeSet, categoryEnabled));
                mainButton.f_93623_ = active = category.modsLoaded(this.z);
                checkButton.f_93623_ = active;
                continue;
            }
            assert (generalSection != null);
            this.m_142416_((GuiEventListener)new Button(x, y, bWidth, 20, this.componentFor(generalSection), b -> Minecraft.m_91087_().m_91152_((Screen)new SectionScreen(this.zc, this, this.changeSet, generalSection))));
        }
        this.m_142416_((GuiEventListener)new Button(this.f_96543_ / 2 - 100, this.f_96544_ - 30, 200, 20, (Component)Component.m_237115_((String)"quark.gui.config.save"), this::commit));
    }

    public List<Integer> centeredRow(int centerX, int buttonWidth, int hpad, int count) {
        int slop = (count % 2 == 0 ? hpad : buttonWidth) / 2;
        int fullButtonsLeftOfCenter = count / 2;
        int fullPaddingsLeftOfCenter = Math.max(0, (count - 1) / 2);
        int startX = centerX - slop - fullButtonsLeftOfCenter * buttonWidth - fullPaddingsLeftOfCenter * hpad;
        ArrayList<Integer> result = new ArrayList<Integer>(count);
        int x = startX;
        for (int i = 0; i < count; ++i) {
            result.add(x);
            x += buttonWidth + hpad;
        }
        return result;
    }

    private Component componentFor(SectionDefinition section) {
        MutableComponent comp = Component.m_237115_((String)(this.z.modid + ".category." + section.name));
        if (this.changeSet.isDirty(section)) {
            comp.m_7220_((Component)Component.m_237113_((String)"*").m_130940_(ChatFormatting.GOLD));
        }
        return comp;
    }

    public void commit(Button button) {
        this.changeSet.applyAllChanges();
        this.returnToParent();
    }

    public void m_6305_(@Nonnull PoseStack mstack, int mouseX, int mouseY, float partialTicks) {
        this.m_7333_(mstack);
        super.m_6305_(mstack, mouseX, mouseY, partialTicks);
        ZetaConfigHomeScreen.m_93208_((PoseStack)mstack, (Font)this.f_96547_, (String)(ChatFormatting.BOLD + I18n.m_118938_((String)"quark.gui.config.header", (Object[])new Object[]{WordUtils.capitalizeFully((String)this.z.modid)})), (int)(this.f_96543_ / 2), (int)15, (int)4775356);
    }
}

