/*
 * Decompiled with CFR 0.152.
 */
package vazkii.zeta.client.config.screen;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.IntStream;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import org.jetbrains.annotations.NotNull;
import vazkii.zeta.client.ZetaClient;
import vazkii.zeta.client.config.screen.AbstractInputScreen;
import vazkii.zeta.client.config.widget.ScrollableWidgetList;
import vazkii.zeta.config.ChangeSet;
import vazkii.zeta.config.ValueDefinition;

public class StringListInputScreen
extends AbstractInputScreen<List<String>> {
    protected ScrollableWidgetList<StringListInputScreen, Entry> list;

    public StringListInputScreen(ZetaClient zc, Screen parent, ChangeSet changes, ValueDefinition<List<String>> def) {
        super(zc, parent, changes, def);
    }

    @Override
    protected void m_7856_() {
        super.m_7856_();
        this.list = new ScrollableWidgetList(this);
        this.m_7787_((GuiEventListener)this.list);
        this.forceUpdateWidgetsTo((List)this.get());
    }

    @Override
    protected void forceUpdateWidgetsTo(List<String> value) {
        this.list.removeChildWidgets(x$0 -> this.m_169411_((GuiEventListener)x$0));
        this.list.m_5988_(IntStream.range(0, value.size() + 1).mapToObj(x$0 -> new Entry(x$0)).toList());
        this.list.addChildWidgets(x$0 -> {
            AbstractWidget cfr_ignored_0 = (AbstractWidget)this.m_142416_((GuiEventListener)x$0);
        }, x$0 -> {
            AbstractWidget cfr_ignored_0 = (AbstractWidget)this.m_7787_((GuiEventListener)x$0);
        });
        this.list.m_93410_(this.list.m_93517_());
        this.updateButtonStatus(this.def.validate(value));
    }

    public void m_6305_(@NotNull PoseStack mstack, int mouseX, int mouseY, float partialTicks) {
        this.m_7333_(mstack);
        this.list.m_6305_(mstack, mouseX, mouseY, partialTicks);
        super.m_6305_(mstack, mouseX, mouseY, partialTicks);
        this.list.reenableVisibleWidgets();
        StringListInputScreen.m_93215_((PoseStack)mstack, (Font)this.f_96547_, (Component)Component.m_237113_((String)this.ext.getGuiDisplayName(this.changes, this.def)).m_130940_(ChatFormatting.BOLD), (int)(this.f_96543_ / 2), (int)20, (int)0xFFFFFF);
    }

    protected String getString(int index) {
        List list = (List)this.get();
        if (index < list.size()) {
            return (String)list.get(index);
        }
        return null;
    }

    protected void setString(int index, String s) {
        ArrayList<String> copy = new ArrayList<String>((Collection)this.get());
        copy.set(index, s);
        this.set(copy);
        this.updateButtonStatus(this.def.validate(copy));
    }

    protected void add() {
        ArrayList<String> copy = new ArrayList<String>((Collection)this.get());
        copy.add("");
        this.set(copy);
        this.forceUpdateWidgetsTo((List<String>)copy);
        this.updateButtonStatus(this.def.validate(copy));
        this.list.ensureVisible2(copy.size() + 1);
    }

    protected void remove(int idx) {
        ArrayList<String> copy = new ArrayList<String>((Collection)this.get());
        copy.remove(idx);
        this.set(copy);
        this.forceUpdateWidgetsTo((List<String>)copy);
        this.updateButtonStatus(this.def.validate(copy));
    }

    protected class Entry
    extends ScrollableWidgetList.Entry<Entry> {
        private final int index;

        public Entry(int index) {
            this.index = index;
            String here = StringListInputScreen.this.getString(index);
            if (StringListInputScreen.this.getString(index) != null) {
                Minecraft mc = Minecraft.m_91087_();
                EditBox field = new EditBox(mc.f_91062_, 10, 3, 210, 20, (Component)Component.m_237113_((String)""));
                field.m_94199_(256);
                field.m_94144_(here);
                field.m_94192_(0);
                field.m_94151_(str -> StringListInputScreen.this.setString(index, (String)str));
                this.addScrollingWidget((AbstractWidget)field);
                this.addScrollingWidget((AbstractWidget)new Button(230, 3, 20, 20, (Component)Component.m_237113_((String)"-").m_130940_(ChatFormatting.RED), b -> StringListInputScreen.this.remove(index)));
            } else {
                this.addScrollingWidget((AbstractWidget)new Button(10, 3, 20, 20, (Component)Component.m_237113_((String)"+").m_130940_(ChatFormatting.GREEN), b -> StringListInputScreen.this.add()));
            }
        }

        public Component m_142172_() {
            return Component.m_237113_((String)Optional.ofNullable(StringListInputScreen.this.getString(this.index)).orElse(""));
        }
    }
}

