/*
 * Decompiled with CFR 0.152.
 */
package vazkii.zeta.client.config.screen;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import javax.annotation.Nonnull;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import org.apache.commons.lang3.text.WordUtils;
import org.jetbrains.annotations.NotNull;
import vazkii.zeta.client.ZetaClient;
import vazkii.zeta.client.config.definition.ClientDefinitionExt;
import vazkii.zeta.client.config.screen.ZetaScreen;
import vazkii.zeta.client.config.widget.DefaultDiscardDone;
import vazkii.zeta.client.config.widget.ScrollableWidgetList;
import vazkii.zeta.config.ChangeSet;
import vazkii.zeta.config.Definition;
import vazkii.zeta.config.SectionDefinition;
import vazkii.zeta.config.ValueDefinition;

public class SectionScreen
extends ZetaScreen {
    protected final SectionDefinition section;
    protected final ChangeSet changes;
    protected final String breadcrumbs;
    protected DefaultDiscardDone defaultDiscardDone;
    protected ScrollableWidgetList<SectionScreen, Entry> list;

    public SectionScreen(ZetaClient zc, Screen parent, ChangeSet changes, SectionDefinition section) {
        super(zc, parent);
        this.section = section;
        this.changes = changes;
        this.breadcrumbs = "> " + String.join((CharSequence)" > ", section.path);
    }

    protected void m_7856_() {
        super.m_7856_();
        this.defaultDiscardDone = new DefaultDiscardDone(this, this.changes, this.section);
        this.defaultDiscardDone.addWidgets(x$0 -> {
            AbstractWidget cfr_ignored_0 = (AbstractWidget)this.m_142416_((GuiEventListener)x$0);
        });
        this.list = new ScrollableWidgetList(this);
        for (ValueDefinition<?> value : this.section.getValues()) {
            this.list.addEntry(new ValueDefinitionEntry(this.changes, value));
        }
        Collection<SectionDefinition> subsections = this.section.getSubsections();
        if (!subsections.isEmpty()) {
            this.list.addEntry(new Divider());
            for (SectionDefinition subsection : this.section.getSubsections()) {
                this.list.addEntry(new SectionDefinitionEntry(this.changes, subsection));
            }
        }
        this.m_7787_((GuiEventListener)this.list);
        this.list.addChildWidgets(x$0 -> {
            AbstractWidget cfr_ignored_0 = (AbstractWidget)this.m_142416_((GuiEventListener)x$0);
        }, x$0 -> {
            AbstractWidget cfr_ignored_0 = (AbstractWidget)this.m_7787_((GuiEventListener)x$0);
        });
        this.defaultDiscardDone.discard.f_93623_ = this.changes.isDirty(this.section);
    }

    public void m_86600_() {
        this.defaultDiscardDone.discard.f_93623_ = this.changes.isDirty(this.section);
    }

    public void m_6305_(@Nonnull PoseStack mstack, int mouseX, int mouseY, float partialTicks) {
        this.m_7333_(mstack);
        this.list.m_6305_(mstack, mouseX, mouseY, partialTicks);
        super.m_6305_(mstack, mouseX, mouseY, partialTicks);
        this.list.reenableVisibleWidgets();
        int left = 20;
        String modName = WordUtils.capitalizeFully((String)this.z.modid);
        this.f_96547_.m_92883_(mstack, ChatFormatting.BOLD + I18n.m_118938_((String)"quark.gui.config.header", (Object[])new Object[]{modName}), (float)left, 10.0f, 4775356);
        this.f_96547_.m_92883_(mstack, this.breadcrumbs, (float)left, 20.0f, 0xFFFFFF);
    }

    public class ValueDefinitionEntry<X>
    extends DefinitionEntry<ValueDefinition<X>> {
        public ValueDefinitionEntry(ChangeSet changes, ValueDefinition<X> def) {
            super(SectionScreen.this, changes, def);
        }
    }

    public class Divider
    extends Entry {
        @Override
        public void m_6311_(@NotNull PoseStack mstack, int index, int rowTop, int rowLeft, int rowWidth, int rowHeight, int mouseX, int mouseY, boolean hovered, float partialTicks) {
            assert (SectionScreen.this.f_96541_ != null);
            String s = I18n.m_118938_((String)"quark.gui.config.subcategories", (Object[])new Object[0]);
            ((SectionScreen)SectionScreen.this).f_96541_.f_91062_.m_92750_(mstack, s, (float)rowLeft + (float)(rowWidth / 2 - ((SectionScreen)SectionScreen.this).f_96541_.f_91062_.m_92895_(s) / 2), (float)(rowTop + 7), 0x6666FF);
        }

        public Component m_142172_() {
            return Component.m_237113_((String)"");
        }
    }

    public class SectionDefinitionEntry
    extends DefinitionEntry<SectionDefinition> {
        public SectionDefinitionEntry(ChangeSet changes, SectionDefinition def) {
            super(SectionScreen.this, changes, (Definition)def);
        }
    }

    public static class DefinitionEntry<T extends Definition>
    extends Entry {
        private final ChangeSet changes;
        private final T def;
        private final ClientDefinitionExt<T> ext;
        final /* synthetic */ SectionScreen this$0;

        public DefinitionEntry(ChangeSet changes, T def) {
            this.this$0 = this$0;
            this.changes = changes;
            this.def = def;
            this.ext = this$0.zc.clientConfigManager.getExt(def);
            this.ext.addWidgets(this$0.zc, this$0, changes, def, this::addScrollingWidget);
        }

        @Override
        public void m_6311_(@NotNull PoseStack mstack, int index, int rowTop, int rowLeft, int rowWidth, int rowHeight, int mouseX, int mouseY, boolean hovered, float partialTicks) {
            assert (this.this$0.f_96541_ != null);
            int left = rowLeft + 10;
            int top = rowTop + 4;
            int effIndex = index + 1;
            if (this.def instanceof SectionDefinition) {
                --effIndex;
            }
            this.drawBackground(mstack, effIndex, rowTop, rowLeft, rowWidth, rowHeight, mouseX, mouseY, hovered);
            super.m_6311_(mstack, index, rowTop, rowLeft, rowWidth, rowHeight, mouseX, mouseY, hovered, partialTicks);
            Object name = ((Definition)this.def).getGuiDisplayName(x$0 -> I18n.m_118938_((String)x$0, (Object[])new Object[0]));
            if (this.changes.isDirty((Definition)this.def)) {
                name = (String)name + ChatFormatting.GOLD + "*";
            }
            int len = ((SectionScreen)this.this$0).f_96541_.f_91062_.m_92895_((String)name);
            int maxLen = rowWidth - 85;
            Object originalName = null;
            if (len > maxLen) {
                originalName = name;
                while ((len = ((SectionScreen)this.this$0).f_96541_.f_91062_.m_92895_((String)(name = ((String)name).substring(0, ((String)name).length() - 1)))) > maxLen) {
                }
                name = (String)name + "...";
            }
            AbstractList tooltip = new ArrayList<String>(((Definition)this.def).comment);
            if (originalName != null) {
                if (tooltip.isEmpty()) {
                    tooltip = new LinkedList();
                    tooltip.add((String)originalName);
                } else {
                    tooltip.add(0, (String)"");
                    tooltip.add(0, originalName);
                }
            }
            if (!tooltip.isEmpty()) {
                int hoverLeft = left + ((SectionScreen)this.this$0).f_96541_.f_91062_.m_92895_((String)name + " ");
                int hoverRight = hoverLeft + ((SectionScreen)this.this$0).f_96541_.f_91062_.m_92895_("(?)");
                name = (String)name + ChatFormatting.AQUA + " (?)";
                if (mouseX >= hoverLeft && mouseX < hoverRight && mouseY >= top && mouseY < top + 10) {
                    this.this$0.zc.topLayerTooltipHandler.setTooltip(tooltip, mouseX, mouseY);
                }
            }
            ((SectionScreen)this.this$0).f_96541_.f_91062_.m_92750_(mstack, (String)name, (float)left, (float)top, 0xFFFFFF);
            if (this.ext != null) {
                ((SectionScreen)this.this$0).f_96541_.f_91062_.m_92750_(mstack, this.ext.getSubtitle(this.changes, this.def), (float)left, (float)(top + 10), 0x999999);
            }
        }

        public Component m_142172_() {
            return Component.m_237113_((String)((Definition)this.def).getGuiDisplayName(x$0 -> I18n.m_118938_((String)x$0, (Object[])new Object[0])));
        }
    }

    public static abstract class Entry
    extends ScrollableWidgetList.Entry<Entry> {
    }
}

