/*
 * Decompiled with CFR 0.152.
 */
package vazkii.zeta.client.config.definition;

import com.google.common.base.Preconditions;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraftforge.client.gui.widget.ForgeSlider;
import org.jetbrains.annotations.Nullable;
import vazkii.quark.base.module.config.type.inputtable.RGBAColorConfig;
import vazkii.zeta.client.ZetaClient;
import vazkii.zeta.client.config.definition.ClientDefinitionExt;
import vazkii.zeta.client.config.screen.AbstractSectionInputScreen;
import vazkii.zeta.client.config.widget.PencilButton;
import vazkii.zeta.config.ChangeSet;
import vazkii.zeta.config.SectionDefinition;
import vazkii.zeta.config.ValueDefinition;

public class RGBClientDefinition
implements ClientDefinitionExt<SectionDefinition> {
    protected final ValueDefinition<Double> r;
    protected final ValueDefinition<Double> g;
    protected final ValueDefinition<Double> b;
    @Nullable
    protected final ValueDefinition<Double> a;

    public RGBClientDefinition(SectionDefinition def) {
        this.r = def.getValue("R", Double.class);
        this.g = def.getValue("G", Double.class);
        this.b = def.getValue("B", Double.class);
        this.a = def.getValue("A", Double.class);
        Preconditions.checkNotNull(this.r, (Object)"need an 'R' value in this section");
        Preconditions.checkNotNull(this.g, (Object)"need an 'G' value in this section");
        Preconditions.checkNotNull(this.b, (Object)"need an 'B' value in this section");
    }

    @Override
    public String getSubtitle(ChangeSet changes, SectionDefinition def) {
        double r = changes.get(this.r);
        double g = changes.get(this.g);
        double b = changes.get(this.b);
        if (this.a == null) {
            return String.format("[%.1f, %.1f, %.1f]", r, g, b);
        }
        double a = changes.get(this.a);
        return String.format("[%.1f, %.1f, %.1f, %.1f]", r, g, b, a);
    }

    @Override
    public void addWidgets(ZetaClient zc, Screen parent, ChangeSet changes, SectionDefinition def, Consumer<AbstractWidget> widgets) {
        RGBInputScreen newScreen = new RGBInputScreen(zc, parent, changes, def);
        widgets.accept((AbstractWidget)new PencilButton(zc, 230, 3, b1 -> Minecraft.m_91087_().m_91152_(newScreen)));
    }

    class RGBInputScreen
    extends AbstractSectionInputScreen {
        protected ForgeSlider rslide;
        protected ForgeSlider gslide;
        protected ForgeSlider bslide;
        @Nullable
        protected ForgeSlider aslide;
        private static final Component EMPTY = Component.m_237119_();

        public RGBInputScreen(ZetaClient zc, Screen parent, ChangeSet changes, SectionDefinition def) {
            super(zc, parent, changes, def);
        }

        @Override
        protected void m_7856_() {
            super.m_7856_();
            int w = 100;
            int p = 12;
            int x = this.f_96543_ / 2 - 110;
            int y = 55;
            this.rslide = (ForgeSlider)this.m_142416_((GuiEventListener)this.makeSliderPlease(x, y, w - p, 20, RGBClientDefinition.this.r, "R =", 0xFF0000));
            this.gslide = (ForgeSlider)this.m_142416_((GuiEventListener)this.makeSliderPlease(x, y + 25, w - p, 20, RGBClientDefinition.this.g, "G = ", 65280));
            this.bslide = (ForgeSlider)this.m_142416_((GuiEventListener)this.makeSliderPlease(x, y + 50, w - p, 20, RGBClientDefinition.this.b, "B = ", 30719));
            if (RGBClientDefinition.this.a != null) {
                this.aslide = (ForgeSlider)this.m_142416_((GuiEventListener)this.makeSliderPlease(x, y + 75, w - p, 20, RGBClientDefinition.this.a, "A = ", 0xFFFFFF));
            }
            this.forceUpdateWidgets();
        }

        @Override
        protected void forceUpdateWidgets() {
            this.rslide.m_93611_(this.changes.get(RGBClientDefinition.this.r).doubleValue());
            this.gslide.m_93611_(this.changes.get(RGBClientDefinition.this.g).doubleValue());
            this.bslide.m_93611_(this.changes.get(RGBClientDefinition.this.b).doubleValue());
            if (this.aslide != null) {
                this.aslide.m_93611_(this.changes.get(RGBClientDefinition.this.a).doubleValue());
            }
        }

        private ForgeSlider makeSliderPlease(int x, int y, int width, int height, final ValueDefinition<Double> binding, final String label, final int labelColor) {
            return new ForgeSlider(x, y + 50, width, height, EMPTY, EMPTY, 0.0, 1.0, 0.0, 0.0, 1, false){

                protected void m_5697_() {
                    this.m_93611_(RGBInputScreen.this.snap(this));
                    RGBInputScreen.this.changes.set(binding, this.getValue());
                }

                public void m_6305_(@Nonnull PoseStack mstack, int mouseX, int mouseY, float partialTicks) {
                    super.m_6305_(mstack, mouseX, mouseY, partialTicks);
                    String displayVal = String.format("%.2f", this.getValue());
                    int valueColor = RGBInputScreen.this.changes.isDirty(binding) ? ChatFormatting.GOLD.m_126665_() : 0xFFFFFF;
                    RGBInputScreen.this.f_96547_.m_92750_(mstack, displayVal, (float)this.f_93620_ + (float)(this.m_5711_() / 2 - RGBInputScreen.this.f_96547_.m_92895_(displayVal) / 2), (float)(this.f_93621_ + 6), valueColor);
                    RGBInputScreen.this.f_96547_.m_92750_(mstack, label, (float)(this.f_93620_ - 20), (float)(this.f_93621_ + 5), labelColor);
                }
            };
        }

        public void m_86600_() {
            this.updateButtonStatus(true);
        }

        public void m_6305_(@Nonnull PoseStack mstack, int mouseX, int mouseY, float partialTicks) {
            this.m_7333_(mstack);
            super.m_6305_(mstack, mouseX, mouseY, partialTicks);
            int titleLeft = this.f_96543_ / 2;
            RGBInputScreen.m_93215_((PoseStack)mstack, (Font)this.f_96547_, (Component)Component.m_237113_((String)this.ext.getGuiDisplayName(this.changes, this.def)).m_130940_(ChatFormatting.BOLD), (int)titleLeft, (int)20, (int)0xFFFFFF);
            int cx = this.f_96543_ / 2 + 20;
            int cy = 55;
            int size = 95;
            int color = RGBAColorConfig.forColor(this.rslide.getValue(), this.gslide.getValue(), this.bslide.getValue(), this.aslide == null ? 1.0 : this.aslide.getValue()).getColor();
            RGBInputScreen.m_93172_((PoseStack)mstack, (int)(cx - 1), (int)(cy - 1), (int)(cx + size + 1), (int)(cy + size + 1), (int)-16777216);
            RGBInputScreen.m_93172_((PoseStack)mstack, (int)cx, (int)cy, (int)(cx + size), (int)(cy + size), (int)-6710887);
            RGBInputScreen.m_93172_((PoseStack)mstack, (int)cx, (int)cy, (int)(cx + size / 2), (int)(cy + size / 2), (int)-10066330);
            RGBInputScreen.m_93172_((PoseStack)mstack, (int)(cx + size / 2), (int)(cy + size / 2), (int)(cx + size), (int)(cy + size), (int)-10066330);
            RGBInputScreen.m_93172_((PoseStack)mstack, (int)cx, (int)cy, (int)(cx + size), (int)(cy + size), (int)color);
        }

        private double snap(ForgeSlider s) {
            double val = s.getValue();
            val = this.snap(val, 0.0, s);
            val = this.snap(val, 0.25, s);
            val = this.snap(val, 0.5, s);
            val = this.snap(val, 0.75, s);
            val = this.snap(val, 1.0, s);
            return val;
        }

        private double snap(double val, double target, ForgeSlider s) {
            if (Math.abs(val - target) < 0.02) {
                s.m_93611_(target);
                return target;
            }
            return val;
        }
    }
}

