/*
 * Decompiled with CFR 0.152.
 */
package vazkii.zeta.client.config.definition;

import java.util.function.Consumer;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.resources.language.I18n;
import vazkii.zeta.client.ZetaClient;
import vazkii.zeta.config.ChangeSet;
import vazkii.zeta.config.Definition;
import vazkii.zeta.config.SectionDefinition;

public interface ClientDefinitionExt<T extends Definition> {
    default public String getGuiDisplayName(ChangeSet changes, T def) {
        String defName = def instanceof SectionDefinition ? ((Definition)def).name.replace("_", "") : ((Definition)def).name;
        String transKey = "quark.config." + String.join((CharSequence)".", ((Definition)def).path) + "." + ((Definition)def).name.toLowerCase().replaceAll(" ", "_").replaceAll("[^A-Za-z0-9_]", "") + ".name";
        String localized = I18n.m_118938_((String)transKey, (Object[])new Object[0]);
        if (localized.isEmpty() || localized.equals(transKey)) {
            return defName;
        }
        return localized;
    }

    public String getSubtitle(ChangeSet var1, T var2);

    public void addWidgets(ZetaClient var1, Screen var2, ChangeSet var3, T var4, Consumer<AbstractWidget> var5);

    default public String truncate(String in) {
        if (in.length() > 30) {
            return in.substring(0, 27) + "...";
        }
        return in;
    }

    public static class Default
    implements ClientDefinitionExt<Definition> {
        @Override
        public String getSubtitle(ChangeSet changes, Definition def) {
            return "";
        }

        @Override
        public void addWidgets(ZetaClient zc, Screen parent, ChangeSet changes, Definition def, Consumer<AbstractWidget> widgets) {
        }
    }
}

