/*
 * Decompiled with CFR 0.152.
 */
package vazkii.zeta.client.config;

import java.util.List;
import org.jetbrains.annotations.NotNull;
import vazkii.quark.base.module.config.type.inputtable.ConvulsionMatrixConfig;
import vazkii.quark.base.module.config.type.inputtable.RGBColorConfig;
import vazkii.zeta.client.config.definition.BooleanClientDefinition;
import vazkii.zeta.client.config.definition.ClientDefinitionExt;
import vazkii.zeta.client.config.definition.ConvulsionMatrixClientDefinition;
import vazkii.zeta.client.config.definition.DoubleClientDefinition;
import vazkii.zeta.client.config.definition.IntegerClientDefinition;
import vazkii.zeta.client.config.definition.RGBClientDefinition;
import vazkii.zeta.client.config.definition.SectionClientDefinition;
import vazkii.zeta.client.config.definition.StringClientDefinition;
import vazkii.zeta.client.config.definition.StringListClientDefinition;
import vazkii.zeta.config.Definition;
import vazkii.zeta.config.SectionDefinition;
import vazkii.zeta.config.ValueDefinition;

public class ClientConfigManager {
    @NotNull
    public <D extends Definition> ClientDefinitionExt<D> getExt(D def) {
        if (def.hint instanceof RGBColorConfig) {
            return new RGBClientDefinition((SectionDefinition)def);
        }
        Object object = def.hint;
        if (object instanceof ConvulsionMatrixConfig) {
            ConvulsionMatrixConfig convulsion = (ConvulsionMatrixConfig)object;
            return new ConvulsionMatrixClientDefinition(convulsion, (SectionDefinition)def);
        }
        if (def instanceof SectionDefinition) {
            return new SectionClientDefinition();
        }
        if (def instanceof ValueDefinition) {
            ValueDefinition val = (ValueDefinition)def;
            if (val.defaultValue instanceof Boolean) {
                return new BooleanClientDefinition();
            }
            if (val.defaultValue instanceof String) {
                return new StringClientDefinition();
            }
            if (val.defaultValue instanceof Integer) {
                return new IntegerClientDefinition();
            }
            if (val.defaultValue instanceof Double) {
                return new DoubleClientDefinition();
            }
            if (val.defaultValue instanceof List) {
                return new StringListClientDefinition();
            }
        }
        return new ClientDefinitionExt.Default();
    }
}

