/*
 * Decompiled with CFR 0.152.
 */
package vazkii.zeta.client;

import java.util.Objects;
import net.minecraft.client.color.block.BlockColor;
import net.minecraft.client.color.block.BlockColors;
import net.minecraft.client.color.item.ItemColor;
import net.minecraft.client.color.item.ItemColors;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import org.jetbrains.annotations.Nullable;
import vazkii.zeta.Zeta;
import vazkii.zeta.client.ClientTicker;
import vazkii.zeta.client.TopLayerTooltipHandler;
import vazkii.zeta.client.config.ClientConfigManager;
import vazkii.zeta.event.bus.IZetaLoadEvent;
import vazkii.zeta.event.bus.IZetaPlayEvent;
import vazkii.zeta.event.bus.ZetaEventBus;
import vazkii.zeta.registry.DyeablesRegistry;

public abstract class ZetaClient {
    public final Zeta zeta;
    protected final ZetaEventBus<IZetaLoadEvent> loadBus;
    protected final ZetaEventBus<IZetaPlayEvent> playBus;
    public ResourceLocation generalIcons = new ResourceLocation("zeta", "textures/gui/general_icons.png");
    public final ClientTicker ticker;
    public final ClientConfigManager clientConfigManager;
    public final TopLayerTooltipHandler topLayerTooltipHandler;
    public final DyeablesRegistry.Client clientDyeablesRegistry;

    public ZetaClient(Zeta zeta) {
        this.zeta = zeta;
        this.loadBus = zeta.loadBus;
        this.playBus = zeta.playBus;
        this.ticker = zeta.ticker_SHOULD_NOT_BE_HERE;
        this.clientConfigManager = new ClientConfigManager();
        this.topLayerTooltipHandler = new TopLayerTooltipHandler();
        DyeablesRegistry dyeablesRegistry = zeta.dyeables;
        Objects.requireNonNull(dyeablesRegistry);
        this.clientDyeablesRegistry = dyeablesRegistry.new DyeablesRegistry.Client(this);
        this.playBus.subscribe(this.topLayerTooltipHandler);
    }

    @Nullable
    public abstract BlockColor getBlockColor(BlockColors var1, Block var2);

    @Nullable
    public abstract ItemColor getItemColor(ItemColors var1, ItemLike var2);

    public abstract void start();
}

