/*
 * Decompiled with CFR 0.152.
 */
package vazkii.zeta;

import net.minecraft.core.BlockPos;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ElytraItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.BlockHitResult;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.Nullable;
import vazkii.zeta.client.ClientTicker;
import vazkii.zeta.config.ConfigManager;
import vazkii.zeta.config.IZetaConfigInternals;
import vazkii.zeta.config.SectionDefinition;
import vazkii.zeta.event.bus.IZetaLoadEvent;
import vazkii.zeta.event.bus.IZetaPlayEvent;
import vazkii.zeta.event.bus.LoadEvent;
import vazkii.zeta.event.bus.PlayEvent;
import vazkii.zeta.event.bus.ZetaEventBus;
import vazkii.zeta.module.ModuleFinder;
import vazkii.zeta.module.ZetaCategory;
import vazkii.zeta.module.ZetaModuleManager;
import vazkii.zeta.network.ZetaNetworkHandler;
import vazkii.zeta.registry.BrewingRegistry;
import vazkii.zeta.registry.CraftingExtensionsRegistry;
import vazkii.zeta.registry.DyeablesRegistry;
import vazkii.zeta.registry.ZetaRegistry;
import vazkii.zeta.util.ZetaSide;

public abstract class Zeta {
    public final Logger log;
    public final String modid;
    public final ZetaSide side;
    public final ZetaEventBus<IZetaLoadEvent> loadBus;
    public final ZetaEventBus<IZetaPlayEvent> playBus;
    public final ZetaModuleManager modules;
    public final ZetaRegistry registry;
    public final DyeablesRegistry dyeables;
    public final CraftingExtensionsRegistry craftingExtensions;
    public final BrewingRegistry brewingRegistry;
    public ConfigManager configManager;
    public IZetaConfigInternals configInternals;
    @Deprecated
    public final ClientTicker ticker_SHOULD_NOT_BE_HERE;

    public Zeta(String modid, Logger log, ZetaSide side) {
        this.log = log;
        this.modid = modid;
        this.side = side;
        this.loadBus = new ZetaEventBus<IZetaLoadEvent>(LoadEvent.class, IZetaLoadEvent.class, log);
        this.playBus = new ZetaEventBus<IZetaPlayEvent>(PlayEvent.class, IZetaPlayEvent.class, null);
        this.modules = this.createModuleManager();
        this.registry = this.createRegistry();
        this.dyeables = this.createDyeablesRegistry();
        this.craftingExtensions = this.createCraftingExtensionsRegistry();
        this.brewingRegistry = this.createBrewingRegistry();
        this.ticker_SHOULD_NOT_BE_HERE = new ClientTicker();
    }

    public void loadModules(Iterable<ZetaCategory> categories, ModuleFinder finder, Object rootPojo) {
        this.modules.initCategories(categories);
        this.modules.load(finder);
        this.configManager = new ConfigManager(this, rootPojo);
        this.configInternals = this.makeConfigInternals(this.configManager.getRootConfig());
        this.configManager.onReload();
    }

    public abstract boolean isModLoaded(String var1);

    @Nullable
    public abstract String getModDisplayName(String var1);

    public abstract IZetaConfigInternals makeConfigInternals(SectionDefinition var1);

    public ZetaModuleManager createModuleManager() {
        return new ZetaModuleManager(this);
    }

    public abstract ZetaRegistry createRegistry();

    public abstract CraftingExtensionsRegistry createCraftingExtensionsRegistry();

    public DyeablesRegistry createDyeablesRegistry() {
        return new DyeablesRegistry(this);
    }

    public abstract BrewingRegistry createBrewingRegistry();

    public abstract ZetaNetworkHandler createNetworkHandler(String var1, int var2);

    public abstract boolean fireRightClickBlock(Player var1, InteractionHand var2, BlockPos var3, BlockHitResult var4);

    public boolean canElytraFly(ItemStack stack, LivingEntity entity) {
        return stack.m_41720_() instanceof ElytraItem && ElytraItem.m_41140_((ItemStack)stack);
    }

    public abstract void start();
}

