/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.integration.lootr.client;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.resources.model.Material;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.properties.ChestType;
import noobanidus.mods.lootr.config.ConfigManager;
import noobanidus.mods.lootr.util.Getter;
import vazkii.quark.base.client.render.GenericChestBERenderer;
import vazkii.quark.content.building.module.VariantChestsModule;
import vazkii.quark.integration.lootr.LootrVariantChestBlockEntity;
import vazkii.zeta.client.event.ZPreTextureStitch;

public class LootrVariantChestRenderer<T extends LootrVariantChestBlockEntity>
extends GenericChestBERenderer<T> {
    private UUID playerId = null;
    private static final Map<Block, ChestTextureBatch> chestTextures = new HashMap<Block, ChestTextureBatch>();

    public LootrVariantChestRenderer(BlockEntityRendererProvider.Context context) {
        super(context);
    }

    @Override
    public Material getMaterial(T tile, ChestType type) {
        Block block = tile.m_58900_().m_60734_();
        ChestTextureBatch batch = chestTextures.get(block);
        if (batch == null) {
            return null;
        }
        if (ConfigManager.isVanillaTextures()) {
            return batch.base;
        }
        if (this.playerId == null) {
            Player player = Getter.getPlayer();
            if (player != null) {
                this.playerId = player.m_20148_();
            } else {
                return batch.unopened;
            }
        }
        if (tile.isOpened()) {
            return batch.opened;
        }
        if (tile.getOpeners().contains(this.playerId)) {
            return batch.opened;
        }
        return batch.unopened;
    }

    public static void accept(ZPreTextureStitch event, Block chest) {
        ResourceLocation atlas = event.getAtlas().m_118330_();
        if (chest instanceof VariantChestsModule.IChestTextureProvider) {
            VariantChestsModule.IChestTextureProvider prov = (VariantChestsModule.IChestTextureProvider)chest;
            String path = prov.getChestTexturePath();
            if (prov.isTrap()) {
                LootrVariantChestRenderer.add(event, atlas, chest, path, "trap", "lootr_trap", "lootr_trap_opened");
            } else {
                LootrVariantChestRenderer.add(event, atlas, chest, path, "normal", "lootr_normal", "lootr_opened");
            }
        }
    }

    private static void add(ZPreTextureStitch event, ResourceLocation atlas, Block chest, String path, String baseSuffix, String unopenedSuffix, String openedSuffix) {
        ResourceLocation resBase = new ResourceLocation("quark", path + baseSuffix);
        ResourceLocation resUnopened = new ResourceLocation("quark", path + unopenedSuffix);
        ResourceLocation resOpened = new ResourceLocation("quark", path + openedSuffix);
        ChestTextureBatch batch = new ChestTextureBatch(atlas, resBase, resUnopened, resOpened);
        chestTextures.put(chest, batch);
        event.addSprite(resUnopened);
        event.addSprite(resOpened);
    }

    private static class ChestTextureBatch {
        public final Material base;
        public final Material unopened;
        public final Material opened;

        public ChestTextureBatch(ResourceLocation atlas, ResourceLocation base, ResourceLocation unopened, ResourceLocation opened) {
            this.base = new Material(atlas, base);
            this.unopened = new Material(atlas, unopened);
            this.opened = new Material(atlas, opened);
        }
    }
}

