/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.integration.jei;

import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.constants.RecipeTypes;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.handlers.IGuiContainerHandler;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IRecipeManager;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.recipe.transfer.IRecipeTransferHandler;
import mezz.jei.api.recipe.vanilla.IJeiAnvilRecipe;
import mezz.jei.api.recipe.vanilla.IVanillaRecipeFactory;
import mezz.jei.api.registration.IGuiHandlerRegistration;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import mezz.jei.api.registration.IRecipeTransferRegistration;
import mezz.jei.api.registration.ISubtypeRegistration;
import mezz.jei.api.registration.IVanillaCategoryExtensionRegistration;
import mezz.jei.api.runtime.IJeiRuntime;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.core.NonNullList;
import net.minecraft.core.Registry;
import net.minecraft.data.BuiltinRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.EnchantedBookItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.PotionItem;
import net.minecraft.world.item.TippedArrowItem;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.EnchantmentInstance;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.registries.ForgeRegistries;
import vazkii.quark.addons.oddities.block.be.MatrixEnchantingTableBlockEntity;
import vazkii.quark.addons.oddities.client.screen.BackpackInventoryScreen;
import vazkii.quark.addons.oddities.client.screen.CrateScreen;
import vazkii.quark.addons.oddities.module.MatrixEnchantingModule;
import vazkii.quark.addons.oddities.util.CustomInfluence;
import vazkii.quark.addons.oddities.util.Influence;
import vazkii.quark.base.Quark;
import vazkii.quark.base.block.IQuarkBlock;
import vazkii.quark.base.client.handler.RequiredModTooltipHandler;
import vazkii.quark.base.handler.GeneralConfig;
import vazkii.quark.base.handler.MiscUtil;
import vazkii.quark.base.item.IQuarkItem;
import vazkii.quark.base.item.QuarkItem;
import vazkii.quark.base.module.ModuleLoader;
import vazkii.quark.content.building.module.VariantFurnacesModule;
import vazkii.quark.content.client.module.ImprovedTooltipsModule;
import vazkii.quark.content.client.tooltip.EnchantedBookTooltips;
import vazkii.quark.content.tools.item.AncientTomeItem;
import vazkii.quark.content.tools.module.AncientTomesModule;
import vazkii.quark.content.tools.module.ColorRunesModule;
import vazkii.quark.content.tools.module.PickarangModule;
import vazkii.quark.content.tweaks.module.DiamondRepairModule;
import vazkii.quark.content.tweaks.recipe.ElytraDuplicationRecipe;
import vazkii.quark.content.tweaks.recipe.SlabToBlockRecipe;
import vazkii.quark.integration.jei.BackpackRecipeTransferHandler;
import vazkii.quark.integration.jei.ElytraDuplicationExtension;
import vazkii.quark.integration.jei.InfluenceCategory;
import vazkii.quark.integration.jei.InfluenceEntry;
import vazkii.quark.integration.jei.SlabToBlockExtension;
import vazkii.zeta.event.ZGatherHints;
import vazkii.zeta.util.ItemNBTHelper;
import vazkii.zeta.util.RegistryUtil;

@JeiPlugin
public class QuarkJeiPlugin
implements IModPlugin {
    private static final ResourceLocation UID = new ResourceLocation("quark", "quark");
    public static final RecipeType<InfluenceEntry> INFLUENCING = RecipeType.create((String)"quark", (String)"influence", InfluenceEntry.class);

    @Nonnull
    public ResourceLocation getPluginUid() {
        return UID;
    }

    public void registerItemSubtypes(@Nonnull ISubtypeRegistration registration) {
        registration.useNbtForSubtypes(new Item[]{AncientTomesModule.ancient_tome});
    }

    public void onRuntimeAvailable(@Nonnull IJeiRuntime jeiRuntime) {
        List<ItemStack> disabledItems = RequiredModTooltipHandler.disabledItems();
        if (!disabledItems.isEmpty()) {
            jeiRuntime.getIngredientManager().removeIngredientsAtRuntime((IIngredientType)VanillaTypes.ITEM_STACK, disabledItems);
        }
        Quark.ZETA.configManager.setJeiReloadListener(z -> {
            if (ModuleLoader.INSTANCE.isModuleEnabled(DiamondRepairModule.class)) {
                Minecraft.m_91087_().m_18689_(() -> this.hideAnvilRepairRecipes(jeiRuntime.getRecipeManager()));
            }
            if (!GeneralConfig.hideDisabledContent) {
                return;
            }
            HashSet hidePotions = Sets.newHashSet();
            for (Potion potion : ForgeRegistries.POTIONS.getValues()) {
                ResourceLocation loc = ForgeRegistries.POTIONS.getKey((Object)potion);
                if (loc == null || !loc.m_135827_().equals("quark") || Quark.ZETA.brewingRegistry.isEnabled(potion)) continue;
                hidePotions.add(potion);
            }
            NonNullList stacks = NonNullList.m_122779_();
            for (Item item : ForgeRegistries.ITEMS.getValues()) {
                IQuarkBlock quarkBlock;
                BlockItem blockItem;
                Block patt4880$temp;
                IQuarkItem quarkItem;
                ResourceLocation loc = ForgeRegistries.ITEMS.getKey((Object)item);
                if (loc != null && loc.m_135827_().equals("quark") && (item instanceof IQuarkItem && !(quarkItem = (IQuarkItem)item).isEnabled() || item instanceof BlockItem && (patt4880$temp = (blockItem = (BlockItem)item).m_40614_()) instanceof IQuarkBlock && !(quarkBlock = (IQuarkBlock)patt4880$temp).isEnabled())) {
                    item.m_6787_(CreativeModeTab.f_40754_, stacks);
                }
                if (!(item instanceof PotionItem) && !(item instanceof TippedArrowItem)) continue;
                NonNullList potionStacks = NonNullList.m_122779_();
                item.m_6787_(CreativeModeTab.f_40754_, potionStacks);
                potionStacks.stream().filter(it -> hidePotions.contains(PotionUtils.m_43579_((ItemStack)it))).forEach(arg_0 -> stacks.add(arg_0));
            }
            if (!stacks.isEmpty()) {
                Minecraft.m_91087_().m_18689_(() -> jeiRuntime.getIngredientManager().removeIngredientsAtRuntime((IIngredientType)VanillaTypes.ITEM_STACK, (Collection)stacks));
            }
        });
    }

    public void registerVanillaCategoryExtensions(@Nonnull IVanillaCategoryExtensionRegistration registration) {
        registration.getCraftingCategory().addCategoryExtension(ElytraDuplicationRecipe.class, ElytraDuplicationExtension::new);
        registration.getCraftingCategory().addCategoryExtension(SlabToBlockRecipe.class, SlabToBlockExtension::new);
    }

    private boolean matrix() {
        return ModuleLoader.INSTANCE.isModuleEnabled(MatrixEnchantingModule.class) && MatrixEnchantingModule.allowInfluencing && !MatrixEnchantingModule.candleInfluencingFailed;
    }

    public void registerCategories(@Nonnull IRecipeCategoryRegistration registration) {
        if (this.matrix()) {
            registration.addRecipeCategories(new IRecipeCategory[]{new InfluenceCategory(registration.getJeiHelpers().getGuiHelper())});
        }
    }

    public void registerRecipes(@Nonnull IRecipeRegistration registration) {
        IVanillaRecipeFactory factory = registration.getVanillaRecipeFactory();
        if (ModuleLoader.INSTANCE.isModuleEnabled(AncientTomesModule.class)) {
            this.registerAncientTomeAnvilRecipes(registration, factory);
        }
        if (ModuleLoader.INSTANCE.isModuleEnabled(PickarangModule.class)) {
            this.registerPickarangAnvilRepairs(PickarangModule.pickarang, Items.f_42415_, registration, factory);
            this.registerPickarangAnvilRepairs(PickarangModule.flamerang, Items.f_42418_, registration, factory);
        }
        if (ModuleLoader.INSTANCE.isModuleEnabled(ColorRunesModule.class)) {
            this.registerRuneAnvilRecipes(registration, factory);
        }
        if (this.matrix()) {
            this.registerInfluenceRecipes(registration);
        }
        if (ModuleLoader.INSTANCE.isModuleEnabled(DiamondRepairModule.class)) {
            this.registerCustomAnvilRecipes(registration, factory);
        }
        if (GeneralConfig.enableJeiItemInfo) {
            MutableComponent externalPreamble = Component.m_237115_((String)"quark.jei.hint_preamble");
            externalPreamble.m_6270_(externalPreamble.m_7383_().m_178520_(744779));
            List blacklist = RegistryUtil.massRegistryGet(GeneralConfig.suppressedInfo, Registry.f_122827_);
            Quark.ZETA.playBus.fire((item, component) -> {
                if (blacklist.contains(item)) {
                    return;
                }
                MutableComponent compound = Component.m_237113_((String)"");
                if (!ForgeRegistries.ITEMS.getKey(item).m_135827_().equals("quark")) {
                    compound = compound.m_7220_((Component)externalPreamble);
                }
                compound = compound.m_7220_(component);
                registration.addItemStackInfo(new ItemStack((ItemLike)item), new Component[]{compound});
            }, ZGatherHints.class);
        }
    }

    public void registerRecipeCatalysts(@Nonnull IRecipeCatalystRegistration registration) {
        if (ModuleLoader.INSTANCE.isModuleEnabled(VariantFurnacesModule.class)) {
            registration.addRecipeCatalyst(new ItemStack((ItemLike)VariantFurnacesModule.deepslateFurnace), new RecipeType[]{RecipeTypes.FUELING, RecipeTypes.SMELTING});
            registration.addRecipeCatalyst(new ItemStack((ItemLike)VariantFurnacesModule.blackstoneFurnace), new RecipeType[]{RecipeTypes.FUELING, RecipeTypes.SMELTING});
        }
        if (this.matrix()) {
            if (MatrixEnchantingModule.automaticallyConvert) {
                registration.addRecipeCatalyst(new ItemStack((ItemLike)Blocks.f_50201_), new RecipeType[]{INFLUENCING});
            } else {
                registration.addRecipeCatalyst(new ItemStack((ItemLike)MatrixEnchantingModule.matrixEnchanter), new RecipeType[]{INFLUENCING});
            }
        }
    }

    public void registerGuiHandlers(@Nonnull IGuiHandlerRegistration registration) {
        registration.addGuiContainerHandler(CrateScreen.class, (IGuiContainerHandler)new CrateGuiHandler());
        registration.addRecipeClickArea(BackpackInventoryScreen.class, 137, 29, 10, 13, new RecipeType[]{RecipeTypes.CRAFTING});
    }

    public void registerRecipeTransferHandlers(IRecipeTransferRegistration registration) {
        registration.addRecipeTransferHandler((IRecipeTransferHandler)new BackpackRecipeTransferHandler(registration.getTransferHelper()), RecipeTypes.CRAFTING);
    }

    private void registerAncientTomeAnvilRecipes(@Nonnull IRecipeRegistration registration, @Nonnull IVanillaRecipeFactory factory) {
        ArrayList<IJeiAnvilRecipe> recipes = new ArrayList<IJeiAnvilRecipe>();
        for (Enchantment enchant : AncientTomesModule.validEnchants) {
            EnchantmentInstance data = new EnchantmentInstance(enchant, enchant.m_6586_());
            recipes.add(factory.createAnvilRecipe(EnchantedBookItem.m_41161_((EnchantmentInstance)data), Collections.singletonList(AncientTomeItem.getEnchantedItemStack(enchant)), Collections.singletonList(EnchantedBookItem.m_41161_((EnchantmentInstance)new EnchantmentInstance(data.f_44947_, data.f_44948_ + 1)))));
        }
        registration.addRecipes(RecipeTypes.ANVIL, recipes);
    }

    private void registerRuneAnvilRecipes(@Nonnull IRecipeRegistration registration, @Nonnull IVanillaRecipeFactory factory) {
        RandomSource random = RandomSource.m_216327_();
        Stream<Object> displayItems = ModuleLoader.INSTANCE.isModuleEnabled(ImprovedTooltipsModule.class) && ImprovedTooltipsModule.enchantingTooltips ? EnchantedBookTooltips.getTestItems().stream() : Stream.of(Items.f_42388_, Items.f_42390_, Items.f_42391_, Items.f_42389_, Items.f_42392_, Items.f_42472_, Items.f_42473_, Items.f_42474_, Items.f_42475_, Items.f_42741_, Items.f_42740_, Items.f_42411_, Items.f_42717_, Items.f_42713_, Items.f_42523_, Items.f_42574_, PickarangModule.pickarang).map(ItemStack::new);
        List used = displayItems.filter(it -> {
            QuarkItem qItem;
            Item patt10751$temp = it.m_41720_();
            return !(patt10751$temp instanceof QuarkItem) || (qItem = (QuarkItem)patt10751$temp).isEnabled();
        }).map(item -> QuarkJeiPlugin.makeEnchantedDisplayItem(item, random)).collect(Collectors.toList());
        ArrayList<IJeiAnvilRecipe> recipes = new ArrayList<IJeiAnvilRecipe>();
        for (Item rune : MiscUtil.getTagValues(BuiltinRegistries.f_206379_, ColorRunesModule.runesTag)) {
            ItemStack runeStack = new ItemStack((ItemLike)rune);
            recipes.add(factory.createAnvilRecipe(used, Collections.singletonList(runeStack), used.stream().map(stack -> {
                ItemStack output = stack.m_41777_();
                ItemNBTHelper.setBoolean(output, "quark:RuneAttached", true);
                ItemNBTHelper.setCompound(output, "quark:RuneColor", runeStack.serializeNBT());
                return output;
            }).collect(Collectors.toList())));
        }
        registration.addRecipes(RecipeTypes.ANVIL, recipes);
    }

    @Nonnull
    private static ItemStack makeEnchantedDisplayItem(ItemStack input, RandomSource random) {
        ItemStack stack = input.m_41777_();
        stack.m_41714_((Component)Component.m_237115_((String)"quark.jei.any_enchanted"));
        if (stack.getEnchantmentValue() <= 0) {
            stack.m_41663_(Enchantments.f_44986_, 3);
            return stack;
        }
        return EnchantmentHelper.m_220292_((RandomSource)random, (ItemStack)stack, (int)25, (boolean)false);
    }

    private void registerPickarangAnvilRepairs(Item pickarang, Item repairMaterial, @Nonnull IRecipeRegistration registration, @Nonnull IVanillaRecipeFactory factory) {
        ItemStack nearlyBroken = new ItemStack((ItemLike)pickarang);
        nearlyBroken.m_41721_(nearlyBroken.m_41776_());
        ItemStack veryDamaged = nearlyBroken.m_41777_();
        veryDamaged.m_41721_(veryDamaged.m_41776_() * 3 / 4);
        ItemStack damaged = nearlyBroken.m_41777_();
        damaged.m_41721_(damaged.m_41776_() * 2 / 4);
        IJeiAnvilRecipe materialRepair = factory.createAnvilRecipe(nearlyBroken, Collections.singletonList(new ItemStack((ItemLike)repairMaterial)), Collections.singletonList(veryDamaged));
        IJeiAnvilRecipe toolRepair = factory.createAnvilRecipe(veryDamaged, Collections.singletonList(veryDamaged), Collections.singletonList(damaged));
        registration.addRecipes(RecipeTypes.ANVIL, Arrays.asList(materialRepair, toolRepair));
    }

    private void registerInfluenceRecipes(@Nonnull IRecipeRegistration registration) {
        registration.addRecipes(INFLUENCING, Arrays.stream(DyeColor.values()).map(color -> {
            Block candle = MatrixEnchantingTableBlockEntity.CANDLES.get(color.m_41060_());
            Influence influence = MatrixEnchantingModule.candleInfluences.get(color);
            return new InfluenceEntry(candle, influence);
        }).filter(InfluenceEntry::hasAny).collect(Collectors.toList()));
        registration.addRecipes(INFLUENCING, MatrixEnchantingModule.customInfluences.entrySet().stream().map(entry -> {
            Block block = ((BlockState)entry.getKey()).m_60734_();
            Influence influence = ((CustomInfluence)entry.getValue()).influence();
            return new InfluenceEntry(block, influence);
        }).filter(InfluenceEntry::hasAny).collect(Collectors.toList()));
    }

    private void hideAnvilRepairRecipes(@Nonnull IRecipeManager manager) {
        Stream anvilRecipe = manager.createRecipeLookup(RecipeTypes.ANVIL).get();
        List hidden = anvilRecipe.filter(r -> {
            ItemStack left = r.getLeftInputs().stream().filter(st -> {
                Item i = st.m_41720_();
                return DiamondRepairModule.repairChanges.containsKey((Object)i) || DiamondRepairModule.unrepairableItems.contains(i);
            }).findFirst().orElse(null);
            if (left != null) {
                for (ItemStack right : r.getRightInputs()) {
                    Item item = left.m_41720_();
                    if (!item.m_6832_(left, right)) continue;
                    return true;
                }
            }
            return false;
        }).collect(Collectors.toList());
        manager.hideRecipes(RecipeTypes.ANVIL, hidden);
    }

    private void registerCustomAnvilRecipes(@Nonnull IRecipeRegistration registration, @Nonnull IVanillaRecipeFactory factory) {
        for (Item item : DiamondRepairModule.repairChanges.keySet()) {
            ItemStack left = new ItemStack((ItemLike)item);
            ItemStack out = left.m_41777_();
            int max = item.getMaxDamage(left);
            left.m_41721_(max - 1);
            out.m_41721_(max - max / 4);
            for (Item repair : DiamondRepairModule.repairChanges.get((Object)item)) {
                IJeiAnvilRecipe toolRepair = factory.createAnvilRecipe(left, Collections.singletonList(new ItemStack((ItemLike)repair)), Collections.singletonList(out));
                registration.addRecipes(RecipeTypes.ANVIL, Arrays.asList(toolRepair));
            }
        }
    }

    private static class CrateGuiHandler
    implements IGuiContainerHandler<CrateScreen> {
        private CrateGuiHandler() {
        }

        @Nonnull
        public List<Rect2i> getGuiExtraAreas(@Nonnull CrateScreen containerScreen) {
            return containerScreen.getExtraAreas();
        }
    }
}

