/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.integration.jei;

import java.util.List;
import mezz.jei.api.recipe.category.extensions.IRecipeCategoryExtension;
import net.minecraft.ChatFormatting;
import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.EnchantedBookItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentInstance;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import vazkii.quark.addons.oddities.util.Influence;
import vazkii.quark.content.experimental.module.EnchantmentsBegoneModule;
import vazkii.quark.content.tools.module.ColorRunesModule;
import vazkii.zeta.util.ItemNBTHelper;

public class InfluenceEntry
implements IRecipeCategoryExtension {
    private final ItemStack candleStack;
    private final ItemStack boost;
    private final ItemStack dampen;
    private final List<ItemStack> associatedBooks;

    public InfluenceEntry(Block candle, Influence influence) {
        this.candleStack = new ItemStack((ItemLike)candle);
        this.boost = InfluenceEntry.getEnchantedBook(influence.boost(), DyeColor.GREEN, ChatFormatting.GREEN, "quark.jei.boost_influence");
        this.dampen = InfluenceEntry.getEnchantedBook(influence.dampen(), DyeColor.RED, ChatFormatting.RED, "quark.jei.dampen_influence");
        this.associatedBooks = InfluenceEntry.buildAssociatedBooks(influence);
    }

    public ItemStack getBoostBook() {
        return this.boost;
    }

    public ItemStack getDampenBook() {
        return this.dampen;
    }

    public ItemStack getCandleStack() {
        return this.candleStack;
    }

    public List<ItemStack> getAssociatedBooks() {
        return this.associatedBooks;
    }

    private static ItemStack getEnchantedBook(List<Enchantment> enchantments, DyeColor runeColor, ChatFormatting chatColor, String locKey) {
        ItemStack stack = ItemStack.f_41583_;
        for (Enchantment enchantment : enchantments) {
            if (EnchantmentsBegoneModule.shouldBegone(enchantment)) continue;
            if (stack.m_41619_()) {
                stack = ColorRunesModule.withRune(new ItemStack((ItemLike)Items.f_42690_), runeColor).m_41714_((Component)Component.m_237115_((String)locKey).m_130940_(chatColor));
                ItemNBTHelper.setBoolean(stack, "quark:only_show_table_enchantments", true);
            }
            EnchantedBookItem.m_41153_((ItemStack)stack, (EnchantmentInstance)new EnchantmentInstance(enchantment, enchantment.m_6586_()));
        }
        return stack;
    }

    private static List<ItemStack> buildAssociatedBooks(Influence influence) {
        int i;
        NonNullList books = NonNullList.m_122779_();
        for (Enchantment enchantment : influence.boost()) {
            for (i = 0; i < enchantment.m_6586_(); ++i) {
                books.add((Object)EnchantedBookItem.m_41161_((EnchantmentInstance)new EnchantmentInstance(enchantment, i + 1)));
            }
        }
        for (Enchantment enchantment : influence.dampen()) {
            for (i = 0; i < enchantment.m_6586_(); ++i) {
                books.add((Object)EnchantedBookItem.m_41161_((EnchantmentInstance)new EnchantmentInstance(enchantment, i + 1)));
            }
        }
        return books;
    }

    public boolean hasAny() {
        return !this.boost.m_41619_() || !this.dampen.m_41619_();
    }
}

