/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.content.world.module;

import com.google.common.collect.Lists;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BiomeTags;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.MaterialColor;
import org.apache.commons.lang3.tuple.Pair;
import vazkii.quark.api.IIndirectConnector;
import vazkii.quark.base.block.QuarkInheritedPaneBlock;
import vazkii.quark.base.handler.ToolInteractionHandler;
import vazkii.quark.base.module.LoadModule;
import vazkii.quark.base.module.ModuleLoader;
import vazkii.quark.base.module.config.Config;
import vazkii.quark.base.module.hint.Hint;
import vazkii.quark.base.util.CorundumColor;
import vazkii.quark.content.tools.module.BeaconRedirectionModule;
import vazkii.quark.content.world.block.CorundumBlock;
import vazkii.quark.content.world.block.CorundumClusterBlock;
import vazkii.quark.content.world.undergroundstyle.CorundumStyle;
import vazkii.quark.content.world.undergroundstyle.base.AbstractUndergroundStyleModule;
import vazkii.quark.content.world.undergroundstyle.base.UndergroundStyleConfig;
import vazkii.zeta.event.ZCommonSetup;
import vazkii.zeta.event.ZConfigChanged;
import vazkii.zeta.event.ZGatherHints;
import vazkii.zeta.event.ZRegister;
import vazkii.zeta.event.bus.LoadEvent;
import vazkii.zeta.event.bus.PlayEvent;

@LoadModule(category="world")
public class CorundumModule
extends AbstractUndergroundStyleModule<CorundumStyle> {
    @Config
    @Config.Min(value=0.0)
    @Config.Max(value=1.0)
    public static double crystalChance = 0.16;
    @Config
    @Config.Min(value=0.0)
    @Config.Max(value=1.0)
    public static double crystalClusterChance = 0.2;
    @Config
    @Config.Min(value=0.0)
    @Config.Max(value=1.0)
    public static double crystalClusterOnSidesChance = 0.6;
    @Config
    @Config.Min(value=0.0)
    @Config.Max(value=1.0)
    public static double doubleCrystalChance = 0.2;
    @Config(description="The chance that a crystal can grow, this is on average 1 in X world ticks, set to a higher value to make them grow slower. Minimum is 1, for every tick. Set to 0 to disable growth.")
    public static int caveCrystalGrowthChance = 5;
    @Config(flag="cave_corundum_runes")
    public static boolean crystalsCraftRunes = true;
    @Config
    public static boolean enableCollateralMovement = true;
    public static boolean staticEnabled;
    public static List<CorundumBlock> crystals;
    public static List<CorundumClusterBlock> clusters;
    @Hint
    public static TagKey<Block> corundumTag;

    @LoadEvent
    public final void register(ZRegister event) {
        for (CorundumColor color : CorundumColor.values()) {
            this.add(color.name, color.beaconColor, color.materialColor);
        }
    }

    @LoadEvent
    public final void configChanged(ZConfigChanged event) {
        staticEnabled = this.enabled;
    }

    @LoadEvent
    public final void mySetup(ZCommonSetup event) {
        corundumTag = BlockTags.create((ResourceLocation)new ResourceLocation("quark", "corundum"));
    }

    @PlayEvent
    public void addAdditionalHints(ZGatherHints consumer) {
        MutableComponent comp = Component.m_237115_((String)"quark.jei.hint.corundum_cluster_grow");
        if (ModuleLoader.INSTANCE.isModuleEnabled(BeaconRedirectionModule.class)) {
            comp = comp.m_130946_(" ").m_7220_((Component)Component.m_237115_((String)"quark.jei.hint.corundum_cluster_redirect"));
        }
        for (Block block : clusters) {
            consumer.accept(block.m_5456_(), comp);
        }
    }

    private void add(String name, int color, MaterialColor material) {
        CorundumBlock crystal = new CorundumBlock(name + "_corundum", color, this, material, false);
        crystals.add(crystal);
        CorundumBlock waxed = new CorundumBlock("waxed_" + name + "_corundum", color, this, material, true);
        ToolInteractionHandler.registerWaxedBlock(this, crystal, waxed);
        new QuarkInheritedPaneBlock(crystal);
        CorundumClusterBlock cluster = new CorundumClusterBlock(crystal);
        clusters.add(cluster);
        ClusterConnection connection = new ClusterConnection(cluster);
        IIndirectConnector.INDIRECT_STICKY_BLOCKS.add((Pair<Predicate<BlockState>, IIndirectConnector>)Pair.of(connection::isValidState, (Object)connection));
    }

    @Override
    protected String getStyleName() {
        return "corundum";
    }

    @Override
    protected UndergroundStyleConfig<CorundumStyle> getStyleConfig() {
        return new UndergroundStyleConfig<CorundumStyle>(new CorundumStyle(), 400, true, BiomeTags.f_207603_).setDefaultSize(72, 20, 22, 4);
    }

    static {
        crystals = Lists.newArrayList();
        clusters = Lists.newArrayList();
    }

    public record ClusterConnection(CorundumClusterBlock cluster) implements IIndirectConnector
    {
        @Override
        public boolean isEnabled() {
            return enableCollateralMovement;
        }

        private boolean isValidState(BlockState state) {
            return state.m_60734_() == this.cluster;
        }

        @Override
        public boolean canConnectIndirectly(Level world, BlockPos ourPos, BlockPos sourcePos, BlockState ourState, BlockState sourceState) {
            BlockPos offsetPos = ourPos.m_121945_(((Direction)ourState.m_61143_(CorundumClusterBlock.FACING)).m_122424_());
            if (!offsetPos.equals((Object)sourcePos)) {
                return false;
            }
            return sourceState.m_60734_() == this.cluster.base;
        }
    }
}

