/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.content.world.module;

import com.google.common.base.Functions;
import com.google.common.collect.ImmutableSet;
import java.util.Set;
import java.util.function.Function;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.ComposterBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.material.MaterialColor;
import net.minecraft.world.level.storage.loot.BuiltInLootTables;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import vazkii.quark.base.Quark;
import vazkii.quark.base.block.QuarkLeavesBlock;
import vazkii.quark.base.handler.VariantHandler;
import vazkii.quark.base.handler.WoodSetHandler;
import vazkii.quark.base.handler.advancement.QuarkAdvancementHandler;
import vazkii.quark.base.handler.advancement.QuarkGenericTrigger;
import vazkii.quark.base.handler.advancement.mod.BalancedDietModifier;
import vazkii.quark.base.module.config.Config;
import vazkii.quark.base.module.hint.Hint;
import vazkii.quark.content.world.block.AncientSaplingBlock;
import vazkii.quark.content.world.item.AncientFruitItem;
import vazkii.zeta.event.ZCommonSetup;
import vazkii.zeta.event.ZLootTableLoad;
import vazkii.zeta.event.ZRegister;
import vazkii.zeta.event.bus.LoadEvent;
import vazkii.zeta.event.bus.PlayEvent;
import vazkii.zeta.module.ZetaLoadModule;
import vazkii.zeta.module.ZetaModule;

@ZetaLoadModule(category="world")
public class AncientWoodModule
extends ZetaModule {
    @Config(flag="ancient_fruit_xp")
    public static boolean ancientFruitGivesExp = true;
    @Config
    @Config.Min(value=1.0)
    public static int ancientFruitExpValue = 10;
    @Config(description="Set to 0 to disable loot chest generation")
    @Config.Min(value=0.0)
    public static int ancientCityLootWeight = 8;
    @Config
    @Config.Min(value=0.0)
    public static int ancientCityLootQuality = 1;
    public static WoodSetHandler.WoodSet woodSet;
    public static Block ancient_leaves;
    @Hint
    public static Block ancient_sapling;
    @Hint
    public static Item ancient_fruit;
    public static QuarkGenericTrigger ancientFruitTrigger;

    @LoadEvent
    public void setup(ZCommonSetup e) {
        e.enqueueWork(() -> {
            ComposterBlock.f_51914_.put((Object)ancient_sapling.m_5456_(), 0.3f);
            ComposterBlock.f_51914_.put((Object)ancient_leaves.m_5456_(), 0.3f);
            ComposterBlock.f_51914_.put((Object)ancient_fruit.m_5456_(), 0.65f);
        });
    }

    @LoadEvent
    public void register(ZRegister event) {
        woodSet = WoodSetHandler.addWoodSet(this, "ancient", MaterialColor.f_76372_, MaterialColor.f_76372_, true);
        ancient_leaves = new QuarkLeavesBlock(AncientWoodModule.woodSet.name, this, MaterialColor.f_76405_);
        ancient_sapling = new AncientSaplingBlock(this);
        ancient_fruit = new AncientFruitItem(this);
        VariantHandler.addFlowerPot(ancient_sapling, Quark.ZETA.registry.getInternalName(ancient_sapling).m_135815_(), (Function<BlockBehaviour.Properties, BlockBehaviour.Properties>)Functions.identity());
        QuarkAdvancementHandler.addModifier(new BalancedDietModifier(this, (Set<ItemLike>)ImmutableSet.of((Object)ancient_fruit)));
        ancientFruitTrigger = QuarkAdvancementHandler.registerGenericTrigger("ancient_fruit_overlevel");
    }

    @PlayEvent
    public void onLootTableLoad(ZLootTableLoad event) {
        int weight = 0;
        if (event.getName().equals((Object)BuiltInLootTables.f_230876_)) {
            weight = ancientCityLootWeight;
        }
        if (weight > 0) {
            LootPoolEntryContainer entry = LootItem.m_79579_((ItemLike)ancient_sapling).m_79707_(weight).m_79711_(ancientCityLootQuality).m_7512_();
            event.add(entry);
        }
    }
}

