/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.content.world.block;

import com.google.common.collect.ImmutableList;
import java.awt.Color;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.color.block.BlockColor;
import net.minecraft.client.color.item.ItemColor;
import net.minecraft.core.BlockPos;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.levelgen.LegacyRandomSource;
import net.minecraft.world.level.levelgen.synth.PerlinSimplexNoise;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import vazkii.zeta.registry.IZetaBlockColorProvider;

public interface IMyaliteColorProvider
extends IZetaBlockColorProvider {
    public static final PerlinSimplexNoise NOISE = new PerlinSimplexNoise((RandomSource)new LegacyRandomSource(4543543L), (List)ImmutableList.of((Object)-4, (Object)-3, (Object)-2, (Object)-1, (Object)0, (Object)1, (Object)2, (Object)3, (Object)4));

    @Override
    @OnlyIn(value=Dist.CLIENT)
    default public BlockColor getBlockColor() {
        return (state, world, pos, tintIndex) -> IMyaliteColorProvider.getColor(pos, this.myaliteS(), this.myaliteB());
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    default public ItemColor getItemColor() {
        return (stack, tintIndex) -> {
            Minecraft mc = Minecraft.m_91087_();
            if (mc.f_91074_ == null) {
                return IMyaliteColorProvider.getColor(BlockPos.f_121853_, this.myaliteS(), this.myaliteB());
            }
            BlockPos pos = mc.f_91074_.m_20183_();
            HitResult res = mc.f_91077_;
            if (res != null && res.m_6662_() == HitResult.Type.BLOCK) {
                pos = ((BlockHitResult)res).m_82425_();
            }
            return IMyaliteColorProvider.getColor(pos, this.myaliteS(), this.myaliteB());
        };
    }

    default public float myaliteS() {
        return 0.7f;
    }

    default public float myaliteB() {
        return 0.8f;
    }

    public static int getColor(BlockPos pos, float s, float b) {
        float sp = 0.15f;
        double range = 0.3;
        double shift = 0.05;
        if (pos == null) {
            pos = BlockPos.f_121853_;
        }
        float x = (float)pos.m_123341_() * 0.15f;
        float y = (float)pos.m_123342_() * 0.15f;
        float z = (float)pos.m_123343_() * 0.15f;
        double xv = x + Mth.m_14031_((float)z) * 2.0f;
        double zv = z + Mth.m_14089_((float)x) * 2.0f;
        double yv = y + Mth.m_14031_((float)(y + 0.7853982f)) * 2.0f;
        double noise = NOISE.m_75449_(xv + yv, zv + yv * 2.0, false);
        double h = noise * 0.15 - 0.3 + 0.05;
        return Color.HSBtoRGB((float)h, s, b);
    }
}

