/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.content.world.block;

import com.mojang.math.Vector3f;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.level.material.MaterialColor;
import vazkii.quark.base.block.QuarkGlassBlock;
import vazkii.quark.base.module.ModuleLoader;
import vazkii.quark.content.world.block.CorundumClusterBlock;
import vazkii.quark.content.world.module.CorundumModule;
import vazkii.quark.content.world.module.SpiralSpiresModule;
import vazkii.zeta.module.ZetaModule;

public class CorundumBlock
extends QuarkGlassBlock {
    public final float[] colorComponents;
    public final boolean waxed;
    public CorundumClusterBlock cluster;

    public CorundumBlock(String regname, int color, ZetaModule module, MaterialColor materialColor, boolean waxed) {
        super(regname, module, CreativeModeTab.f_40750_, true, BlockBehaviour.Properties.m_60944_((Material)Material.f_76275_, (MaterialColor)materialColor).m_60913_(0.3f, 0.0f).m_60918_(SoundType.f_154654_).m_60953_(b -> 11).m_60999_().m_60977_().m_60955_());
        float r = (float)(color >> 16 & 0xFF) / 255.0f;
        float g = (float)(color >> 8 & 0xFF) / 255.0f;
        float b2 = (float)(color & 0xFF) / 255.0f;
        this.colorComponents = new float[]{r, g, b2};
        this.waxed = waxed;
    }

    private boolean canGrow(Level world, BlockPos pos) {
        if (!this.waxed && CorundumModule.caveCrystalGrowthChance >= 1 && pos.m_123342_() < 24 && world.m_46859_(pos.m_7494_())) {
            int i = 1;
            while (world.m_8055_(pos.m_6625_(i)).m_60734_() == this) {
                ++i;
            }
            return i < 4;
        }
        return false;
    }

    public void m_213897_(@Nonnull BlockState state, @Nonnull ServerLevel worldIn, @Nonnull BlockPos pos, @Nonnull RandomSource random) {
        if (this.canGrow((Level)worldIn, pos) && random.m_188503_(CorundumModule.caveCrystalGrowthChance) == 0) {
            BlockState down = worldIn.m_8055_(pos.m_7495_());
            BlockPos up = pos.m_7494_();
            worldIn.m_46597_(up, state);
            if (down.m_60734_() == SpiralSpiresModule.myalite_crystal && ModuleLoader.INSTANCE.isModuleEnabled(SpiralSpiresModule.class) && SpiralSpiresModule.renewableMyalite) {
                worldIn.m_46597_(pos, SpiralSpiresModule.myalite_crystal.m_49966_());
            } else {
                for (Direction d : Direction.values()) {
                    BlockPos offPos = up.m_121945_(d);
                    if (!worldIn.m_46859_(offPos) || random.m_188503_(3) != 0) continue;
                    worldIn.m_46597_(offPos, (BlockState)this.cluster.m_49966_().m_61124_(CorundumClusterBlock.FACING, (Comparable)d));
                }
            }
        }
    }

    public void m_214162_(@Nonnull BlockState stateIn, @Nonnull Level worldIn, @Nonnull BlockPos pos, @Nonnull RandomSource rand) {
        if (this.canGrow(worldIn, pos)) {
            double x = (double)pos.m_123341_() + rand.m_188500_();
            double y = (double)pos.m_123342_() + rand.m_188500_();
            double z = (double)pos.m_123343_() + rand.m_188500_();
            worldIn.m_7106_((ParticleOptions)ParticleTypes.f_123770_, x, y, z, (double)this.colorComponents[0], (double)this.colorComponents[1], (double)this.colorComponents[2]);
        }
        if (!this.waxed) {
            for (int i = 0; i < 4; ++i) {
                double range = 5.0;
                double ox = rand.m_188500_() * range - range / 2.0;
                double oy = rand.m_188500_() * range - range / 2.0;
                double oz = rand.m_188500_() * range - range / 2.0;
                double x = (double)pos.m_123341_() + 0.5 + ox;
                double y = (double)pos.m_123342_() + 0.5 + oy;
                double z = (double)pos.m_123343_() + 0.5 + oz;
                float size = 0.4f + rand.m_188501_() * 0.5f;
                if (rand.m_188500_() < 0.1) {
                    double ol = (ox * ox + oy * oy + oz * oz) * -2.0;
                    if (ol == 0.0) {
                        ol = 1.0E-4;
                    }
                    worldIn.m_7106_((ParticleOptions)ParticleTypes.f_123810_, x, y, z, ox / ol, oy / ol, oz / ol);
                }
                worldIn.m_7106_((ParticleOptions)new DustParticleOptions(new Vector3f(this.colorComponents[0], this.colorComponents[1], this.colorComponents[2]), size), x, y, z, 0.0, 0.0, 0.0);
            }
        }
    }

    @Nullable
    public float[] getBeaconColorMultiplier(BlockState state, LevelReader world, BlockPos pos, BlockPos beaconPos) {
        return this.colorComponents;
    }
}

