/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.content.tweaks.module;

import com.google.common.collect.Lists;
import it.unimi.dsi.fastutil.objects.Object2IntArrayMap;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TieredItem;
import net.minecraft.world.item.Tiers;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraftforge.registries.ForgeRegistries;
import vazkii.quark.base.module.LoadModule;
import vazkii.quark.base.module.config.Config;
import vazkii.quark.base.module.hint.Hint;
import vazkii.zeta.event.ZConfigChanged;
import vazkii.zeta.event.bus.LoadEvent;
import vazkii.zeta.module.ZetaModule;

@LoadModule(category="tweaks", hasSubscriptions=true)
public class GoldToolsHaveFortuneModule
extends ZetaModule {
    private static final Tier[] TIERS = new Tier[]{Tiers.WOOD, Tiers.STONE, Tiers.IRON, Tiers.DIAMOND, Tiers.NETHERITE};
    @Config
    @Config.Min(value=0.0)
    public static int fortuneLevel = 2;
    @Config
    @Config.Min(value=0.0)
    @Config.Max(value=4.0)
    public static int harvestLevel = 2;
    @Config
    public static boolean displayBakedEnchantmentsInTooltip = true;
    @Config
    public static boolean italicTooltip = true;
    @Config(description="Enchantments other than Gold's Fortune/Looting to bake into items. Format is \"item+enchant@level\", such as \"minecraft:stick+sharpness@10\".")
    public static List<String> bakedEnchantments = Lists.newArrayList();
    private static final Map<Item, Object2IntMap<Enchantment>> wellBakedEnchantments = new HashMap<Item, Object2IntMap<Enchantment>>();
    @Hint(key="gold_tool_fortune", content={"fortuneLevel"})
    List<Item> gold_tools = Arrays.asList(Items.f_42433_, Items.f_42434_, Items.f_42432_, Items.f_42431_, Items.f_42430_);
    @Hint(key="gold_tool_harvest_level", content={"harvestLevel"})
    List<Item> gold_tools_2 = this.gold_tools;
    private static boolean staticEnabled;

    @LoadEvent
    public final void configChanged(ZConfigChanged event) {
        staticEnabled = this.enabled;
        wellBakedEnchantments.clear();
        for (String enchantment : bakedEnchantments) {
            Enchantment enchant;
            ResourceLocation enchantLoc;
            String[] split2;
            Item item;
            ResourceLocation itemLoc;
            String[] split1 = enchantment.split("\\+");
            if (split1.length != 2 || (itemLoc = ResourceLocation.m_135820_((String)split1[0])) == null || (item = (Item)ForgeRegistries.ITEMS.getValue(itemLoc)) == null || (split2 = split1[1].split("@")).length == 0 || split2.length > 2 || (enchantLoc = ResourceLocation.m_135820_((String)split2[0])) == null || (enchant = (Enchantment)ForgeRegistries.ENCHANTMENTS.getValue(enchantLoc)) == null) continue;
            try {
                int strength = split2.length == 1 ? 1 : Integer.parseInt(split2[1]);
                Object2IntMap pastry = wellBakedEnchantments.computeIfAbsent(item, it -> new Object2IntArrayMap());
                pastry.put((Object)enchant, Math.max(strength, pastry.getOrDefault((Object)enchant, 0)));
            }
            catch (NumberFormatException numberFormatException) {}
        }
        if (fortuneLevel > 0) {
            for (Item item : ForgeRegistries.ITEMS) {
                TieredItem tiered;
                if (!(item instanceof TieredItem) || (tiered = (TieredItem)item).m_43314_() != Tiers.GOLD) continue;
                Enchantment enchant = item instanceof SwordItem ? Enchantments.f_44982_ : Enchantments.f_44987_;
                Object2IntMap pastry = wellBakedEnchantments.computeIfAbsent(item, it -> new Object2IntArrayMap());
                pastry.put((Object)enchant, Math.max(fortuneLevel, pastry.getOrDefault((Object)enchant, 0)));
            }
        }
    }

    public static int getActualEnchantmentLevel(Enchantment enchant, ItemStack stack, int prev) {
        int forcedLevel;
        Object2IntMap<Enchantment> pastry;
        Item item = stack.m_41720_();
        if (staticEnabled && wellBakedEnchantments.containsKey(item) && (pastry = wellBakedEnchantments.get(item)).containsKey((Object)enchant) && (forcedLevel = pastry.getOrDefault((Object)enchant, 0)) > prev) {
            return forcedLevel;
        }
        return prev;
    }

    public static void addEnchantmentsIfMissing(ItemStack stack, Map<Enchantment, Integer> map) {
        Item item = stack.m_41720_();
        if (staticEnabled && wellBakedEnchantments.containsKey(item) && displayBakedEnchantmentsInTooltip) {
            Object2IntMap<Enchantment> pastry = wellBakedEnchantments.get(item);
            for (Enchantment enchantment : pastry.keySet()) {
                int effectiveLevel;
                int level = map.getOrDefault(enchantment, 0);
                if (level >= (effectiveLevel = GoldToolsHaveFortuneModule.getActualEnchantmentLevel(enchantment, stack, level))) continue;
                map.put(enchantment, effectiveLevel);
            }
        }
    }

    public static Tier getEffectiveTier(Item item, Tier realTier) {
        if (!staticEnabled || realTier != Tiers.GOLD) {
            return realTier;
        }
        return TIERS[harvestLevel];
    }

    public static boolean shouldShowEnchantments(ItemStack stack) {
        return wellBakedEnchantments.containsKey(stack.m_41720_());
    }

    public static void fakeEnchantmentTooltip(ItemStack stack, List<Component> components) {
        for (Map.Entry entry : stack.getAllEnchantments().entrySet()) {
            int actualLevel = EnchantmentHelper.getTagEnchantmentLevel((Enchantment)((Enchantment)entry.getKey()), (ItemStack)stack);
            if (actualLevel == (Integer)entry.getValue()) continue;
            Component comp = ((Enchantment)entry.getKey()).m_44700_(((Integer)entry.getValue()).intValue());
            if (italicTooltip) {
                comp = comp.m_6881_().m_130940_(ChatFormatting.ITALIC);
            }
            if (actualLevel != 0) {
                comp = Component.m_237110_((String)"quark.misc.enchantment_with_actual_level", (Object[])new Object[]{comp, Component.m_237115_((String)("enchantment.level." + actualLevel))}).m_130940_(ChatFormatting.GRAY);
            }
            components.add(comp);
        }
    }

    public static ListTag hideSmallerEnchantments(ItemStack stack, ListTag tag) {
        if (staticEnabled && displayBakedEnchantmentsInTooltip) {
            ArrayList toRemove = Lists.newArrayList();
            for (Map.Entry entry : stack.getAllEnchantments().entrySet()) {
                int actualLevel = EnchantmentHelper.getTagEnchantmentLevel((Enchantment)((Enchantment)entry.getKey()), (ItemStack)stack);
                if (actualLevel == (Integer)entry.getValue() || actualLevel == 0) continue;
                toRemove.add(EnchantmentHelper.m_182432_((Enchantment)((Enchantment)entry.getKey())));
            }
            if (!toRemove.isEmpty()) {
                tag = tag.m_6426_();
                tag.removeIf(it -> {
                    CompoundTag compound;
                    ResourceLocation loc;
                    if (it instanceof CompoundTag && (loc = EnchantmentHelper.m_182446_((CompoundTag)(compound = (CompoundTag)it))) != null) {
                        return toRemove.contains(loc);
                    }
                    return false;
                });
            }
        }
        return tag;
    }
}

