/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.content.tweaks.module;

import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.Input;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.data.BuiltinRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LadderBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.MovementInputUpdateEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import vazkii.quark.base.handler.MiscUtil;
import vazkii.quark.base.module.LoadModule;
import vazkii.quark.base.module.config.Config;
import vazkii.zeta.event.ZCommonSetup;
import vazkii.zeta.event.ZConfigChanged;
import vazkii.zeta.event.ZGatherHints;
import vazkii.zeta.event.bus.LoadEvent;
import vazkii.zeta.event.bus.PlayEvent;
import vazkii.zeta.module.ZetaModule;

@LoadModule(category="tweaks", hasSubscriptions=true)
public class EnhancedLaddersModule
extends ZetaModule {
    @Config.Max(value=0.0)
    @Config
    public double fallSpeed = -0.2;
    @Config
    public static boolean allowFreestanding = true;
    @Config
    public static boolean allowDroppingDown = true;
    @Config
    public static boolean allowSliding = true;
    @Config
    public static boolean allowInventorySneak = true;
    private static boolean staticEnabled;
    private static TagKey<Item> laddersTag;

    @LoadEvent
    public final void setup(ZCommonSetup event) {
        laddersTag = ItemTags.create((ResourceLocation)new ResourceLocation("quark", "ladders"));
    }

    @LoadEvent
    public final void configChanged(ZConfigChanged event) {
        staticEnabled = this.enabled;
    }

    @PlayEvent
    public void addAdditionalHints(ZGatherHints consumer) {
        if (!(allowFreestanding || allowDroppingDown || allowSliding || allowInventorySneak)) {
            return;
        }
        MutableComponent comp = Component.m_237119_();
        String pad = "";
        if (allowDroppingDown) {
            comp = comp.m_130946_(pad).m_7220_((Component)Component.m_237115_((String)"quark.jei.hint.ladder_dropping"));
            pad = " ";
        }
        if (allowFreestanding) {
            comp = comp.m_130946_(pad).m_7220_((Component)Component.m_237115_((String)"quark.jei.hint.ladder_freestanding"));
            pad = " ";
        }
        if (allowSliding) {
            comp = comp.m_130946_(pad).m_7220_((Component)Component.m_237115_((String)"quark.jei.hint.ladder_sliding"));
            pad = " ";
        }
        if (allowInventorySneak) {
            comp = comp.m_130946_(pad).m_7220_((Component)Component.m_237115_((String)"quark.jei.hint.ladder_sneak"));
        }
        List<Item> ladders = MiscUtil.getTagValues(BuiltinRegistries.f_206379_, laddersTag);
        for (Item item : ladders) {
            consumer.accept(item, comp);
        }
    }

    private static boolean canAttachTo(BlockState state, Block ladder, LevelReader world, BlockPos pos, Direction facing) {
        if (ladder instanceof LadderBlock) {
            if (allowFreestanding) {
                return EnhancedLaddersModule.canLadderSurvive(state, world, pos);
            }
            BlockPos offset = pos.m_121945_(facing);
            BlockState blockstate = world.m_8055_(offset);
            return !blockstate.m_60803_() && blockstate.m_60783_((BlockGetter)world, offset, facing);
        }
        return false;
    }

    public static boolean canLadderSurvive(BlockState state, LevelReader world, BlockPos pos) {
        if (!staticEnabled || !allowFreestanding) {
            return false;
        }
        Direction facing = (Direction)state.m_61143_((Property)LadderBlock.f_54337_);
        Direction opposite = facing.m_122424_();
        BlockPos oppositePos = pos.m_121945_(opposite);
        BlockState oppositeState = world.m_8055_(oppositePos);
        boolean solid = facing.m_122434_() != Direction.Axis.Y && oppositeState.m_60783_((BlockGetter)world, oppositePos, facing) && !(oppositeState.m_60734_() instanceof LadderBlock);
        BlockState topState = world.m_8055_(pos.m_7494_());
        return solid || topState.m_60734_() instanceof LadderBlock && (facing.m_122434_() == Direction.Axis.Y || topState.m_61143_((Property)LadderBlock.f_54337_) == facing);
    }

    public static boolean updateLadder(BlockState state, Direction facing, BlockState facingState, LevelAccessor world, BlockPos currentPos, BlockPos facingPos) {
        if (!staticEnabled || !allowFreestanding) {
            return true;
        }
        return EnhancedLaddersModule.canLadderSurvive(state, (LevelReader)world, currentPos);
    }

    @SubscribeEvent
    public void onInteract(PlayerInteractEvent.RightClickBlock event) {
        InteractionHand hand;
        if (!allowDroppingDown) {
            return;
        }
        Player player = event.getEntity();
        ItemStack stack = player.m_21120_(hand = event.getHand());
        if (!stack.m_41619_() && stack.m_204117_(laddersTag)) {
            Block block = Block.m_49814_((Item)stack.m_41720_());
            Level world = event.getLevel();
            BlockPos pos = event.getPos();
            while (world.m_8055_(pos).m_60734_() == block) {
                Direction facing;
                BlockState copyState;
                boolean water;
                event.setCanceled(true);
                BlockPos posDown = pos.m_7495_();
                if (world.m_151570_(posDown)) break;
                BlockState stateDown = world.m_8055_(posDown);
                if (stateDown.m_60734_() == block) {
                    pos = posDown;
                    continue;
                }
                boolean bl = water = stateDown.m_60734_() == Blocks.f_49990_;
                if (!water && !stateDown.m_60795_() || !EnhancedLaddersModule.canAttachTo(copyState = world.m_8055_(pos), block, (LevelReader)world, posDown, (facing = (Direction)copyState.m_61143_((Property)LadderBlock.f_54337_)).m_122424_())) break;
                world.m_46597_(posDown, (BlockState)copyState.m_61124_((Property)BlockStateProperties.f_61362_, (Comparable)Boolean.valueOf(water)));
                world.m_6263_(null, (double)posDown.m_123341_(), (double)posDown.m_123342_(), (double)posDown.m_123343_(), SoundEvents.f_12023_, SoundSource.BLOCKS, 1.0f, 1.0f);
                if (!player.m_150110_().f_35937_) {
                    stack.m_41774_(1);
                    if (stack.m_41613_() <= 0) {
                        player.m_21008_(hand, ItemStack.f_41583_);
                    }
                }
                event.setCancellationResult(InteractionResult.m_19078_((boolean)world.f_46443_));
                break;
            }
        }
    }

    @SubscribeEvent
    public void onPlayerTick(TickEvent.PlayerTickEvent event) {
        Player player;
        if (!allowSliding) {
            return;
        }
        if (event.phase == TickEvent.Phase.START && (player = event.player).m_6147_() && player.f_19853_.f_46443_) {
            BlockPos playerPos = player.m_20183_();
            BlockPos downPos = playerPos.m_7495_();
            boolean scaffold = player.f_19853_.m_8055_(playerPos).isScaffolding((LivingEntity)player);
            if (player.m_6047_() == scaffold && player.f_20902_ == 0.0f && player.f_20901_ <= 0.0f && player.f_20900_ == 0.0f && player.m_146909_() > 70.0f && !player.f_20899_ && !player.m_150110_().f_35935_ && player.f_19853_.m_8055_(downPos).isLadder((LevelReader)player.f_19853_, downPos, (LivingEntity)player)) {
                Vec3 move = new Vec3(0.0, this.fallSpeed, 0.0);
                AABB target = player.m_20191_().m_82383_(move);
                Iterable collisions = player.f_19853_.m_186434_((Entity)player, target);
                if (!collisions.iterator().hasNext()) {
                    player.m_20011_(target);
                    player.m_6478_(MoverType.SELF, move);
                }
            }
        }
    }

    @SubscribeEvent
    @OnlyIn(value=Dist.CLIENT)
    public void onInput(MovementInputUpdateEvent event) {
        Input input;
        if (!allowInventorySneak) {
            return;
        }
        Player player = event.getEntity();
        if (!(!player.m_6147_() || player.m_150110_().f_35935_ || player.f_19853_.m_8055_(player.m_20183_()).isScaffolding((LivingEntity)player) || Minecraft.m_91087_().f_91080_ == null || player.f_20902_ == 0.0f && player.m_146909_() > 70.0f || player.m_20096_() || (input = event.getInput()) == null)) {
            input.f_108573_ = true;
        }
    }
}

