/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.content.tweaks.module;

import net.minecraft.client.renderer.item.ItemProperties;
import net.minecraft.client.renderer.item.ItemPropertyFunction;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import vazkii.quark.base.module.LoadModule;
import vazkii.quark.base.module.config.Config;
import vazkii.quark.base.module.hint.Hint;
import vazkii.quark.content.tweaks.client.item.ClockTimeGetter;
import vazkii.quark.content.tweaks.client.item.CompassAngleGetter;
import vazkii.zeta.client.event.ZClientSetup;
import vazkii.zeta.event.ZGatherHints;
import vazkii.zeta.event.bus.LoadEvent;
import vazkii.zeta.event.bus.PlayEvent;
import vazkii.zeta.module.ZetaModule;

@LoadModule(category="tweaks", hasSubscriptions=true)
public class CompassesWorkEverywhereModule
extends ZetaModule {
    @Config
    public static boolean enableCompassNerf = true;
    @Config(flag="clock_nerf")
    public static boolean enableClockNerf = true;
    @Config
    public static boolean enableNether = true;
    @Config
    public static boolean enableEnd = true;
    @Hint(value="clock_nerf")
    Item clock = Items.f_42524_;

    @LoadEvent
    @OnlyIn(value=Dist.CLIENT)
    public void clientSetup(ZClientSetup e) {
        if (this.enabled && (enableCompassNerf || enableNether || enableEnd)) {
            e.enqueueWork(() -> ItemProperties.register((Item)Items.f_42522_, (ResourceLocation)new ResourceLocation("angle"), (ItemPropertyFunction)new CompassAngleGetter.Impl()));
        }
        if (this.enabled && enableClockNerf) {
            e.enqueueWork(() -> ItemProperties.register((Item)Items.f_42524_, (ResourceLocation)new ResourceLocation("time"), (ItemPropertyFunction)new ClockTimeGetter.Impl()));
        }
    }

    @PlayEvent
    public void addAdditionalHints(ZGatherHints consumer) {
        if (!(enableNether || enableEnd || enableCompassNerf)) {
            return;
        }
        MutableComponent comp = Component.m_237113_((String)"");
        String pad = "";
        if (enableNether) {
            comp = comp.m_130946_(pad).m_7220_((Component)Component.m_237115_((String)"quark.jei.hint.compass_nether"));
            pad = " ";
        }
        if (enableEnd) {
            comp = comp.m_130946_(pad).m_7220_((Component)Component.m_237115_((String)"quark.jei.hint.compass_end"));
            pad = " ";
        }
        if (enableCompassNerf) {
            comp = comp.m_130946_(pad).m_7220_((Component)Component.m_237115_((String)"quark.jei.hint.compass_nerf"));
        }
        consumer.accept(Items.f_42522_, comp);
    }

    @SubscribeEvent
    public void onUpdate(TickEvent.PlayerTickEvent event) {
        if (event.phase == TickEvent.Phase.START) {
            Inventory inventory = event.player.m_150109_();
            for (int i = 0; i < inventory.m_6643_(); ++i) {
                ItemStack stack = inventory.m_8020_(i);
                if (stack.m_41720_() == Items.f_42522_) {
                    CompassAngleGetter.tickCompass(event.player, stack);
                    continue;
                }
                if (stack.m_41720_() != Items.f_42524_) continue;
                ClockTimeGetter.tickClock(stack);
            }
        }
    }
}

