/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.content.tweaks.client.item;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.item.ItemPropertyFunction;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import vazkii.zeta.util.ItemNBTHelper;

public class ClockTimeGetter {
    private static final String TAG_CALCULATED = "quark:clock_calculated";

    public static void tickClock(ItemStack stack) {
        boolean calculated = ClockTimeGetter.isCalculated(stack);
        if (!calculated) {
            ItemNBTHelper.setBoolean(stack, TAG_CALCULATED, true);
        }
    }

    static boolean isCalculated(ItemStack stack) {
        return stack.m_41782_() && ItemNBTHelper.getBoolean(stack, TAG_CALCULATED, false);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class Impl
    implements ItemPropertyFunction {
        private double rotation;
        private double rota;
        private long lastUpdateTick;

        @OnlyIn(value=Dist.CLIENT)
        public float m_141951_(@Nonnull ItemStack stack, @Nullable ClientLevel worldIn, @Nullable LivingEntity entityIn, int id) {
            LivingEntity entity;
            if (!ClockTimeGetter.isCalculated(stack)) {
                return 0.0f;
            }
            boolean carried = entityIn != null;
            Object object = entity = carried ? entityIn : stack.m_41795_();
            if (worldIn == null && entity != null && entity.f_19853_ instanceof ClientLevel) {
                worldIn = (ClientLevel)entity.f_19853_;
            }
            if (worldIn == null) {
                return 0.0f;
            }
            double angle = worldIn.m_6042_().f_63858_() ? (double)worldIn.m_46942_(1.0f) : Math.random();
            angle = this.wobble((Level)worldIn, angle);
            return (float)angle;
        }

        private double wobble(Level world, double time) {
            long gameTime = world.m_46467_();
            if (gameTime != this.lastUpdateTick) {
                this.lastUpdateTick = gameTime;
                double d0 = time - this.rotation;
                d0 = Mth.m_14109_((double)(d0 + 0.5), (double)1.0) - 0.5;
                this.rota += d0 * 0.1;
                this.rota *= 0.9;
                this.rotation = Mth.m_14109_((double)(this.rotation + this.rota), (double)1.0);
            }
            return this.rotation;
        }
    }
}

