/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.content.tools.module;

import net.minecraft.client.renderer.entity.EntityRenderers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.PatrollingMonster;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import net.minecraftforge.event.level.BlockEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import vazkii.quark.base.Quark;
import vazkii.quark.base.handler.MiscUtil;
import vazkii.quark.base.module.LoadModule;
import vazkii.quark.base.module.config.Config;
import vazkii.quark.base.module.hint.Hint;
import vazkii.quark.content.tools.ai.RunAwayFromPikesGoal;
import vazkii.quark.content.tools.client.render.entity.SkullPikeRenderer;
import vazkii.quark.content.tools.entity.SkullPike;
import vazkii.zeta.client.event.ZClientSetup;
import vazkii.zeta.event.ZCommonSetup;
import vazkii.zeta.event.ZRegister;
import vazkii.zeta.event.bus.LoadEvent;
import vazkii.zeta.module.ZetaModule;

@LoadModule(category="tools", hasSubscriptions=true)
public class SkullPikesModule
extends ZetaModule {
    public static EntityType<SkullPike> skullPikeType;
    @Hint(key="skull_pikes")
    public static TagKey<Block> pikeTrophiesTag;
    @Config
    public static double pikeRange;

    @LoadEvent
    public final void register(ZRegister event) {
        skullPikeType = EntityType.Builder.m_20704_(SkullPike::new, (MobCategory)MobCategory.MISC).m_20699_(0.5f, 0.5f).m_20702_(3).m_20717_(Integer.MAX_VALUE).setShouldReceiveVelocityUpdates(false).setCustomClientFactory((spawnEntity, world) -> new SkullPike(skullPikeType, (Level)world)).m_20712_("skull_pike");
        Quark.ZETA.registry.register(skullPikeType, "skull_pike", Registry.f_122903_);
    }

    @LoadEvent
    public final void setup(ZCommonSetup event) {
        pikeTrophiesTag = BlockTags.create((ResourceLocation)new ResourceLocation("quark", "pike_trophies"));
    }

    @LoadEvent
    public final void clientSetup(ZClientSetup event) {
        EntityRenderers.m_174036_(skullPikeType, SkullPikeRenderer::new);
    }

    @SubscribeEvent
    public void onPlaceBlock(BlockEvent.EntityPlaceEvent event) {
        BlockPos pos;
        BlockPos down;
        Level world;
        BlockState downState;
        LevelAccessor iworld;
        BlockState state = event.getPlacedBlock();
        if (state.m_204336_(pikeTrophiesTag) && (iworld = event.getLevel()) instanceof Level && (downState = (world = (Level)iworld).m_8055_(down = (pos = event.getPos()).m_7495_())).m_204336_(BlockTags.f_13039_)) {
            SkullPike pike = new SkullPike(skullPikeType, world);
            pike.m_6034_((double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5);
            world.m_7967_((Entity)pike);
        }
    }

    @SubscribeEvent
    public void onMonsterAppear(EntityJoinLevelEvent event) {
        Entity e = event.getEntity();
        if (e instanceof Monster) {
            boolean alreadySetUp;
            Monster monster = (Monster)e;
            if (!(e instanceof PatrollingMonster) && e.m_6072_() && e.m_6084_() && !(alreadySetUp = monster.f_21345_.m_148105_().stream().anyMatch(goal -> goal.m_26015_() instanceof RunAwayFromPikesGoal))) {
                MiscUtil.addGoalJustAfterLatestWithPriority(monster.f_21345_, 3, new RunAwayFromPikesGoal((PathfinderMob)monster, (float)pikeRange, 1.0, 1.2));
            }
        }
    }

    static {
        pikeRange = 5.0;
    }
}

