/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.content.tools.module;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.client.sounds.SoundManager;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Registry;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.monster.Skeleton;
import net.minecraft.world.entity.monster.Spider;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.entity.JukeboxBlockEntity;
import vazkii.quark.base.Quark;
import vazkii.quark.base.handler.QuarkSounds;
import vazkii.quark.base.item.QuarkMusicDiscItem;
import vazkii.quark.base.module.config.Config;
import vazkii.quark.base.module.hint.Hint;
import vazkii.zeta.event.ZLivingDeath;
import vazkii.zeta.event.ZRegister;
import vazkii.zeta.event.bus.LoadEvent;
import vazkii.zeta.event.bus.PlayEvent;
import vazkii.zeta.module.ZetaLoadModule;
import vazkii.zeta.module.ZetaModule;

@ZetaLoadModule(category="tools")
public class AmbientDiscsModule
extends ZetaModule {
    @Config
    public static boolean dropOnSpiderKill = true;
    @Config
    public static double volume = 3.0;
    @Hint(key="ambience_discs")
    private final List<Item> discs = new ArrayList<Item>();

    @LoadEvent
    public void register(ZRegister event) {
        this.disc(QuarkSounds.AMBIENT_DRIPS);
        this.disc(QuarkSounds.AMBIENT_OCEAN);
        this.disc(QuarkSounds.AMBIENT_RAIN);
        this.disc(QuarkSounds.AMBIENT_WIND);
        this.disc(QuarkSounds.AMBIENT_FIRE);
        this.disc(QuarkSounds.AMBIENT_CLOCK);
        this.disc(QuarkSounds.AMBIENT_CRICKETS);
        this.disc(QuarkSounds.AMBIENT_CHATTER);
    }

    private void disc(SoundEvent sound) {
        String name = Quark.ZETA.registry.getRegistryName(sound, Registry.f_122821_).m_135815_().replaceAll(".+\\.", "");
        this.discs.add((Item)new QuarkMusicDiscItem(15, () -> sound, name, this, Integer.MAX_VALUE));
    }

    @PlayEvent
    public void onMobDeath(ZLivingDeath event) {
        if (dropOnSpiderKill && event.getEntity() instanceof Spider && event.getSource().m_7639_() instanceof Skeleton) {
            Item item = this.discs.get(event.getEntity().f_19853_.f_46441_.m_188503_(this.discs.size()));
            event.getEntity().m_20000_((ItemLike)item, 0);
        }
    }

    public static class Client {
        public static void onJukeboxLoad(JukeboxBlockEntity tile) {
            Minecraft mc = Minecraft.m_91087_();
            LevelRenderer render = mc.f_91060_;
            BlockPos pos = tile.m_58899_();
            SoundInstance sound = (SoundInstance)render.f_109410_.get(pos);
            SoundManager soundEngine = mc.m_91106_();
            if (sound == null || !soundEngine.m_120403_(sound)) {
                if (sound != null) {
                    soundEngine.m_120367_(sound);
                } else {
                    ItemStack stack = tile.m_59524_();
                    Item item = stack.m_41720_();
                    if (item instanceof QuarkMusicDiscItem) {
                        QuarkMusicDiscItem disc = (QuarkMusicDiscItem)item;
                        disc.playAmbientSound(pos);
                    }
                }
            }
        }
    }
}

