/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.content.tools.module;

import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Matrix4f;
import java.util.List;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.item.ItemProperties;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import vazkii.quark.base.module.config.Config;
import vazkii.quark.base.module.config.type.inputtable.RGBAColorConfig;
import vazkii.quark.base.module.hint.Hint;
import vazkii.quark.content.tools.item.AbacusItem;
import vazkii.zeta.client.event.ZClientSetup;
import vazkii.zeta.client.event.ZHighlightBlock;
import vazkii.zeta.client.event.ZRenderOverlay;
import vazkii.zeta.event.ZRegister;
import vazkii.zeta.event.bus.LoadEvent;
import vazkii.zeta.event.bus.PlayEvent;
import vazkii.zeta.module.ZetaLoadModule;
import vazkii.zeta.module.ZetaModule;

@ZetaLoadModule(category="tools")
public class AbacusModule
extends ZetaModule {
    @Hint
    public Item abacus;

    @LoadEvent
    public void register(ZRegister event) {
        this.abacus = new AbacusItem(this);
    }

    @ZetaLoadModule(clientReplacement=true)
    public static class Client
    extends AbacusModule {
        @Config
        RGBAColorConfig highlightColor = RGBAColorConfig.forColor(0.0, 0.0, 0.0, 0.4);

        @LoadEvent
        public void clientSetup(ZClientSetup e) {
            e.enqueueWork(() -> ItemProperties.register((Item)this.abacus, (ResourceLocation)new ResourceLocation("count"), AbacusItem.Client::count));
        }

        @PlayEvent
        public void onHUDRender(ZRenderOverlay.Crosshair event) {
            Minecraft mc = Minecraft.m_91087_();
            LocalPlayer player = mc.f_91074_;
            if (player != null) {
                int distance;
                ItemStack stack = player.m_21205_();
                if (!(stack.m_41720_() instanceof AbacusItem)) {
                    stack = player.m_21206_();
                }
                if (stack.m_41720_() instanceof AbacusItem && (distance = AbacusItem.Client.getCount(stack, (LivingEntity)player)) > -1) {
                    Window window = event.getWindow();
                    int x = window.m_85445_() / 2 + 10;
                    int y = window.m_85446_() / 2 - 7;
                    mc.m_91291_().m_115203_(stack, x, y);
                    String distStr = distance < AbacusItem.MAX_COUNT ? Integer.toString(distance + 1) : AbacusItem.MAX_COUNT + "+";
                    mc.f_91062_.m_92750_(event.getPoseStack(), distStr, (float)(x + 17), (float)(y + 5), 0xFFFFFF);
                }
            }
        }

        @PlayEvent
        public void onHighlightBlock(ZHighlightBlock event) {
            VertexConsumer bufferIn = event.getMultiBufferSource().m_6299_(RenderType.m_110504_());
            Minecraft mc = Minecraft.m_91087_();
            LocalPlayer player = mc.f_91074_;
            if (player != null) {
                BlockPos target;
                int distance;
                ItemStack stack = player.m_21205_();
                if (!(stack.m_41720_() instanceof AbacusItem)) {
                    stack = player.m_21206_();
                }
                if (stack.m_41720_() instanceof AbacusItem && (distance = AbacusItem.Client.getCount(stack, (LivingEntity)player)) > -1 && distance <= AbacusItem.MAX_COUNT && (target = AbacusItem.getBlockPos(stack)) != null) {
                    Camera info = event.getCamera();
                    Vec3 view = info.m_90583_();
                    VoxelShape shape = Shapes.m_83064_((AABB)new AABB(target));
                    HitResult result = mc.f_91077_;
                    if (result != null && result.m_6662_() == HitResult.Type.BLOCK) {
                        BlockPos source = ((BlockHitResult)result).m_82425_();
                        int diffX = source.m_123341_() - target.m_123341_();
                        int diffY = source.m_123342_() - target.m_123342_();
                        int diffZ = source.m_123343_() - target.m_123343_();
                        if (diffX != 0) {
                            shape = Shapes.m_83110_((VoxelShape)shape, (VoxelShape)Shapes.m_83064_((AABB)new AABB(target).m_82363_((double)diffX, 0.0, 0.0)));
                        }
                        if (diffY != 0) {
                            shape = Shapes.m_83110_((VoxelShape)shape, (VoxelShape)Shapes.m_83064_((AABB)new AABB(target.m_7918_(diffX, 0, 0)).m_82363_(0.0, (double)diffY, 0.0)));
                        }
                        if (diffZ != 0) {
                            shape = Shapes.m_83110_((VoxelShape)shape, (VoxelShape)Shapes.m_83064_((AABB)new AABB(target.m_7918_(diffX, diffY, 0)).m_82363_(0.0, 0.0, (double)diffZ)));
                        }
                    }
                    if (shape != null) {
                        List list = shape.m_83299_();
                        PoseStack poseStack = event.getPoseStack();
                        double xIn = -view.f_82479_;
                        double yIn = -view.f_82480_;
                        double zIn = -view.f_82481_;
                        for (AABB aabb : list) {
                            float r = (float)this.highlightColor.getElement(0);
                            float g = (float)this.highlightColor.getElement(1);
                            float b = (float)this.highlightColor.getElement(2);
                            float a = (float)this.highlightColor.getElement(3);
                            VoxelShape individual = Shapes.m_83064_((AABB)aabb.m_82386_(0.0, 0.0, 0.0));
                            PoseStack.Pose pose = poseStack.m_85850_();
                            Matrix4f matrix4f = pose.m_85861_();
                            individual.m_83224_((minX, minY, minZ, maxX, maxY, maxZ) -> {
                                float f = (float)(maxX - minX);
                                float f1 = (float)(maxY - minY);
                                float f2 = (float)(maxZ - minZ);
                                float f3 = Mth.m_14116_((float)(f * f + f1 * f1 + f2 * f2));
                                bufferIn.m_85982_(matrix4f, (float)(minX + xIn), (float)(minY + yIn), (float)(minZ + zIn)).m_85950_(r, g, b, a).m_85977_(pose.m_85864_(), f /= f3, f1 /= f3, f2 /= f3).m_5752_();
                                bufferIn.m_85982_(matrix4f, (float)(maxX + xIn), (float)(maxY + yIn), (float)(maxZ + zIn)).m_85950_(r, g, b, a).m_85977_(pose.m_85864_(), f, f1, f2).m_5752_();
                            });
                        }
                        event.setCanceled(true);
                    }
                }
            }
        }
    }
}

