/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.content.tools.item;

import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.monster.Slime;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.levelgen.WorldgenRandom;
import net.minecraft.world.phys.Vec3;
import vazkii.quark.base.item.QuarkItem;
import vazkii.zeta.module.ZetaModule;
import vazkii.zeta.util.ItemNBTHelper;

public class SlimeInABucketItem
extends QuarkItem {
    public static final String TAG_ENTITY_DATA = "slime_nbt";
    public static final String TAG_EXCITED = "excited";

    public SlimeInABucketItem(ZetaModule module) {
        super("slime_in_a_bucket", module, new Item.Properties().m_41487_(1).m_41491_(CreativeModeTab.f_40753_).m_41495_(Items.f_42446_));
    }

    public void m_6883_(@Nonnull ItemStack stack, @Nonnull Level world, @Nonnull Entity entity, int itemSlot, boolean isSelected) {
        if (world instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)world;
            Vec3 pos = entity.m_20182_();
            int x = Mth.m_14107_((double)pos.f_82479_);
            int z = Mth.m_14107_((double)pos.f_82481_);
            boolean slime = SlimeInABucketItem.isSlimeChunk(serverLevel, x, z);
            boolean excited = ItemNBTHelper.getBoolean(stack, TAG_EXCITED, false);
            if (excited != slime) {
                ItemNBTHelper.setBoolean(stack, TAG_EXCITED, slime);
            }
        }
    }

    @Nonnull
    public InteractionResult m_6225_(UseOnContext context) {
        BlockPos pos = context.m_8083_();
        Direction facing = context.m_43719_();
        Level worldIn = context.m_43725_();
        Player playerIn = context.m_43723_();
        InteractionHand hand = context.m_43724_();
        double x = (double)pos.m_123341_() + 0.5 + (double)facing.m_122429_();
        double y = (double)pos.m_123342_() + 0.5 + (double)facing.m_122430_();
        double z = (double)pos.m_123343_() + 0.5 + (double)facing.m_122431_();
        if (!worldIn.f_46443_) {
            Slime slime = new Slime(EntityType.f_20526_, worldIn);
            CompoundTag data = ItemNBTHelper.getCompound(playerIn.m_21120_(hand), TAG_ENTITY_DATA, true);
            if (data != null) {
                slime.m_20258_(data);
            } else {
                slime.m_21051_(Attributes.f_22276_).m_22100_(1.0);
                slime.m_21051_(Attributes.f_22279_).m_22100_(0.3);
                slime.m_21153_(slime.m_21233_());
            }
            slime.m_6034_(x, y, z);
            worldIn.m_220400_((Entity)playerIn, GameEvent.f_157810_, slime.m_20182_());
            worldIn.m_7967_((Entity)slime);
            playerIn.m_6674_(hand);
        }
        worldIn.m_5594_(playerIn, pos, SoundEvents.f_11778_, SoundSource.NEUTRAL, 1.0f, 1.0f);
        if (!playerIn.m_150110_().f_35937_) {
            playerIn.m_21008_(hand, new ItemStack((ItemLike)Items.f_42446_));
        }
        return InteractionResult.SUCCESS;
    }

    @Nonnull
    public Component m_7626_(@Nonnull ItemStack stack) {
        CompoundTag cmp;
        if (stack.m_41782_() && (cmp = ItemNBTHelper.getCompound(stack, TAG_ENTITY_DATA, false)) != null && cmp.m_128441_("CustomName")) {
            MutableComponent custom = Component.Serializer.m_130701_((String)cmp.m_128461_("CustomName"));
            return Component.m_237110_((String)"item.quark.slime_in_a_bucket.named", (Object[])new Object[]{custom});
        }
        return super.m_7626_(stack);
    }

    public static boolean isSlimeChunk(ServerLevel world, int x, int z) {
        ChunkPos chunkpos = new ChunkPos(new BlockPos(x, 0, z));
        return WorldgenRandom.m_224681_((int)chunkpos.f_45578_, (int)chunkpos.f_45579_, (long)world.m_7328_(), (long)987234911L).m_188503_(10) == 0;
    }
}

