/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.content.tools.item;

import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.data.BuiltinRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ClickAction;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.apache.commons.lang3.tuple.Pair;
import vazkii.quark.api.ITrowelable;
import vazkii.quark.api.IUsageTickerOverride;
import vazkii.quark.base.handler.MiscUtil;
import vazkii.quark.base.item.QuarkItem;
import vazkii.quark.base.module.ModuleLoader;
import vazkii.quark.content.tools.module.SeedPouchModule;
import vazkii.zeta.module.ZetaModule;
import vazkii.zeta.util.ItemNBTHelper;

public class SeedPouchItem
extends QuarkItem
implements IUsageTickerOverride,
ITrowelable {
    public static final String TAG_STORED_ITEM = "storedItem";
    public static final String TAG_COUNT = "itemCount";
    private static final int BAR_COLOR = Mth.m_14159_((float)0.4f, (float)0.4f, (float)1.0f);

    public SeedPouchItem(ZetaModule module) {
        super("seed_pouch", module, new Item.Properties().m_41487_(1).m_41491_(CreativeModeTab.f_40756_));
    }

    public boolean m_142305_(@Nonnull ItemStack stack, @Nonnull ItemStack incoming, @Nonnull Slot slot, @Nonnull ClickAction action, @Nonnull Player player, @Nonnull SlotAccess accessor) {
        if (action == ClickAction.SECONDARY) {
            if (!incoming.m_41619_()) {
                return SeedPouchItem.addItemToMe(player, stack, incoming, slot);
            }
            return SeedPouchItem.removeItemFromMe(player, stack, slot, accessor);
        }
        return false;
    }

    public boolean m_142207_(@Nonnull ItemStack stack, @Nonnull Slot slot, @Nonnull ClickAction action, @Nonnull Player player) {
        ItemStack incoming;
        if (action == ClickAction.SECONDARY && !(incoming = slot.m_7993_()).m_41619_()) {
            return SeedPouchItem.addItemToMe(player, stack, incoming, slot);
        }
        return false;
    }

    public boolean m_8120_(@Nonnull ItemStack stack) {
        return false;
    }

    public static boolean addItemToMe(Player player, ItemStack stack, ItemStack incoming, Slot slot) {
        if (slot.m_8010_(player) && slot.m_5857_(stack) && SeedPouchItem.canTakeItem(stack, incoming) && stack.m_41613_() == 1) {
            Pair<ItemStack, Integer> contents = SeedPouchItem.getContents(stack);
            if (contents == null) {
                SeedPouchItem.setItemStack(stack, incoming);
                incoming.m_41764_(0);
            } else {
                int curr = (Integer)contents.getRight();
                int missing = SeedPouchModule.maxItems - curr;
                int incCount = incoming.m_41613_();
                int toDrop = Math.min(incCount, missing);
                SeedPouchItem.setCount(stack, curr + toDrop);
                incoming.m_41764_(incCount - toDrop);
            }
            SeedPouchItem.playInsertSound((Entity)player);
            return true;
        }
        return false;
    }

    private static boolean removeItemFromMe(Player player, ItemStack stack, Slot slot, SlotAccess accessor) {
        Pair<ItemStack, Integer> contents = SeedPouchItem.getContents(stack);
        if (contents != null && slot.m_150651_(player) && stack.m_41613_() == 1) {
            ItemStack held = accessor.m_142196_();
            ItemStack seed = (ItemStack)contents.getLeft();
            int pouchCount = (Integer)contents.getRight();
            if (held.m_41619_()) {
                int takeOut = Math.min(seed.m_41741_(), (Integer)contents.getRight());
                ItemStack result = seed.m_41777_();
                result.m_41764_(takeOut);
                accessor.m_142104_(result);
                SeedPouchItem.setCount(stack, pouchCount - takeOut);
                SeedPouchItem.playRemoveOneSound((Entity)player);
                return true;
            }
        }
        return false;
    }

    private static void playRemoveOneSound(Entity entity) {
        entity.m_5496_(SoundEvents.f_184216_, 0.8f, 0.8f + entity.m_9236_().m_213780_().m_188501_() * 0.4f);
    }

    private static void playInsertSound(Entity entity) {
        entity.m_5496_(SoundEvents.f_184215_, 0.8f, 0.8f + entity.m_9236_().m_213780_().m_188501_() * 0.4f);
    }

    public boolean m_142522_(@Nonnull ItemStack stack) {
        return true;
    }

    public int m_142158_(@Nonnull ItemStack stack) {
        Pair<ItemStack, Integer> contents = SeedPouchItem.getContents(stack);
        int count = contents == null ? 0 : (Integer)contents.getRight();
        return Math.round((float)count * 13.0f / (float)SeedPouchModule.maxItems);
    }

    public int m_142159_(@Nonnull ItemStack stack) {
        return BAR_COLOR;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static float itemFraction(ItemStack stack, ClientLevel world, LivingEntity entityIn, int i) {
        Pair<ItemStack, Integer> contents;
        if (entityIn instanceof Player) {
            ItemStack held;
            Player player = (Player)entityIn;
            if (player.f_36096_ != null && SeedPouchItem.canTakeItem(stack, held = player.f_36096_.m_142621_())) {
                return 0.0f;
            }
        }
        if ((contents = SeedPouchItem.getContents(stack)) == null) {
            return 0.0f;
        }
        return (float)((Integer)contents.getRight()).intValue() / (float)SeedPouchModule.maxItems;
    }

    public static Pair<ItemStack, Integer> getContents(ItemStack stack) {
        CompoundTag nbt = ItemNBTHelper.getCompound(stack, TAG_STORED_ITEM, true);
        if (nbt == null) {
            return null;
        }
        ItemStack contained = ItemStack.m_41712_((CompoundTag)nbt);
        int count = ItemNBTHelper.getInt(stack, TAG_COUNT, 0);
        return Pair.of((Object)contained, (Object)count);
    }

    public static boolean canTakeItem(ItemStack stack, ItemStack incoming) {
        Pair<ItemStack, Integer> contents = SeedPouchItem.getContents(stack);
        if (contents == null) {
            return incoming.m_204117_(SeedPouchModule.seedPouchHoldableTag);
        }
        return (Integer)contents.getRight() < SeedPouchModule.maxItems && ItemStack.m_41746_((ItemStack)incoming, (ItemStack)((ItemStack)contents.getLeft()));
    }

    public static void setItemStack(ItemStack stack, ItemStack target) {
        ItemStack copy = target.m_41777_();
        copy.m_41764_(1);
        CompoundTag nbt = new CompoundTag();
        copy.m_41739_(nbt);
        ItemNBTHelper.setCompound(stack, TAG_STORED_ITEM, nbt);
        SeedPouchItem.setCount(stack, target.m_41613_());
    }

    public static void setCount(ItemStack stack, int count) {
        if (count <= 0) {
            CompoundTag tag = stack.m_41783_();
            if (tag != null) {
                tag.m_128473_(TAG_STORED_ITEM);
                tag.m_128473_(TAG_COUNT);
            }
            return;
        }
        ItemNBTHelper.setInt(stack, TAG_COUNT, count);
    }

    @Nonnull
    public Component m_7626_(@Nonnull ItemStack stack) {
        Component base = super.m_7626_(stack);
        Pair<ItemStack, Integer> contents = SeedPouchItem.getContents(stack);
        if (contents == null) {
            return base;
        }
        MutableComponent comp = base.m_6881_();
        comp.m_7220_((Component)Component.m_237113_((String)" ("));
        comp.m_7220_(((ItemStack)contents.getLeft()).m_41786_());
        comp.m_7220_((Component)Component.m_237113_((String)")"));
        return comp;
    }

    @Nonnull
    public InteractionResult m_6225_(UseOnContext context) {
        ItemStack stack = context.m_43722_();
        Pair<ItemStack, Integer> contents = SeedPouchItem.getContents(stack);
        if (contents != null) {
            ItemStack target = ((ItemStack)contents.getLeft()).m_41777_();
            int total = (Integer)contents.getRight();
            target.m_41764_(Math.min(target.m_41741_(), total));
            Player player = context.m_43723_();
            if (!player.m_6144_()) {
                return this.placeSeed(context, target, context.m_8083_(), total);
            }
            InteractionResult bestRes = InteractionResult.FAIL;
            int range = SeedPouchModule.shiftRange;
            int blocks = range * range;
            int shift = -((int)Math.floor((float)range / 2.0f));
            for (int i = 0; i < blocks; ++i) {
                int x = shift + i % range;
                int z = shift + i / range;
                InteractionResult res = this.placeSeed(context, target, context.m_8083_().m_7918_(x, 0, z), total);
                contents = SeedPouchItem.getContents(stack);
                if (contents == null) break;
                total = (Integer)contents.getRight();
                if (bestRes.m_19077_()) continue;
                bestRes = res;
            }
            return bestRes;
        }
        return super.m_6225_(context);
    }

    private InteractionResult placeSeed(UseOnContext context, ItemStack target, BlockPos pos, int total) {
        int diff;
        Player player = context.m_43723_();
        ItemStack restore = target;
        if (player != null) {
            restore = player.m_21120_(context.m_43724_());
            player.m_21008_(context.m_43724_(), target);
        }
        InteractionResult res = target.m_41720_().m_6225_((UseOnContext)new PouchItemUseContext(context, target, pos));
        if (player != null) {
            player.m_21008_(context.m_43724_(), restore);
        }
        int n = diff = res == InteractionResult.CONSUME ? 1 : 0;
        if (!(diff <= 0 || context.m_43723_() != null && context.m_43723_().m_150110_().f_35937_)) {
            SeedPouchItem.setCount(context.m_43722_(), total - diff);
        }
        return res;
    }

    @Override
    public void m_6787_(@Nonnull CreativeModeTab group, @Nonnull NonNullList<ItemStack> items) {
        super.m_6787_(group, items);
        if (SeedPouchModule.showAllVariantsInCreative && this.isEnabled() && this.m_220152_(group)) {
            List<Item> tagItems;
            try {
                tagItems = MiscUtil.getTagValues(BuiltinRegistries.f_206379_, SeedPouchModule.seedPouchHoldableTag);
            }
            catch (IllegalStateException e) {
                return;
            }
            for (Item i : tagItems) {
                if (!ModuleLoader.INSTANCE.isItemEnabled(i)) continue;
                ItemStack stack = new ItemStack((ItemLike)this);
                SeedPouchItem.setItemStack(stack, new ItemStack((ItemLike)i));
                SeedPouchItem.setCount(stack, SeedPouchModule.maxItems);
                items.add((Object)stack);
            }
        }
    }

    @Override
    public ItemStack getUsageTickerItem(ItemStack stack) {
        Pair<ItemStack, Integer> contents = SeedPouchItem.getContents(stack);
        if (contents != null) {
            return (ItemStack)contents.getLeft();
        }
        return stack;
    }

    @Override
    public int getUsageTickerCountForItem(ItemStack stack, Predicate<ItemStack> target) {
        Pair<ItemStack, Integer> contents = SeedPouchItem.getContents(stack);
        if (contents != null && target.test((ItemStack)contents.getLeft())) {
            return (Integer)contents.getRight();
        }
        return 0;
    }

    @Nonnull
    public Optional<TooltipComponent> m_142422_(@Nonnull ItemStack stack) {
        return SeedPouchItem.getContents(stack) == null ? Optional.empty() : Optional.of(new Tooltip(stack));
    }

    public static class PouchItemUseContext
    extends UseOnContext {
        protected PouchItemUseContext(UseOnContext parent, ItemStack stack, BlockPos targetPos) {
            super(parent.m_43725_(), parent.m_43723_(), parent.m_43724_(), stack, new BlockHitResult(parent.m_43720_(), parent.m_43719_(), targetPos, parent.m_43721_()));
        }
    }

    public record Tooltip(ItemStack stack) implements TooltipComponent
    {
    }
}

