/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.content.mobs.module;

import com.google.common.collect.ImmutableSet;
import java.util.Set;
import net.minecraft.client.renderer.entity.EntityRenderers;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BiomeTags;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.SpawnPlacements;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.material.Fluids;
import vazkii.quark.base.Quark;
import vazkii.quark.base.handler.EntityAttributeHandler;
import vazkii.quark.base.handler.QuarkSounds;
import vazkii.quark.base.handler.advancement.QuarkAdvancementHandler;
import vazkii.quark.base.handler.advancement.mod.BalancedDietModifier;
import vazkii.quark.base.handler.advancement.mod.FuriousCocktailModifier;
import vazkii.quark.base.handler.advancement.mod.TwoByTwoModifier;
import vazkii.quark.base.item.QuarkItem;
import vazkii.quark.base.item.QuarkMobBucketItem;
import vazkii.quark.base.module.LoadModule;
import vazkii.quark.base.module.config.Config;
import vazkii.quark.base.module.config.type.CompoundBiomeConfig;
import vazkii.quark.base.module.config.type.EntitySpawnConfig;
import vazkii.quark.base.module.hint.Hint;
import vazkii.quark.base.util.QuarkEffect;
import vazkii.quark.base.world.EntitySpawnHandler;
import vazkii.quark.content.mobs.client.render.entity.CrabRenderer;
import vazkii.quark.content.mobs.entity.Crab;
import vazkii.zeta.client.event.ZClientSetup;
import vazkii.zeta.event.ZCommonSetup;
import vazkii.zeta.event.ZRegister;
import vazkii.zeta.event.bus.LoadEvent;
import vazkii.zeta.module.ZetaModule;

@LoadModule(category="mobs", hasSubscriptions=true)
public class CrabsModule
extends ZetaModule {
    public static EntityType<Crab> crabType;
    @Config
    public static EntitySpawnConfig spawnConfig;
    public static TagKey<Block> crabSpawnableTag;
    public static MobEffect resilience;
    @Config(flag="crab_brewing")
    public static boolean enableBrewing;
    @Config(description="Whether Resilience should be required for 'How Did We Get Here?' and (if brewing is enabled) 'A Furious Cocktail'.\nKeep this on when brewing is disabled if your pack adds an alternative source for the effect.")
    public static boolean resilienceRequiredForAllEffects;
    @Hint(key="crab_info")
    Item crab_leg;
    @Hint(key="crab_info")
    Item crab_shell;
    @Hint(key="crab_info")
    public static Item crab_bucket;

    @LoadEvent
    public final void register(ZRegister event) {
        this.crab_leg = new QuarkItem("crab_leg", this, new Item.Properties().m_41491_(CreativeModeTab.f_40755_).m_41489_(new FoodProperties.Builder().m_38757_().m_38760_(1).m_38758_(0.3f).m_38767_()));
        QuarkItem cookedCrabLeg = new QuarkItem("cooked_crab_leg", this, new Item.Properties().m_41491_(CreativeModeTab.f_40755_).m_41489_(new FoodProperties.Builder().m_38757_().m_38760_(8).m_38758_(0.8f).m_38767_()));
        this.crab_shell = new QuarkItem("crab_shell", this, new Item.Properties().m_41491_(CreativeModeTab.f_40758_)).setCondition(() -> enableBrewing);
        crab_bucket = new QuarkMobBucketItem(() -> crabType, () -> Fluids.f_76193_, () -> QuarkSounds.BUCKET_EMPTY_CRAB, "crab_bucket", this);
        resilience = new QuarkEffect("resilience", MobEffectCategory.BENEFICIAL, 5970436);
        resilience.m_19472_(Attributes.f_22278_, "2ddf3f0a-f386-47b6-aeb0-6bd32851f215", 0.5, AttributeModifier.Operation.ADDITION);
        event.getBrewingRegistry().addPotionMix("crab_brewing", () -> Ingredient.m_43929_((ItemLike[])new ItemLike[]{this.crab_shell}), resilience);
        crabType = EntityType.Builder.m_20704_(Crab::new, (MobCategory)MobCategory.CREATURE).m_20699_(0.9f, 0.5f).m_20702_(8).setCustomClientFactory((spawnEntity, world) -> new Crab((EntityType<? extends Crab>)crabType, (Level)world)).m_20712_("crab");
        Quark.ZETA.registry.register(crabType, "crab", Registry.f_122903_);
        EntitySpawnHandler.registerSpawn(crabType, MobCategory.CREATURE, SpawnPlacements.Type.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Crab::spawnPredicate, spawnConfig);
        EntitySpawnHandler.addEgg(this, crabType, 8993826, 9528648, spawnConfig);
        EntityAttributeHandler.put(crabType, Crab::prepareAttributes);
        QuarkAdvancementHandler.addModifier(new FuriousCocktailModifier(this, () -> enableBrewing, (Set<MobEffect>)ImmutableSet.of((Object)resilience)).setCondition(() -> resilienceRequiredForAllEffects));
        QuarkAdvancementHandler.addModifier(new TwoByTwoModifier(this, (Set<EntityType<?>>)ImmutableSet.of(crabType)));
        QuarkAdvancementHandler.addModifier(new BalancedDietModifier(this, (Set<ItemLike>)ImmutableSet.of((Object)this.crab_leg, (Object)cookedCrabLeg)));
    }

    @LoadEvent
    public final void setup(ZCommonSetup event) {
        crabSpawnableTag = BlockTags.create((ResourceLocation)new ResourceLocation("quark", "crab_spawnable"));
    }

    @LoadEvent
    public final void clientSetup(ZClientSetup event) {
        EntityRenderers.m_174036_(crabType, CrabRenderer::new);
    }

    static {
        spawnConfig = new EntitySpawnConfig(5, 1, 3, CompoundBiomeConfig.fromBiomeTags(false, BiomeTags.f_207604_));
        enableBrewing = true;
        resilienceRequiredForAllEffects = true;
    }
}

