/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.content.management.module;

import com.mojang.datafixers.util.Either;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.MenuScreens;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.gui.screens.inventory.CreativeModeInventoryScreen;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Registry;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ClickAction;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.ElytraItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.RenderTooltipEvent;
import net.minecraftforge.client.event.ScreenEvent;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.extensions.IForgeMenuType;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.wrapper.EmptyHandler;
import net.minecraftforge.network.NetworkHooks;
import vazkii.quark.base.Quark;
import vazkii.quark.base.handler.GeneralConfig;
import vazkii.quark.base.handler.SimilarBlockTypeHandler;
import vazkii.quark.base.module.LoadModule;
import vazkii.quark.base.module.config.Config;
import vazkii.quark.base.module.hint.Hint;
import vazkii.quark.base.network.QuarkNetwork;
import vazkii.quark.base.network.message.ScrollOnBundleMessage;
import vazkii.quark.content.management.client.screen.HeldShulkerBoxScreen;
import vazkii.quark.content.management.inventory.HeldShulkerBoxContainer;
import vazkii.quark.content.management.inventory.HeldShulkerBoxMenu;
import vazkii.zeta.client.event.ZClientSetup;
import vazkii.zeta.event.ZConfigChanged;
import vazkii.zeta.event.ZRegister;
import vazkii.zeta.event.bus.LoadEvent;
import vazkii.zeta.module.ZetaModule;
import vazkii.zeta.util.ItemNBTHelper;
import vazkii.zeta.util.RegistryUtil;

@LoadModule(category="management", hasSubscriptions=true)
public class ExpandedItemInteractionsModule
extends ZetaModule {
    @Config
    public static boolean enableArmorInteraction = true;
    @Config(flag="shulker_box_interaction")
    public static boolean enableShulkerBoxInteraction = true;
    @Config(flag="lava_interaction")
    public static boolean enableLavaInteraction = true;
    @Config
    public static boolean allowOpeningShulkerBoxes = true;
    @Config(flag="allow_rotating_bundles")
    public static boolean allowRotatingBundles = true;
    @Hint(value="lava_interaction")
    Item lava_bucket = Items.f_42448_;
    @Hint(value="allow_rotating_bundles", key="rotating_bundles")
    Item bundle = Items.f_151058_;
    @Hint(value="shulker_box_interaction", key="shulker_box_right_click")
    List<Item> shulkers;
    private static boolean staticEnabled = false;
    public static MenuType<HeldShulkerBoxMenu> heldShulkerBoxMenuType;

    @LoadEvent
    public final void register(ZRegister event) {
        heldShulkerBoxMenuType = IForgeMenuType.create(HeldShulkerBoxMenu::fromNetwork);
        Quark.ZETA.registry.register(heldShulkerBoxMenuType, "held_shulker_box", Registry.f_122913_);
    }

    @LoadEvent
    public final void clientSetup(ZClientSetup event) {
        MenuScreens.m_96206_(heldShulkerBoxMenuType, HeldShulkerBoxScreen::new);
    }

    @LoadEvent
    public final void configChanged(ZConfigChanged event) {
        staticEnabled = this.configEnabled;
        this.shulkers = RegistryUtil.massRegistryGet(GeneralConfig.shulkerBoxes, Registry.f_122827_);
    }

    public static boolean overrideStackedOnOther(ItemStack stack, Slot slot, ClickAction action, Player player) {
        if (!staticEnabled || action == ClickAction.PRIMARY) {
            return false;
        }
        ItemStack stackAt = slot.m_7993_();
        if (enableShulkerBoxInteraction && ExpandedItemInteractionsModule.shulkerOverride(stack, stackAt, slot, action, player, false)) {
            if (player.f_36096_ != null) {
                player.f_36096_.m_6199_(slot.f_40218_);
            }
            return true;
        }
        return false;
    }

    public static boolean overrideOtherStackedOnMe(ItemStack stack, ItemStack incoming, Slot slot, ClickAction action, Player player, SlotAccess accessor) {
        if (!staticEnabled || action == ClickAction.PRIMARY) {
            return false;
        }
        if (enableLavaInteraction && ExpandedItemInteractionsModule.lavaBucketOverride(stack, incoming, slot, action, player)) {
            return true;
        }
        if (enableArmorInteraction && ExpandedItemInteractionsModule.armorOverride(stack, incoming, slot, action, player, false)) {
            return true;
        }
        return enableShulkerBoxInteraction && ExpandedItemInteractionsModule.shulkerOverride(stack, incoming, slot, action, player, true);
    }

    @SubscribeEvent
    @OnlyIn(value=Dist.CLIENT)
    public void onScroll(ScreenEvent.MouseScrolled.Pre event) {
        ListTag items;
        CompoundTag tag;
        ItemStack underStack;
        AbstractContainerScreen containerGui;
        Slot under;
        if (!allowRotatingBundles) {
            return;
        }
        Minecraft mc = Minecraft.m_91087_();
        Screen gui = mc.f_91080_;
        double scrollDelta = event.getScrollDelta();
        if (mc.f_91074_ != null && gui instanceof AbstractContainerScreen && (under = (containerGui = (AbstractContainerScreen)gui).getSlotUnderMouse()) != null && (underStack = under.m_7993_()).m_150930_(Items.f_151058_) && (tag = underStack.m_41783_()) != null && (items = tag.m_128437_("Items", 10)).size() > 1) {
            AbstractContainerMenu menu = containerGui.m_6262_();
            event.setCanceled(true);
            if (scrollDelta < -0.1 || scrollDelta > 0.1) {
                ExpandedItemInteractionsModule.rotateBundle(underStack, scrollDelta);
                QuarkNetwork.sendToServer(new ScrollOnBundleMessage(menu.f_38840_, menu.m_182424_(), under.f_40219_, scrollDelta));
            }
        }
    }

    public static void scrollOnBundle(ServerPlayer player, int containerId, int stateId, int slotNum, double scrollDelta) {
        if (!staticEnabled || !allowRotatingBundles) {
            return;
        }
        if (-0.1 <= scrollDelta && scrollDelta <= 0.1) {
            return;
        }
        player.m_9243_();
        if (player.f_36096_.f_38840_ == containerId) {
            if (player.m_5833_()) {
                player.f_36096_.m_150429_();
            } else if (!player.f_36096_.m_6875_((Player)player)) {
                Quark.LOG.debug("Player {} interacted with invalid menu {}", (Object)player, (Object)player.f_36096_);
            } else {
                boolean flag = stateId != player.f_36096_.m_182424_();
                player.f_36096_.m_150443_();
                Slot under = player.f_36096_.m_38853_(slotNum);
                if (under != null) {
                    ItemStack underStack = under.m_7993_();
                    ExpandedItemInteractionsModule.rotateBundle(underStack, scrollDelta);
                }
                player.f_36096_.m_150444_();
                if (flag) {
                    player.f_36096_.m_182423_();
                } else {
                    player.f_36096_.m_38946_();
                }
            }
        }
    }

    private static void rotateBundle(ItemStack stack, double scrollDelta) {
        ListTag items;
        CompoundTag tag;
        if (stack.m_150930_(Items.f_151058_) && (tag = stack.m_41783_()) != null && (items = tag.m_128437_("Items", 10)).size() > 1) {
            ListTag rotatedItems = new ListTag();
            if (scrollDelta < 0.0) {
                rotatedItems.add((Object)items.get(items.size() - 1));
                for (int i = 0; i < items.size() - 1; ++i) {
                    rotatedItems.add((Object)items.get(i));
                }
            } else {
                for (int i = 1; i < items.size(); ++i) {
                    rotatedItems.add((Object)items.get(i));
                }
                rotatedItems.add((Object)items.get(0));
            }
            tag.m_128365_("Items", (Tag)rotatedItems);
        }
    }

    @SubscribeEvent
    @OnlyIn(value=Dist.CLIENT)
    public void onDrawScreen(ScreenEvent.Render.Post event) {
        Slot under;
        AbstractContainerScreen containerGui;
        ItemStack held;
        Minecraft mc = Minecraft.m_91087_();
        Screen gui = mc.f_91080_;
        if (mc.f_91074_ != null && gui instanceof AbstractContainerScreen && !(held = (containerGui = (AbstractContainerScreen)gui).m_6262_().m_142621_()).m_41619_() && (under = containerGui.getSlotUnderMouse()) != null) {
            ItemStack underStack = under.m_7993_();
            int x = event.getMouseX();
            int y = event.getMouseY();
            if (enableLavaInteraction && ExpandedItemInteractionsModule.canTrashItem(underStack, held, under, (Player)mc.f_91074_)) {
                gui.m_96597_(event.getPoseStack(), List.of(Component.m_237115_((String)"quark.misc.trash_item").m_130940_(ChatFormatting.RED)), x, y);
            } else if (enableShulkerBoxInteraction && ExpandedItemInteractionsModule.tryAddToShulkerBox((Player)mc.f_91074_, underStack, held, under, true, true, true) != null) {
                gui.renderComponentTooltip(event.getPoseStack(), List.of(Component.m_237115_((String)(SimilarBlockTypeHandler.isShulkerBox(held) ? "quark.misc.merge_shulker_box" : "quark.misc.insert_shulker_box")).m_130940_(ChatFormatting.YELLOW)), x, y, underStack);
            } else if (enableShulkerBoxInteraction && SimilarBlockTypeHandler.isShulkerBox(underStack)) {
                gui.renderComponentTooltip(event.getPoseStack(), gui.m_96555_(underStack), x, y, underStack);
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    @OnlyIn(value=Dist.CLIENT)
    public void gatherTooltip(RenderTooltipEvent.GatherComponents event) {
        AbstractContainerScreen containerGui;
        if (!(enableArmorInteraction || enableShulkerBoxInteraction && allowOpeningShulkerBoxes)) {
            return;
        }
        Minecraft mc = Minecraft.m_91087_();
        Screen gui = mc.f_91080_;
        if (mc.f_91074_ != null && gui instanceof AbstractContainerScreen && (containerGui = (AbstractContainerScreen)gui).m_6262_().m_142621_().m_41619_()) {
            CreativeModeInventoryScreen creativeGui;
            Slot under = containerGui.getSlotUnderMouse();
            if (containerGui instanceof CreativeModeInventoryScreen && (creativeGui = (CreativeModeInventoryScreen)containerGui).m_98628_() != CreativeModeTab.f_40761_.m_40775_()) {
                return;
            }
            if (under != null) {
                ItemStack underStack = under.m_7993_();
                if (event.getItemStack() == underStack) {
                    if (enableArmorInteraction && ExpandedItemInteractionsModule.armorOverride(underStack, ItemStack.f_41583_, under, ClickAction.SECONDARY, (Player)mc.f_91074_, true)) {
                        event.getTooltipElements().add(Either.left((Object)Component.m_237115_((String)"quark.misc.equip_armor").m_130940_(ChatFormatting.YELLOW)));
                    } else if (enableShulkerBoxInteraction && ExpandedItemInteractionsModule.canOpenShulkerBox(underStack, ItemStack.f_41583_, under, (Player)mc.f_91074_)) {
                        event.getTooltipElements().add(Either.left((Object)Component.m_237115_((String)"quark.misc.open_shulker").m_130940_(ChatFormatting.YELLOW)));
                    }
                }
            }
        }
    }

    private static boolean armorOverride(ItemStack stack, ItemStack incoming, Slot slot, ClickAction action, Player player, boolean simulate) {
        if (incoming.m_41619_()) {
            if (stack.m_41613_() > 1) {
                return false;
            }
            EquipmentSlot equipSlot = null;
            Item item = stack.m_41720_();
            if (item instanceof ArmorItem) {
                ArmorItem armor = (ArmorItem)item;
                equipSlot = armor.m_40402_();
            } else if (stack.m_41720_() instanceof ElytraItem) {
                equipSlot = EquipmentSlot.CHEST;
            }
            if (equipSlot != null) {
                int index;
                ItemStack currArmor = player.m_6844_(equipSlot);
                if (slot.m_8010_(player) && slot.m_5857_(currArmor) && (currArmor.m_41619_() || !EnchantmentHelper.m_44920_((ItemStack)currArmor) && currArmor != stack) && (index = slot.getSlotIndex()) < slot.f_40218_.m_6643_()) {
                    if (!simulate) {
                        player.m_8061_(equipSlot, stack.m_41777_());
                        slot.f_40218_.m_6836_(index, currArmor.m_41777_());
                        slot.m_40234_(stack, currArmor);
                    }
                    return true;
                }
            }
        }
        return false;
    }

    private static boolean canTrashItem(ItemStack stack, ItemStack incoming, Slot slot, Player player) {
        return stack.m_41720_() == Items.f_42448_ && !incoming.m_41619_() && !player.m_150110_().f_35937_ && slot.m_150651_(player) && slot.m_5857_(stack) && !incoming.m_41720_().m_41475_() && !SimilarBlockTypeHandler.isShulkerBox(incoming);
    }

    public static boolean lavaBucketOverride(ItemStack stack, ItemStack incoming, Slot slot, ClickAction action, Player player) {
        if (ExpandedItemInteractionsModule.canTrashItem(stack, incoming, slot, player)) {
            incoming.m_41764_(0);
            if (!player.f_19853_.f_46443_) {
                player.f_19853_.m_5594_(null, player.m_20183_(), SoundEvents.f_12031_, SoundSource.PLAYERS, 0.25f, 2.0f + (float)Math.random());
            }
            return true;
        }
        return false;
    }

    public static boolean canOpenShulkerBox(ItemStack stack, ItemStack incoming, Slot slot, Player player) {
        return incoming.m_41619_() && allowOpeningShulkerBoxes && (!player.m_242612_() || player.f_36096_ instanceof InventoryMenu) && slot.f_40218_ == player.m_150109_() && SimilarBlockTypeHandler.isShulkerBox(stack) && slot.m_8010_(player);
    }

    private static boolean shulkerOverride(ItemStack shulkerStack, ItemStack incoming, Slot slot, ClickAction action, Player player, boolean isStackedOnMe) {
        ItemStack finished;
        if (shulkerStack.m_41613_() != 1) {
            return false;
        }
        if (isStackedOnMe && ExpandedItemInteractionsModule.canOpenShulkerBox(shulkerStack, incoming, slot, player)) {
            int lockedSlot = slot.getSlotIndex();
            if (player instanceof ServerPlayer) {
                ServerPlayer splayer = (ServerPlayer)player;
                HeldShulkerBoxContainer container = new HeldShulkerBoxContainer((Player)splayer, lockedSlot);
                NetworkHooks.openScreen((ServerPlayer)splayer, (MenuProvider)container, buf -> buf.writeInt(lockedSlot));
            } else {
                player.m_5496_(SoundEvents.f_12409_, 1.0f, 1.0f);
            }
            return true;
        }
        if (!incoming.m_41619_() && ExpandedItemInteractionsModule.tryAddToShulkerBox(player, shulkerStack, incoming, slot, true, true, isStackedOnMe) != null && (finished = ExpandedItemInteractionsModule.tryAddToShulkerBox(player, shulkerStack, incoming, slot, false, isStackedOnMe, isStackedOnMe)) != null) {
            if (isStackedOnMe) {
                player.m_5496_(SoundEvents.f_12409_, 0.7f, 1.5f);
                slot.m_5852_(finished);
            }
            return true;
        }
        return false;
    }

    public static BlockEntity getShulkerBoxEntity(ItemStack shulkerBox) {
        CompoundTag cmp = ItemNBTHelper.getCompound(shulkerBox, "BlockEntityTag", false);
        if (cmp.m_128441_("LootTable")) {
            return null;
        }
        BlockEntity te = null;
        cmp = cmp.m_6426_();
        cmp.m_128359_("id", "minecraft:shulker_box");
        if (shulkerBox.m_41720_() instanceof BlockItem) {
            Block shulkerBoxBlock = Block.m_49814_((Item)shulkerBox.m_41720_());
            BlockState defaultState = shulkerBoxBlock.m_49966_();
            if (shulkerBoxBlock instanceof EntityBlock && (te = ((EntityBlock)shulkerBoxBlock).m_142194_(BlockPos.f_121853_, defaultState)) != null) {
                te.m_142466_(cmp);
            }
        }
        return te;
    }

    private static ItemStack tryAddToShulkerBox(Player player, ItemStack shulkerBox, ItemStack stack, Slot slot, boolean simulate, boolean useCopy, boolean allowDump) {
        LazyOptional handlerHolder;
        if (!SimilarBlockTypeHandler.isShulkerBox(shulkerBox) || !slot.m_8010_(player)) {
            return null;
        }
        BlockEntity tile = ExpandedItemInteractionsModule.getShulkerBoxEntity(shulkerBox);
        if (tile != null && (handlerHolder = tile.getCapability(ForgeCapabilities.ITEM_HANDLER, null)).isPresent()) {
            ItemStack result;
            boolean did;
            LazyOptional otherHolder;
            BlockEntity otherShulker;
            IItemHandler handler = (IItemHandler)handlerHolder.orElseGet(EmptyHandler::new);
            if (SimilarBlockTypeHandler.isShulkerBox(stack) && allowDump && (otherShulker = ExpandedItemInteractionsModule.getShulkerBoxEntity(stack)) != null && (otherHolder = otherShulker.getCapability(ForgeCapabilities.ITEM_HANDLER, null)).isPresent()) {
                IItemHandler otherHandler = (IItemHandler)otherHolder.orElseGet(EmptyHandler::new);
                boolean any = false;
                for (int i = 0; i < otherHandler.getSlots(); ++i) {
                    ItemStack result2;
                    ItemStack inserting = otherHandler.extractItem(i, 64, true);
                    if (inserting.m_41619_() || !(result2 = ItemHandlerHelper.insertItem((IItemHandler)handler, (ItemStack)inserting, (boolean)true)).m_41619_() && result2.m_41613_() == inserting.m_41613_()) continue;
                    if (simulate) {
                        return shulkerBox;
                    }
                    ItemHandlerHelper.insertItem((IItemHandler)handler, (ItemStack)otherHandler.extractItem(i, inserting.m_41613_() - result2.m_41613_(), false), (boolean)false);
                    any = true;
                }
                if (any) {
                    ItemStack workStack = useCopy ? shulkerBox.m_41777_() : shulkerBox;
                    ItemNBTHelper.setCompound(workStack, "BlockEntityTag", tile.m_187481_());
                    ItemNBTHelper.setCompound(stack, "BlockEntityTag", otherShulker.m_187481_());
                    if (slot.m_5857_(workStack)) {
                        return workStack;
                    }
                }
            }
            boolean bl = did = (result = ItemHandlerHelper.insertItem((IItemHandler)handler, (ItemStack)stack.m_41777_(), (boolean)simulate)).m_41619_() || result.m_41613_() != stack.m_41613_();
            if (did) {
                ItemStack workStack;
                ItemStack itemStack = workStack = useCopy ? shulkerBox.m_41777_() : shulkerBox;
                if (!simulate) {
                    stack.m_41764_(result.m_41613_());
                }
                ItemNBTHelper.setCompound(workStack, "BlockEntityTag", tile.m_187481_());
                if (slot.m_5857_(workStack)) {
                    return workStack;
                }
            }
        }
        return null;
    }
}

