/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.content.management.module;

import com.google.common.base.Supplier;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.resources.language.I18n;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import vazkii.quark.base.client.handler.InventoryButtonHandler;
import vazkii.quark.base.module.LoadModule;
import vazkii.quark.base.module.config.Config;
import vazkii.quark.base.network.QuarkNetwork;
import vazkii.quark.base.network.message.InventoryTransferMessage;
import vazkii.quark.content.management.client.screen.widgets.MiniInventoryButton;
import vazkii.zeta.client.event.ZKeyMapping;
import vazkii.zeta.event.bus.LoadEvent;
import vazkii.zeta.module.ZetaModule;

@LoadModule(category="management")
public class EasyTransferingModule
extends ZetaModule {
    public static boolean shiftLocked = false;
    @Config
    public static boolean enableShiftLock = true;

    @LoadEvent
    @OnlyIn(value=Dist.CLIENT)
    public void registerKeybinds(ZKeyMapping event) {
        this.addButton(event, 1, "insert", false);
        this.addButton(event, 2, "extract", true);
        InventoryButtonHandler.addButtonProvider(event, this, InventoryButtonHandler.ButtonTargetType.CONTAINER_PLAYER_INVENTORY, 3, "quark.keybind.shift_lock", screen -> {
            shiftLocked = !shiftLocked;
        }, (parent, x, y) -> new MiniInventoryButton(parent, 4, x, y, "quark.gui.button.shift_lock", b -> {
            shiftLocked = !shiftLocked;
        }).setTextureShift(() -> shiftLocked), (Supplier<Boolean>)((Supplier)() -> enableShiftLock));
    }

    @OnlyIn(value=Dist.CLIENT)
    private void addButton(ZKeyMapping event, int priority, String name, boolean restock) {
        InventoryButtonHandler.addButtonProvider(event, this, InventoryButtonHandler.ButtonTargetType.CONTAINER_PLAYER_INVENTORY, priority, "quark.keybind.transfer_" + name, screen -> QuarkNetwork.sendToServer(new InventoryTransferMessage(Screen.m_96638_(), restock)), (parent, x, y) -> new MiniInventoryButton(parent, priority, x, y, t -> t.add(I18n.m_118938_((String)("quark.gui.button." + name + (Screen.m_96638_() ? "_filtered" : "")), (Object[])new Object[0])), b -> QuarkNetwork.sendToServer(new InventoryTransferMessage(Screen.m_96638_(), restock))).setTextureShift(Screen::m_96638_), null);
    }

    public static boolean hasShiftDown(boolean ret) {
        return ret || enableShiftLock && shiftLocked;
    }
}

