/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.content.management.client.screen.widgets;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.LinkedList;
import java.util.List;
import java.util.function.BooleanSupplier;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.gui.screens.recipebook.RecipeUpdateListener;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import vazkii.quark.base.QuarkClient;
import vazkii.quark.base.handler.MiscUtil;

public class MiniInventoryButton
extends Button {
    private final Consumer<List<String>> tooltip;
    private final int type;
    private final AbstractContainerScreen<?> parent;
    private final int startX;
    private BooleanSupplier shiftTexture = () -> false;

    public MiniInventoryButton(AbstractContainerScreen<?> parent, int type, int x, int y, Consumer<List<String>> tooltip, Button.OnPress onPress) {
        super(parent.getGuiLeft() + x, parent.getGuiTop() + y, 10, 10, (Component)Component.m_237113_((String)""), onPress);
        this.parent = parent;
        this.type = type;
        this.tooltip = tooltip;
        this.startX = x;
    }

    public MiniInventoryButton(AbstractContainerScreen<?> parent, int type, int x, int y, String tooltip, Button.OnPress onPress) {
        this(parent, type, x, y, (List<String> t) -> t.add(I18n.m_118938_((String)tooltip, (Object[])new Object[0])), onPress);
    }

    public MiniInventoryButton setTextureShift(BooleanSupplier func) {
        this.shiftTexture = func;
        return this;
    }

    public void m_6305_(@Nonnull PoseStack matrix, int mouseX, int mouseY, float partialTicks) {
        if (this.parent instanceof RecipeUpdateListener) {
            this.f_93620_ = this.parent.getGuiLeft() + this.startX;
        }
        super.m_6305_(matrix, mouseX, mouseY, partialTicks);
    }

    public void m_6303_(@Nonnull PoseStack matrix, int mouseX, int mouseY, float partialTicks) {
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.m_157456_((int)0, (ResourceLocation)MiscUtil.GENERAL_ICONS);
        RenderSystem.m_69478_();
        RenderSystem.m_69416_((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        RenderSystem.m_69408_((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        int u = this.type * this.f_93618_;
        int v = 25 + (this.f_93622_ ? this.f_93619_ : 0);
        if (this.shiftTexture.getAsBoolean()) {
            v += this.f_93619_ * 2;
        }
        this.m_93228_(matrix, this.f_93620_, this.f_93621_, u, v, this.f_93618_, this.f_93619_);
        if (this.f_93622_) {
            QuarkClient.ZETA_CLIENT.topLayerTooltipHandler.setTooltip(this.getTooltip(), mouseX, mouseY);
        }
    }

    @Nonnull
    protected MutableComponent m_5646_() {
        List<String> tooltip = this.getTooltip();
        return tooltip.isEmpty() ? Component.m_237113_((String)"") : Component.m_237110_((String)"gui.narrate.button", (Object[])new Object[]{this.getTooltip().get(0)});
    }

    public List<String> getTooltip() {
        LinkedList<String> list = new LinkedList<String>();
        this.tooltip.accept(list);
        return list;
    }
}

