/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.content.experimental.module;

import com.google.common.collect.Lists;
import java.util.List;
import net.minecraft.client.renderer.item.ItemProperties;
import net.minecraft.client.renderer.item.ItemPropertyFunction;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import vazkii.quark.base.module.config.Config;
import vazkii.zeta.client.event.ZClientSetup;
import vazkii.zeta.event.bus.LoadEvent;
import vazkii.zeta.module.ZetaLoadModule;
import vazkii.zeta.module.ZetaModule;
import vazkii.zeta.util.RegistryUtil;

@ZetaLoadModule(category="experimental", enabledByDefault=false, description="This feature generates Resource Pack Item Model predicates on the items defined in 'Items to Change'\nfor the Enchantments defined in 'Enchantments to Register'.\n\nExample: if 'minecraft:silk_touch' is added to 'Enchantments to Register', and 'minecraft:netherite_pickaxe'\nis added to 'Items to Change', then a predicate named 'quark_has_enchant_minecraft_silk_touch' will be available\nto the netherite_pickaxe.json item model, whose value will be the enchantment level.")
public class EnchantmentPredicatesModule
extends ZetaModule {
    @Config
    public static List<String> itemsToChange = Lists.newArrayList();
    @Config
    public static List<String> enchantmentsToRegister = Lists.newArrayList();

    @ZetaLoadModule(clientReplacement=true)
    public static class Client
    extends EnchantmentPredicatesModule {
        @LoadEvent
        public void clientSetup(ZClientSetup e) {
            if (this.enabled) {
                e.enqueueWork(() -> {
                    List<Item> items = RegistryUtil.massRegistryGet(itemsToChange, Registry.f_122827_);
                    List<Enchantment> enchants = RegistryUtil.massRegistryGet(enchantmentsToRegister, Registry.f_122825_);
                    for (Enchantment enchant : enchants) {
                        ResourceLocation enchantRes = Registry.f_122825_.m_7981_((Object)enchant);
                        ResourceLocation name = new ResourceLocation("quark_has_enchant_" + enchantRes.m_135827_() + "_" + enchantRes.m_135815_());
                        ItemPropertyFunction fun = (stack, level, entity, i) -> EnchantmentHelper.getTagEnchantmentLevel((Enchantment)enchant, (ItemStack)stack);
                        for (Item item : items) {
                            ItemProperties.register((Item)item, (ResourceLocation)name, (ItemPropertyFunction)fun);
                        }
                    }
                });
            }
        }
    }
}

