/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.content.client.module;

import com.mojang.blaze3d.platform.Window;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ProjectileWeaponItem;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.RenderGuiOverlayEvent;
import net.minecraftforge.client.gui.overlay.VanillaGuiOverlay;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import vazkii.quark.api.IUsageTickerOverride;
import vazkii.quark.api.event.UsageTickerEvent;
import vazkii.quark.base.module.LoadModule;
import vazkii.quark.base.module.config.Config;
import vazkii.zeta.event.ZConfigChanged;
import vazkii.zeta.event.bus.LoadEvent;
import vazkii.zeta.module.ZetaModule;

@LoadModule(category="client", hasSubscriptions=true, subscribeOn={Dist.CLIENT})
public class UsageTickerModule
extends ZetaModule {
    public static List<TickerElement> elements = new ArrayList<TickerElement>();
    @Config(description="Switch the armor display to the off hand side and the hand display to the main hand side")
    public static boolean invert = false;
    @Config
    public static int shiftLeft = 0;
    @Config
    public static int shiftRight = 0;
    @Config
    public static boolean enableMainHand = true;
    @Config
    public static boolean enableOffHand = true;
    @Config
    public static boolean enableArmor = true;

    @LoadEvent
    public final void configChanged(ZConfigChanged event) {
        elements = new ArrayList<TickerElement>();
        if (enableMainHand) {
            elements.add(new TickerElement(EquipmentSlot.MAINHAND));
        }
        if (enableOffHand) {
            elements.add(new TickerElement(EquipmentSlot.OFFHAND));
        }
        if (enableArmor) {
            elements.add(new TickerElement(EquipmentSlot.HEAD));
            elements.add(new TickerElement(EquipmentSlot.CHEST));
            elements.add(new TickerElement(EquipmentSlot.LEGS));
            elements.add(new TickerElement(EquipmentSlot.FEET));
        }
    }

    @SubscribeEvent
    @OnlyIn(value=Dist.CLIENT)
    public void clientTick(TickEvent.ClientTickEvent event) {
        if (event.phase == TickEvent.Phase.START) {
            Minecraft mc = Minecraft.m_91087_();
            if (mc.f_91074_ != null && mc.f_91073_ != null) {
                for (TickerElement ticker : elements) {
                    if (ticker == null) continue;
                    ticker.tick((Player)mc.f_91074_);
                }
            }
        }
    }

    @SubscribeEvent
    @OnlyIn(value=Dist.CLIENT)
    public void renderHUD(RenderGuiOverlayEvent.Post event) {
        if (event.getOverlay() == VanillaGuiOverlay.HOTBAR.type()) {
            Window window = event.getWindow();
            LocalPlayer player = Minecraft.m_91087_().f_91074_;
            float partial = event.getPartialTick();
            for (TickerElement ticker : elements) {
                if (ticker == null) continue;
                ticker.render(window, (Player)player, invert, partial);
            }
        }
    }

    public static class TickerElement {
        private static final int MAX_TIME = 60;
        private static final int ANIM_TIME = 5;
        public int liveTicks;
        public final EquipmentSlot slot;
        public ItemStack currStack = ItemStack.f_41583_;
        public ItemStack currRealStack = ItemStack.f_41583_;
        public int currCount;

        public TickerElement(EquipmentSlot slot) {
            this.slot = slot;
        }

        @OnlyIn(value=Dist.CLIENT)
        public void tick(Player player) {
            int count;
            ItemStack realStack = this.getStack(player);
            ItemStack displayedStack = this.getLogicalStack(realStack, count = this.getStackCount(player, realStack, realStack, false), player, false);
            if (displayedStack.m_41619_()) {
                this.liveTicks = 0;
            } else if (this.shouldChange(realStack, this.currRealStack, count, this.currCount) || this.shouldChange(displayedStack, this.currStack, count, this.currCount)) {
                boolean animatingOut;
                boolean done = this.liveTicks == 0;
                boolean animatingIn = this.liveTicks > 55;
                boolean bl = animatingOut = this.liveTicks < 5 && !done;
                if (animatingOut) {
                    this.liveTicks = 60 - this.liveTicks;
                } else if (!animatingIn) {
                    this.liveTicks = !done ? 55 : 60;
                }
            } else if (this.liveTicks > 0) {
                --this.liveTicks;
            }
            this.currCount = count;
            this.currStack = displayedStack;
            this.currRealStack = realStack;
        }

        @OnlyIn(value=Dist.CLIENT)
        public void render(Window window, Player player, boolean invert, float partialTicks) {
            if (this.liveTicks > 0) {
                float mul;
                float animProgress = this.liveTicks < 5 ? Math.max(0.0f, (float)this.liveTicks - partialTicks) / 5.0f : Math.min(5.0f, (float)(60 - this.liveTicks) + partialTicks) / 5.0f;
                float anim = -animProgress * (animProgress - 2.0f) * 20.0f;
                float x = (float)window.m_85445_() / 2.0f;
                float y = (float)window.m_85446_() - anim;
                int barWidth = 190;
                boolean armor = this.slot.m_20743_() == EquipmentSlot.Type.ARMOR;
                HumanoidArm primary = player.m_5737_();
                HumanoidArm ourSide = armor != invert ? primary : primary.m_20828_();
                int slots = armor ? 4 : 2;
                int index = slots - this.slot.m_20749_() - 1;
                float f = mul = ourSide == HumanoidArm.LEFT ? -1.0f : 1.0f;
                if (ourSide != primary && !player.m_21120_(InteractionHand.OFF_HAND).m_41619_()) {
                    barWidth += 58;
                }
                Minecraft mc = Minecraft.m_91087_();
                x += (float)barWidth / 2.0f * mul + (float)(index * 20);
                if (ourSide == HumanoidArm.LEFT) {
                    x -= (float)(slots * 20);
                    x += (float)shiftLeft;
                } else {
                    x += (float)shiftRight;
                }
                ItemStack stack = this.getRenderedStack(player);
                mc.m_91291_().m_115203_(stack, (int)x, (int)y);
                mc.m_91291_().m_115169_(Minecraft.m_91087_().f_91062_, stack, (int)x, (int)y);
            }
        }

        @OnlyIn(value=Dist.CLIENT)
        public boolean shouldChange(ItemStack currStack, ItemStack prevStack, int currentTotal, int pastTotal) {
            return !prevStack.m_41656_(currStack) || currStack.m_41763_() && currStack.m_41773_() != prevStack.m_41773_() || currentTotal != pastTotal;
        }

        @OnlyIn(value=Dist.CLIENT)
        public ItemStack getStack(Player player) {
            return player.m_6844_(this.slot);
        }

        @OnlyIn(value=Dist.CLIENT)
        public ItemStack getLogicalStack(ItemStack stack, int count, Player player, boolean renderPass) {
            boolean verifySize = true;
            ItemStack returnStack = stack;
            boolean logicLock = false;
            Item item = stack.m_41720_();
            if (item instanceof IUsageTickerOverride) {
                IUsageTickerOverride over = (IUsageTickerOverride)item;
                returnStack = stack = over.getUsageTickerItem(stack);
                verifySize = over.shouldUsageTickerCheckMatchSize(this.currStack);
            } else if (TickerElement.isProjectileWeapon(stack)) {
                returnStack = player.m_6298_(stack);
                logicLock = true;
            }
            if (!logicLock) {
                if (!stack.m_41753_() && this.slot.m_20743_() == EquipmentSlot.Type.HAND) {
                    returnStack = ItemStack.f_41583_;
                } else if (verifySize && stack.m_41753_() && count == stack.m_41613_()) {
                    returnStack = ItemStack.f_41583_;
                }
            }
            UsageTickerEvent.GetStack event = new UsageTickerEvent.GetStack(this.slot, returnStack, stack, count, renderPass, player);
            MinecraftForge.EVENT_BUS.post((Event)event);
            return event.isCanceled() ? ItemStack.f_41583_ : event.getResultStack();
        }

        @OnlyIn(value=Dist.CLIENT)
        public int getStackCount(Player player, ItemStack displayStack, ItemStack original, boolean renderPass) {
            int val = 1;
            if (displayStack.m_41753_()) {
                Predicate<ItemStack> predicate = stackAt -> ItemStack.m_150942_((ItemStack)stackAt, (ItemStack)displayStack);
                int total = 0;
                Inventory inventory = player.m_150109_();
                for (int i = 0; i < inventory.m_6643_(); ++i) {
                    ItemStack stackAt2 = inventory.m_8020_(i);
                    if (predicate.test(stackAt2)) {
                        total += stackAt2.m_41613_();
                        continue;
                    }
                    Item item = stackAt2.m_41720_();
                    if (!(item instanceof IUsageTickerOverride)) continue;
                    IUsageTickerOverride over = (IUsageTickerOverride)item;
                    total += over.getUsageTickerCountForItem(stackAt2, predicate);
                }
                val = Math.max(total, displayStack.m_41613_());
            }
            UsageTickerEvent.GetCount event = new UsageTickerEvent.GetCount(this.slot, displayStack, original, val, renderPass, player);
            MinecraftForge.EVENT_BUS.post((Event)event);
            return event.isCanceled() ? 0 : event.getResultCount();
        }

        private static boolean isProjectileWeapon(ItemStack stack) {
            return stack.m_41720_() instanceof ProjectileWeaponItem && stack.getEnchantmentLevel(Enchantments.f_44952_) == 0;
        }

        @OnlyIn(value=Dist.CLIENT)
        public ItemStack getRenderedStack(Player player) {
            int count;
            ItemStack stack = this.getStack(player);
            ItemStack logicalStack = this.getLogicalStack(stack, count = this.getStackCount(player, stack, stack, true), player, true).m_41777_();
            if (logicalStack != stack) {
                count = this.getStackCount(player, logicalStack, stack, true);
            }
            logicalStack.m_41764_(count);
            if (logicalStack.m_41619_()) {
                return ItemStack.f_41583_;
            }
            return logicalStack;
        }
    }
}

