/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.content.client.module;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.Locale;
import java.util.Map;
import java.util.function.BiPredicate;
import java.util.regex.Pattern;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.gui.screens.inventory.InventoryScreen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Registry;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.EmptyHandler;
import org.jetbrains.annotations.Nullable;
import vazkii.quark.api.IQuarkButtonAllowed;
import vazkii.quark.base.client.handler.InventoryButtonHandler;
import vazkii.quark.base.handler.GeneralConfig;
import vazkii.quark.base.handler.InventoryTransferHandler;
import vazkii.quark.base.handler.MiscUtil;
import vazkii.quark.base.handler.SimilarBlockTypeHandler;
import vazkii.quark.base.module.config.Config;
import vazkii.quark.base.module.config.type.inputtable.RGBAColorConfig;
import vazkii.quark.content.management.client.screen.widgets.MiniInventoryButton;
import vazkii.zeta.client.event.ZClientSetup;
import vazkii.zeta.client.event.ZRenderContainerScreen;
import vazkii.zeta.client.event.ZScreenCharacterTyped;
import vazkii.zeta.client.event.ZScreenInit;
import vazkii.zeta.client.event.ZScreenKeyPressed;
import vazkii.zeta.client.event.ZScreenMousePressed;
import vazkii.zeta.event.bus.LoadEvent;
import vazkii.zeta.event.bus.PlayEvent;
import vazkii.zeta.module.ZetaLoadModule;
import vazkii.zeta.module.ZetaModule;
import vazkii.zeta.util.ItemNBTHelper;

@ZetaLoadModule(category="client")
public class ChestSearchingModule
extends ZetaModule {
    @Config
    public RGBAColorConfig overlayColor = RGBAColorConfig.forColor(0.0, 0.0, 0.0, 0.67);

    public boolean searchBarShown() {
        return false;
    }

    public boolean namesMatch(ItemStack stack) {
        return false;
    }

    @ZetaLoadModule(clientReplacement=true)
    public static class Client
    extends ChestSearchingModule {
        private EditBox searchBar;
        private String text = "";
        public boolean searchEnabled = false;
        private long lastClick;
        private int matched;

        @Override
        public boolean searchBarShown() {
            return this.searchEnabled;
        }

        @LoadEvent
        public final void clientSetup(ZClientSetup event) {
            InventoryButtonHandler.addButtonProvider(this, InventoryButtonHandler.ButtonTargetType.CONTAINER_INVENTORY, 1, (parent, x, y) -> new MiniInventoryButton(parent, 3, x, y, "quark.gui.button.filter", b -> {
                if (this.searchBar != null) {
                    this.searchEnabled = !this.searchEnabled;
                    this.updateSearchStatus();
                    this.searchBar.m_94178_(true);
                }
            }).setTextureShift(() -> this.searchEnabled), null);
        }

        @PlayEvent
        public void initGui(ZScreenInit.Post event) {
            Screen gui = event.getScreen();
            boolean apiAllowed = gui instanceof IQuarkButtonAllowed;
            if (!(gui instanceof InventoryScreen) && gui instanceof AbstractContainerScreen) {
                AbstractContainerScreen chest = (AbstractContainerScreen)gui;
                if (apiAllowed || GeneralConfig.isScreenAllowed(gui)) {
                    Minecraft mc = gui.getMinecraft();
                    if (apiAllowed || InventoryTransferHandler.accepts(chest.m_6262_(), (Player)mc.f_91074_)) {
                        this.searchBar = new EditBox(mc.f_91062_, 18, 6, 117, 10, (Component)Component.m_237113_((String)this.text));
                        this.searchBar.m_94144_(this.text);
                        this.searchBar.m_94199_(50);
                        this.searchBar.m_94182_(false);
                        this.updateSearchStatus();
                        return;
                    }
                }
            }
            this.searchBar = null;
        }

        private void updateSearchStatus() {
            if (this.searchBar != null) {
                this.searchBar.m_94186_(this.searchEnabled);
                this.searchBar.m_94194_(this.searchEnabled);
                if (!this.searchEnabled) {
                    this.searchBar.m_94178_(false);
                }
            }
        }

        @PlayEvent
        public void charTyped(ZScreenCharacterTyped.Pre event) {
            if (this.searchBar != null && this.searchBar.m_93696_() && this.searchEnabled) {
                this.searchBar.m_5534_(event.getCodePoint(), event.getModifiers());
                this.text = this.searchBar.m_94155_();
                event.setCanceled(true);
            }
        }

        @PlayEvent
        public void onKeypress(ZScreenKeyPressed.Pre event) {
            if (this.searchBar != null && this.searchBar.m_93696_() && this.searchEnabled) {
                this.searchBar.m_7933_(event.getKeyCode(), event.getScanCode(), event.getModifiers());
                this.text = this.searchBar.m_94155_();
                event.setCanceled(event.getKeyCode() != 256);
            }
        }

        @PlayEvent
        public void onClick(ZScreenMousePressed.Pre event) {
            Screen screen;
            if (this.searchBar != null && this.searchEnabled && (screen = event.getScreen()) instanceof AbstractContainerScreen) {
                AbstractContainerScreen containerScreen = (AbstractContainerScreen)screen;
                this.searchBar.m_6375_(event.getMouseX() - (double)containerScreen.getGuiLeft(), event.getMouseY() - (double)containerScreen.getGuiTop(), event.getButton());
                long time = System.currentTimeMillis();
                long delta = time - this.lastClick;
                if (delta < 200L && this.searchBar.m_93696_()) {
                    this.searchBar.m_94144_("");
                    this.text = "";
                }
                this.lastClick = time;
            }
        }

        @PlayEvent
        public void renderForeground(ZRenderContainerScreen.Foreground event) {
            if (this.searchBar != null && this.searchEnabled) {
                PoseStack matrix = event.getPoseStack();
                AbstractContainerScreen<?> gui = event.getContainerScreen();
                matrix.m_85836_();
                this.drawBackground(matrix, (Screen)gui, this.searchBar.f_93620_ - 11, this.searchBar.f_93621_ - 3);
                if (!this.text.isEmpty()) {
                    AbstractContainerMenu container = gui.m_6262_();
                    this.matched = 0;
                    for (Slot s : container.f_38839_) {
                        if (!s.m_6659_()) continue;
                        ItemStack stack = s.m_7993_();
                        if (!this.namesMatch(stack, this.text)) {
                            int x = s.f_40220_;
                            int y = s.f_40221_;
                            Screen.m_93172_((PoseStack)matrix, (int)x, (int)y, (int)(x + 16), (int)(y + 16), (int)this.overlayColor.getColor());
                            continue;
                        }
                        ++this.matched;
                    }
                }
                if (this.matched == 0 && !this.text.isEmpty()) {
                    this.searchBar.m_94202_(0xFF5555);
                } else {
                    this.searchBar.m_94202_(0xFFFFFF);
                }
                this.searchBar.m_6305_(matrix, 0, 0, 0.0f);
                matrix.m_85849_();
            }
        }

        private void drawBackground(PoseStack matrix, Screen gui, int x, int y) {
            if (gui == null) {
                return;
            }
            RenderSystem.m_157427_(GameRenderer::m_172817_);
            RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            RenderSystem.m_157456_((int)0, (ResourceLocation)MiscUtil.GENERAL_ICONS);
            Screen.m_93133_((PoseStack)matrix, (int)x, (int)y, (float)0.0f, (float)0.0f, (int)126, (int)13, (int)256, (int)256);
        }

        @Override
        public boolean namesMatch(ItemStack stack) {
            return !this.searchEnabled || this.namesMatch(stack, this.text);
        }

        /*
         * WARNING - void declaration
         */
        public boolean namesMatch(ItemStack stack, String search) {
            CompoundTag cmp;
            if ((search = ChatFormatting.m_126649_((String)search.trim().toLowerCase(Locale.ROOT))) == null || search.isEmpty()) {
                return true;
            }
            if (stack.m_41619_()) {
                return false;
            }
            Item item = stack.m_41720_();
            ResourceLocation res = Registry.f_122827_.m_7981_((Object)item);
            if (SimilarBlockTypeHandler.isShulkerBox(res) && (cmp = ItemNBTHelper.getCompound(stack, "BlockEntityTag", true)) != null) {
                LazyOptional handler;
                BlockEntity te;
                if (!cmp.m_128441_("id")) {
                    cmp = cmp.m_6426_();
                    cmp.m_128359_("id", "minecraft:shulker_box");
                }
                if ((te = BlockEntity.m_155241_((BlockPos)BlockPos.f_121853_, (BlockState)((BlockItem)item).m_40614_().m_49966_(), (CompoundTag)cmp)) != null && (handler = te.getCapability(ForgeCapabilities.ITEM_HANDLER, null)).isPresent()) {
                    void var9_10;
                    IItemHandler items = (IItemHandler)handler.orElseGet(EmptyHandler::new);
                    boolean bl = false;
                    while (var9_10 < items.getSlots()) {
                        if (this.namesMatch(items.getStackInSlot((int)var9_10), search)) {
                            return true;
                        }
                        ++var9_10;
                    }
                }
            }
            String name = stack.m_41786_().getString();
            name = ChatFormatting.m_126649_((String)name.trim().toLowerCase(Locale.ROOT));
            StringMatcher matcher = String::contains;
            if (search.length() >= 3 && search.startsWith("\"") && search.endsWith("\"")) {
                search = search.substring(1, search.length() - 1);
                matcher = String::equals;
            }
            if (search.length() >= 3 && search.startsWith("/") && search.endsWith("/")) {
                search = search.substring(1, search.length() - 1);
                matcher = (s1, s2) -> Pattern.compile(s2).matcher((CharSequence)s1).find();
            }
            if (stack.m_41793_()) {
                Map enchants = EnchantmentHelper.m_44831_((ItemStack)stack);
                for (Enchantment enchantment : enchants.keySet()) {
                    if (enchantment == null || !matcher.test(enchantment.m_44700_(((Integer)enchants.get(enchantment)).intValue()).toString().toLowerCase(Locale.ROOT), search)) continue;
                    return true;
                }
            }
            ArrayList potionNames = new ArrayList();
            PotionUtils.m_43555_((ItemStack)stack, potionNames, (float)1.0f);
            for (Component component : potionNames) {
                if (!matcher.test(ChatFormatting.m_126649_((String)component.toString().trim().toLowerCase(Locale.ROOT)), search)) continue;
                return true;
            }
            for (Map.Entry entry : EnchantmentHelper.m_44831_((ItemStack)stack).entrySet()) {
                int lvl = (Integer)entry.getValue();
                Enchantment e = (Enchantment)entry.getKey();
                if (e == null || !matcher.test(e.m_44700_(lvl).toString().toLowerCase(Locale.ROOT), search)) continue;
                return true;
            }
            CreativeModeTab tab = item.m_41471_();
            if (tab != null && matcher.test(tab.m_40786_().getString().toLowerCase(Locale.ROOT), search)) {
                return true;
            }
            ResourceLocation resourceLocation = Registry.f_122827_.m_7981_((Object)item);
            @Nullable String modDisplayName = this.zeta.getModDisplayName(resourceLocation.m_135827_());
            if (modDisplayName != null && matcher.test(modDisplayName.toLowerCase(Locale.ROOT), search)) {
                return true;
            }
            return matcher.test(name, search);
        }

        private static interface StringMatcher
        extends BiPredicate<String, String> {
        }
    }
}

