/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.content.building.module;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import vazkii.quark.api.ICrawlSpaceBlock;
import vazkii.quark.base.handler.advancement.QuarkAdvancementHandler;
import vazkii.quark.base.handler.advancement.QuarkGenericTrigger;
import vazkii.quark.base.module.LoadModule;
import vazkii.quark.base.module.config.Config;
import vazkii.quark.base.module.hint.Hint;
import vazkii.quark.base.util.VanillaWoods;
import vazkii.quark.content.building.block.HollowLogBlock;
import vazkii.zeta.event.ZCommonSetup;
import vazkii.zeta.event.ZRegister;
import vazkii.zeta.event.bus.LoadEvent;
import vazkii.zeta.module.ZetaModule;

@LoadModule(category="building", hasSubscriptions=true)
public class HollowLogsModule
extends ZetaModule {
    private static final String TAG_TRYING_TO_CRAWL = "quark:trying_crawl";
    public static QuarkGenericTrigger crawlTrigger;
    @Config(flag="hollow_log_auto_crawl")
    public static boolean enableAutoCrawl;
    @Hint(key="hollow_logs", value="hollow_log_auto_crawl")
    TagKey<Block> hollowLogsTag;

    @LoadEvent
    public final void register(ZRegister event) {
        for (VanillaWoods.Wood wood : VanillaWoods.ALL) {
            new HollowLogBlock(wood.log(), this, !wood.nether());
        }
        crawlTrigger = QuarkAdvancementHandler.registerGenericTrigger("hollow_log_crawl");
    }

    @LoadEvent
    public final void setup(ZCommonSetup event) {
        this.hollowLogsTag = BlockTags.create((ResourceLocation)new ResourceLocation("quark", "hollow_logs"));
    }

    @SubscribeEvent
    public void playerTick(TickEvent.PlayerTickEvent event) {
        if (enableAutoCrawl && event.phase == TickEvent.Phase.START) {
            Player player = event.player;
            BlockPos playerPos = player.m_20183_();
            boolean isTrying = player.m_20143_() || player.m_6047_() && !player.m_20039_(playerPos, player.f_19853_.m_8055_(playerPos));
            boolean wasTrying = player.getPersistentData().m_128471_(TAG_TRYING_TO_CRAWL);
            if (!player.m_20143_() && isTrying && !wasTrying) {
                Direction dir = player.m_6350_();
                Direction opp = dir.m_122424_();
                if (dir.m_122434_() != Direction.Axis.Y) {
                    BlockPos pos = playerPos.m_121945_(dir);
                    if (!(this.tryClimb(player, opp, playerPos) || this.tryClimb(player, opp, playerPos.m_7494_()) || this.tryClimb(player, dir, pos))) {
                        this.tryClimb(player, dir, pos.m_7494_());
                    }
                }
            }
            if (isTrying != wasTrying) {
                player.getPersistentData().m_128379_(TAG_TRYING_TO_CRAWL, isTrying);
            }
        }
    }

    private boolean tryClimb(Player player, Direction dir, BlockPos pos) {
        ICrawlSpaceBlock crawlSpace;
        BlockState state = player.f_19853_.m_8055_(pos);
        Block block = state.m_60734_();
        if (block instanceof ICrawlSpaceBlock && (crawlSpace = (ICrawlSpaceBlock)block).canCrawl(player.f_19853_, state, pos, dir)) {
            ServerPlayer sp;
            player.m_20124_(Pose.SWIMMING);
            player.m_20282_(true);
            double x = (double)pos.m_123341_() + 0.5 - (double)dir.m_122429_() * 0.3;
            double y = (double)pos.m_123342_() + crawlSpace.crawlHeight(player.f_19853_, state, pos, dir);
            double z = (double)pos.m_123343_() + 0.5 - (double)dir.m_122431_() * 0.3;
            player.m_6034_(x, y, z);
            if (player instanceof ServerPlayer && crawlSpace.isLog(sp = (ServerPlayer)player, state, pos, dir)) {
                crawlTrigger.trigger(sp);
            }
            return true;
        }
        return false;
    }

    static {
        enableAutoCrawl = true;
    }
}

