/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.content.building.module;

import com.google.common.collect.Lists;
import java.util.List;
import java.util.function.BooleanSupplier;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.ComposterBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.level.material.MaterialColor;
import net.minecraftforge.common.ToolActions;
import vazkii.quark.base.block.QuarkBlock;
import vazkii.quark.base.block.QuarkFlammableBlock;
import vazkii.quark.base.block.QuarkFlammablePillarBlock;
import vazkii.quark.base.block.QuarkPillarBlock;
import vazkii.quark.base.handler.FuelHandler;
import vazkii.quark.base.handler.ToolInteractionHandler;
import vazkii.quark.base.module.LoadModule;
import vazkii.quark.base.module.config.Config;
import vazkii.quark.base.module.hint.Hint;
import vazkii.zeta.event.ZLoadComplete;
import vazkii.zeta.event.ZRegister;
import vazkii.zeta.event.bus.LoadEvent;
import vazkii.zeta.module.ZetaModule;

@LoadModule(category="building")
public class CompressedBlocksModule
extends ZetaModule {
    @Config(name="Charcoal Block and Blaze Lantern Stay On Fire Forever", flag="compressed_blocks_burn_forever")
    public static boolean burnsForever = true;
    @Config(name="Charcoal Block Fuel Time")
    @Config.Min(value=0.0)
    public static int charcoalBlockFuelTime = 16000;
    @Config(name="Blaze Lantern Fuel Time")
    @Config.Min(value=0.0)
    public static int blazeLanternFuelTime = 24000;
    @Config(name="Stick Block Fuel Time")
    @Config.Min(value=0.0)
    public static int stickBlockFuelTime = 900;
    @Config(name="Bamboo Block Fuel Time")
    @Config.Min(value=0.0)
    public static int bambooBundleFuelTime = 500;
    @Config(flag="charcoal_block")
    public static boolean enableCharcoalBlock = true;
    @Config(flag="sugar_cane_block")
    public static boolean enableSugarCaneBlock = true;
    @Config(flag="bamboo_block")
    public static boolean enableBambooBlock = true;
    @Config(flag="cactus_block")
    public static boolean enableCactusBlock = true;
    @Config(flag="chorus_fruit_block")
    public static boolean enableChorusFruitBlock = true;
    @Config(flag="stick_block")
    public static boolean enableStickBlock = true;
    @Config(flag="apple_crate")
    public static boolean enableAppleCrate = true;
    @Config(flag="golden_apple_crate")
    public static boolean enableGoldenAppleCrate = true;
    @Config(flag="potato_crate")
    public static boolean enablePotatoCrate = true;
    @Config(flag="carrot_crate")
    public static boolean enableCarrotCrate = true;
    @Config(flag="golden_carrot_crate")
    public static boolean enableGoldenCarrotCrate = true;
    @Config(flag="beetroot_crate")
    public static boolean enableBeetrootCrate = true;
    @Config(flag="cocoa_beans_sack")
    public static boolean enableCocoaBeanSack = true;
    @Config(flag="nether_wart_sack")
    public static boolean enableNetherWartSack = true;
    @Config(flag="gunpowder_sack")
    public static boolean enableGunpowderSack = true;
    @Config(flag="berry_sack")
    public static boolean enableBerrySack = true;
    @Config(flag="glowberry_sack")
    public static boolean enableGlowBerrySack = true;
    @Config(flag="blaze_lantern")
    public static boolean enableBlazeLantern = true;
    @Config(flag="bonded_leather")
    public static boolean enableBondedLeather = true;
    @Config(flag="bonded_rabbit_hide")
    public static boolean enableBondedRabbitHide = true;
    @Hint(value="compressed_blocks_burn_forever")
    public static Block charcoal_block;
    @Hint(value="compressed_blocks_burn_forever")
    public static Block blaze_lantern;
    @Hint(value="golden_apple_crate")
    public static Block golden_apple_crate;
    public static Block stick_block;
    public static Block bamboo_bundle;
    private final List<Block> compostable = Lists.newArrayList();

    @LoadEvent
    public final void register(ZRegister event) {
        charcoal_block = new QuarkBlock("charcoal_block", this, CreativeModeTab.f_40749_, BlockBehaviour.Properties.m_60944_((Material)Material.f_76278_, (MaterialColor)MaterialColor.f_76365_).m_60999_().m_60913_(5.0f, 10.0f).m_60918_(SoundType.f_56742_)).setCondition(() -> enableCharcoalBlock);
        bamboo_bundle = this.pillar("sugar_cane", MaterialColor.f_76417_, true, () -> enableSugarCaneBlock, 200);
        Block bamboo = this.pillar("bamboo", MaterialColor.f_76363_, false, () -> enableBambooBlock, 200);
        Block stripped_bamboo = this.pillar("stripped_bamboo", MaterialColor.f_76416_, false, () -> enableBambooBlock, 200);
        this.pillar("cactus", MaterialColor.f_76363_, true, () -> enableCactusBlock, 50);
        this.pillar("chorus_fruit", MaterialColor.f_76422_, false, () -> enableChorusFruitBlock, 10);
        stick_block = this.pillar("stick", MaterialColor.f_76411_, false, () -> enableStickBlock, 300);
        golden_apple_crate = this.crate("golden_apple", MaterialColor.f_76366_, false, () -> enableGoldenAppleCrate);
        this.crate("apple", MaterialColor.f_76364_, true, () -> enableAppleCrate);
        this.crate("potato", MaterialColor.f_76413_, true, () -> enablePotatoCrate);
        this.crate("carrot", MaterialColor.f_76373_, true, () -> enableCarrotCrate);
        this.crate("golden_carrot", MaterialColor.f_76366_, false, () -> enableGoldenCarrotCrate);
        this.crate("beetroot", MaterialColor.f_76364_, true, () -> enableBeetrootCrate);
        this.sack("cocoa_beans", MaterialColor.f_76362_, true, () -> enableCocoaBeanSack);
        this.sack("nether_wart", MaterialColor.f_76364_, true, () -> enableNetherWartSack);
        this.sack("gunpowder", MaterialColor.f_76419_, false, () -> enableGunpowderSack);
        this.sack("berry", MaterialColor.f_76364_, true, () -> enableBerrySack);
        this.sack("glowberry", MaterialColor.f_76416_, 14, true, () -> enableGlowBerrySack);
        blaze_lantern = new QuarkBlock("blaze_lantern", this, CreativeModeTab.f_40749_, BlockBehaviour.Properties.m_60941_((Material)Material.f_76275_, (DyeColor)DyeColor.YELLOW).m_60978_(0.3f).m_60918_(SoundType.f_56744_).m_60953_(b -> 15)).setCondition(() -> enableBlazeLantern);
        new QuarkBlock("bonded_leather", this, CreativeModeTab.f_40749_, BlockBehaviour.Properties.m_60941_((Material)Material.f_76272_, (DyeColor)DyeColor.ORANGE).m_60978_(0.4f).m_60918_(SoundType.f_56745_)).setCondition(() -> enableBondedLeather);
        new QuarkBlock("bonded_rabbit_hide", this, CreativeModeTab.f_40749_, BlockBehaviour.Properties.m_60941_((Material)Material.f_76272_, (DyeColor)DyeColor.WHITE).m_60978_(0.4f).m_60918_(SoundType.f_56745_)).setCondition(() -> enableBondedRabbitHide);
        ToolInteractionHandler.registerInteraction(ToolActions.AXE_STRIP, bamboo, stripped_bamboo);
    }

    @LoadEvent
    public void loadComplete(ZLoadComplete event) {
        event.enqueueWork(() -> {
            for (Block block : this.compostable) {
                if (block.m_5456_() == null) continue;
                ComposterBlock.f_51914_.put((Object)block.m_5456_(), 1.0f);
            }
        });
        FuelHandler.addFuel(stick_block, stickBlockFuelTime);
        FuelHandler.addFuel(charcoal_block, charcoalBlockFuelTime);
        FuelHandler.addFuel(blaze_lantern, blazeLanternFuelTime);
        FuelHandler.addFuel(bamboo_bundle, bambooBundleFuelTime);
    }

    private Block pillar(String name, MaterialColor color, boolean compost, BooleanSupplier cond, int flammability) {
        QuarkPillarBlock block = new QuarkFlammablePillarBlock(name + "_block", this, CreativeModeTab.f_40749_, flammability, BlockBehaviour.Properties.m_60944_((Material)Material.f_76320_, (MaterialColor)color).m_60978_(0.5f).m_60918_(SoundType.f_56736_)).setCondition(cond);
        if (compost) {
            this.compostable.add((Block)block);
        }
        return block;
    }

    private Block crate(String name, MaterialColor color, boolean compost, BooleanSupplier cond) {
        QuarkBlock block = new QuarkFlammableBlock(name + "_crate", this, CreativeModeTab.f_40750_, 150, BlockBehaviour.Properties.m_60944_((Material)Material.f_76320_, (MaterialColor)color).m_60978_(1.5f).m_60918_(SoundType.f_56736_)).setCondition(cond);
        if (compost) {
            this.compostable.add(block);
        }
        return block;
    }

    private Block sack(String name, MaterialColor color, boolean compost, BooleanSupplier cond) {
        return this.sack(name, color, 0, compost, cond);
    }

    private Block sack(String name, MaterialColor color, int light, boolean compost, BooleanSupplier cond) {
        QuarkBlock block = new QuarkFlammableBlock(name + "_sack", this, CreativeModeTab.f_40750_, 150, BlockBehaviour.Properties.m_60944_((Material)Material.f_76272_, (MaterialColor)color).m_60978_(0.5f).m_60953_(s -> light).m_60918_(SoundType.f_56745_)).setCondition(cond);
        if (compost) {
            this.compostable.add(block);
        }
        return block;
    }
}

