/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.content.building.block;

import java.util.function.BooleanSupplier;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LadderBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import vazkii.quark.base.Quark;
import vazkii.quark.base.block.IQuarkBlock;
import vazkii.quark.base.handler.CreativeTabHandler;
import vazkii.quark.base.handler.RenderLayerHandler;
import vazkii.zeta.module.ZetaModule;

public class VariantLadderBlock
extends LadderBlock
implements IQuarkBlock {
    private final ZetaModule module;
    private final boolean flammable;
    private BooleanSupplier condition = () -> true;

    public VariantLadderBlock(String type, ZetaModule module, BlockBehaviour.Properties props, boolean flammable) {
        super(props);
        Quark.ZETA.registry.registerBlock((Block)this, type + "_ladder", true);
        CreativeTabHandler.addTab(this, CreativeModeTab.f_40750_);
        this.module = module;
        RenderLayerHandler.setRenderType((Block)this, RenderLayerHandler.RenderTypeSkeleton.CUTOUT);
        this.flammable = flammable;
    }

    public VariantLadderBlock(String type, ZetaModule module, boolean flammable) {
        this(type, module, BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50155_), flammable);
    }

    public boolean isFlammable(BlockState state, BlockGetter world, BlockPos pos, Direction face) {
        return this.flammable;
    }

    public void m_49811_(@Nonnull CreativeModeTab group, @Nonnull NonNullList<ItemStack> items) {
        if (this.isEnabled() || group == CreativeModeTab.f_40754_) {
            super.m_49811_(group, items);
        }
    }

    @Override
    public ZetaModule getModule() {
        return this.module;
    }

    @Override
    public VariantLadderBlock setCondition(BooleanSupplier condition) {
        this.condition = condition;
        return this;
    }

    @Override
    public boolean doesConditionApply() {
        return this.condition.getAsBoolean();
    }
}

